/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.query.calcite.rule.logical;

import com.google.common.collect.ImmutableMap;
import java.util.BitSet;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.apache.calcite.plan.RelOptCluster;
import org.apache.calcite.plan.RelOptRule;
import org.apache.calcite.plan.RelOptRuleCall;
import org.apache.calcite.plan.RelOptUtil;
import org.apache.calcite.plan.RelRule;
import org.apache.calcite.plan.RelTraitSet;
import org.apache.calcite.rel.RelFieldCollation;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.type.RelDataTypeFactory;
import org.apache.calcite.rex.RexBuilder;
import org.apache.calcite.rex.RexLocalRef;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.rex.RexShuttle;
import org.apache.calcite.rex.RexUtil;
import org.apache.calcite.sql.SqlKind;
import org.apache.calcite.tools.RelBuilder;
import org.apache.calcite.util.mapping.Mappings;
import org.apache.ignite.internal.processors.query.calcite.rel.logical.IgniteLogicalTableScan;
import org.apache.ignite.internal.processors.query.calcite.rule.logical.ImmutableLogicalOrToUnionRule;
import org.apache.ignite.internal.processors.query.calcite.rule.logical.RuleFactoryConfig;
import org.apache.ignite.internal.processors.query.calcite.schema.IgniteIndex;
import org.apache.ignite.internal.processors.query.calcite.schema.IgniteTable;
import org.apache.ignite.internal.processors.query.calcite.type.IgniteTypeFactory;
import org.apache.ignite.internal.processors.query.calcite.util.Commons;
import org.apache.ignite.internal.util.typedef.F;
import org.immutables.value.Value;
import org.jetbrains.annotations.Nullable;

@Value.Enclosing
public class LogicalOrToUnionRule
extends RelRule<Config> {
    public static final RelOptRule INSTANCE = new LogicalOrToUnionRule(Config.SCAN);

    private LogicalOrToUnionRule(Config config) {
        super((RelRule.Config)config);
    }

    public void onMatch(RelOptRuleCall call) {
        RelOptCluster cluster = call.rel(0).getCluster();
        List<RexNode> operands = LogicalOrToUnionRule.getOrOperands(cluster.getRexBuilder(), this.getCondition(call));
        if (operands == null) {
            return;
        }
        if (!this.idxCollationCheck(call, operands)) {
            return;
        }
        RelNode input = this.getInput(call);
        RelNode rel0 = this.createUnionAll(cluster, input, operands.get(0), operands.get(1));
        RelNode rel1 = this.createUnionAll(cluster, input, operands.get(1), operands.get(0));
        call.transformTo(rel0, (Map)ImmutableMap.of((Object)rel1, (Object)rel0));
    }

    private RexNode getCondition(RelOptRuleCall call) {
        IgniteLogicalTableScan rel = (IgniteLogicalTableScan)call.rel(0);
        return rel.condition();
    }

    private RelNode getInput(RelOptRuleCall call) {
        return call.rel(0);
    }

    private boolean idxCollationCheck(RelOptRuleCall call, List<RexNode> operands) {
        IgniteLogicalTableScan scan = (IgniteLogicalTableScan)call.rel(0);
        IgniteTable tbl = (IgniteTable)scan.getTable().unwrap(IgniteTable.class);
        IgniteTypeFactory typeFactory = Commons.typeFactory(scan.getCluster());
        int fieldCnt = tbl.getRowType((RelDataTypeFactory)typeFactory).getFieldCount();
        BitSet idxsFirstFields = new BitSet(fieldCnt);
        for (IgniteIndex idx : tbl.indexes().values()) {
            List fieldCollations = idx.collation().getFieldCollations();
            if (F.isEmpty((Collection)fieldCollations)) continue;
            idxsFirstFields.set(((RelFieldCollation)fieldCollations.get(0)).getFieldIndex());
        }
        final Mappings.TargetMapping mapping = scan.requiredColumns() == null ? null : Commons.inverseMapping(scan.requiredColumns(), fieldCnt);
        for (RexNode op : operands) {
            final BitSet conditionFields = new BitSet(fieldCnt);
            new RexShuttle(){

                public RexNode visitLocalRef(RexLocalRef inputRef) {
                    conditionFields.set(mapping == null ? inputRef.getIndex() : mapping.getSourceOpt(inputRef.getIndex()));
                    return inputRef;
                }
            }.apply(op);
            if (conditionFields.intersects(idxsFirstFields)) continue;
            return false;
        }
        return true;
    }

    @Nullable
    private static List<RexNode> getOrOperands(RexBuilder rexBuilder, RexNode condition) {
        RexNode dnf = RexUtil.toDnf((RexBuilder)rexBuilder, (RexNode)condition);
        if (!dnf.isA(SqlKind.OR)) {
            return null;
        }
        List operands = RelOptUtil.disjunctions((RexNode)dnf);
        if (operands.size() != 2 || RexUtil.find((SqlKind)SqlKind.IS_NULL).anyContain((Iterable)operands)) {
            return null;
        }
        return operands;
    }

    private void buildInput(RelBuilder relBldr, RelNode input, RexNode condition) {
        IgniteLogicalTableScan scan = (IgniteLogicalTableScan)input;
        RelTraitSet trait = scan.getCluster().traitSet();
        relBldr.push((RelNode)IgniteLogicalTableScan.create(scan.getCluster(), trait, scan.getTable(), scan.projects(), condition, scan.requiredColumns()));
    }

    private RelNode createUnionAll(RelOptCluster cluster, RelNode input, RexNode op1, RexNode op2) {
        RelBuilder relBldr = this.relBuilderFactory.create(cluster, null);
        this.buildInput(relBldr, input, op1);
        this.buildInput(relBldr, input, relBldr.and(new RexNode[]{op2, relBldr.or(new RexNode[]{relBldr.isNull(op1), relBldr.not(op1)})}));
        return relBldr.union(true).build();
    }

    @Value.Immutable(singleton=false)
    public static interface Config
    extends RuleFactoryConfig<Config> {
        public static final Config SCAN = ImmutableLogicalOrToUnionRule.Config.builder().withRuleFactory((Config x$0) -> new LogicalOrToUnionRule((Config)x$0)).withDescription("ScanLogicalOrToUnionRule").withOperandSupplier(o -> o.operand(IgniteLogicalTableScan.class).predicate(scan -> scan.condition() != null).noInputs()).build();
    }
}

