/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.query.calcite.rel;

import com.google.common.collect.ImmutableList;
import java.util.List;
import org.apache.calcite.plan.RelOptCluster;
import org.apache.calcite.plan.RelOptTable;
import org.apache.calcite.plan.RelTrait;
import org.apache.calcite.plan.RelTraitSet;
import org.apache.calcite.rel.RelCollation;
import org.apache.calcite.rel.RelInput;
import org.apache.calcite.rel.RelWriter;
import org.apache.calcite.rel.hint.RelHint;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.util.ImmutableBitSet;
import org.apache.ignite.internal.processors.query.calcite.prepare.bounds.SearchBounds;
import org.apache.ignite.internal.processors.query.calcite.rel.AbstractIndexScan;
import org.apache.ignite.internal.processors.query.calcite.rel.IgniteConvention;
import org.apache.ignite.internal.processors.query.calcite.rel.IgniteRel;
import org.apache.ignite.internal.processors.query.calcite.rel.IgniteRelVisitor;
import org.apache.ignite.internal.processors.query.calcite.rel.SourceAwareIgniteRel;
import org.apache.ignite.internal.processors.query.calcite.trait.TraitUtils;
import org.jetbrains.annotations.Nullable;

public class IgniteIndexScan
extends AbstractIndexScan
implements SourceAwareIgniteRel {
    private final long sourceId;
    private final RelCollation collation;

    public IgniteIndexScan(RelInput input) {
        super(TraitUtils.changeTraits(input, new RelTrait[]{IgniteConvention.INSTANCE}));
        this.collation = input.getCollation();
        Object srcIdObj = input.get("sourceId");
        this.sourceId = srcIdObj != null ? ((Number)srcIdObj).longValue() : -1L;
    }

    public IgniteIndexScan(RelOptCluster cluster, RelTraitSet traits, RelOptTable tbl, String idxName, @Nullable List<RexNode> proj, @Nullable RexNode cond, @Nullable List<SearchBounds> searchBounds, @Nullable ImmutableBitSet requiredCols, RelCollation collation) {
        this(-1L, cluster, traits, tbl, idxName, proj, cond, searchBounds, requiredCols, collation);
    }

    private IgniteIndexScan(long sourceId, RelOptCluster cluster, RelTraitSet traits, RelOptTable tbl, String idxName, @Nullable List<RexNode> proj, @Nullable RexNode cond, @Nullable List<SearchBounds> searchBounds, @Nullable ImmutableBitSet requiredCols, RelCollation collation) {
        super(cluster, traits, (List<RelHint>)ImmutableList.of(), tbl, idxName, proj, cond, searchBounds, requiredCols);
        this.sourceId = sourceId;
        this.collation = collation;
    }

    @Override
    public long sourceId() {
        return this.sourceId;
    }

    @Override
    protected RelWriter explainTerms0(RelWriter pw) {
        return super.explainTerms0(pw).itemIf("sourceId", (Object)this.sourceId, this.sourceId != -1L).item("collation", (Object)this.collation());
    }

    @Override
    public <T> T accept(IgniteRelVisitor<T> visitor) {
        return visitor.visit(this);
    }

    @Override
    public IgniteRel clone(long sourceId) {
        return new IgniteIndexScan(sourceId, this.getCluster(), this.getTraitSet(), this.getTable(), this.idxName, this.projects, this.condition, this.searchBounds, this.requiredColumns, this.collation);
    }

    @Override
    public IgniteRel clone(RelOptCluster cluster, List<IgniteRel> inputs) {
        return new IgniteIndexScan(this.sourceId, cluster, this.getTraitSet(), this.getTable(), this.idxName, this.projects, this.condition, this.searchBounds, this.requiredColumns, this.collation);
    }

    @Override
    public RelCollation collation() {
        return this.collation;
    }
}

