/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.query.calcite.prepare.bounds;

import java.util.Objects;
import org.apache.calcite.rex.RexNode;
import org.apache.ignite.internal.processors.query.calcite.prepare.bounds.SearchBounds;
import org.apache.ignite.internal.util.typedef.internal.S;
import org.jetbrains.annotations.Nullable;

public class RangeBounds
extends SearchBounds {
    private final RexNode lowerBound;
    private final RexNode upperBound;
    private final boolean lowerInclude;
    private final boolean upperInclude;

    public RangeBounds(RexNode condition, @Nullable RexNode lowerBound, @Nullable RexNode upperBound, boolean lowerInclude, boolean upperInclude) {
        super(condition);
        this.lowerBound = lowerBound;
        this.upperBound = upperBound;
        this.lowerInclude = lowerInclude;
        this.upperInclude = upperInclude;
    }

    public RexNode lowerBound() {
        return this.lowerBound;
    }

    public RexNode upperBound() {
        return this.upperBound;
    }

    public boolean lowerInclude() {
        return this.lowerInclude;
    }

    public boolean upperInclude() {
        return this.upperInclude;
    }

    @Override
    public SearchBounds.Type type() {
        return SearchBounds.Type.RANGE;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        return this.lowerInclude == ((RangeBounds)o).lowerInclude && this.upperInclude == ((RangeBounds)o).upperInclude && Objects.equals(this.lowerBound, ((RangeBounds)o).lowerBound) && Objects.equals(this.upperBound, ((RangeBounds)o).upperBound);
    }

    public int hashCode() {
        return Objects.hash(this.lowerBound, this.upperBound, this.lowerInclude, this.upperInclude);
    }

    public String toString() {
        return S.toString(RangeBounds.class, (Object)this);
    }
}

