/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.query.calcite.prepare;

import java.util.UUID;
import org.apache.calcite.plan.RelOptCluster;
import org.apache.calcite.plan.RelOptPlanner;
import org.apache.calcite.rel.metadata.CachingRelMetadataProvider;
import org.apache.calcite.rel.metadata.RelMetadataProvider;
import org.apache.calcite.rex.RexBuilder;
import org.apache.ignite.internal.processors.affinity.AffinityTopologyVersion;
import org.apache.ignite.internal.processors.query.calcite.metadata.IgniteMetadata;
import org.apache.ignite.internal.processors.query.calcite.metadata.RelMetadataQueryEx;
import org.apache.ignite.internal.processors.query.calcite.util.Commons;

public class MappingQueryContext {
    private final UUID locNodeId;
    private final AffinityTopologyVersion topVer;
    private RelOptCluster cluster;

    public MappingQueryContext(UUID locNodeId, AffinityTopologyVersion topVer) {
        this.locNodeId = locNodeId;
        this.topVer = topVer;
    }

    public UUID localNodeId() {
        return this.locNodeId;
    }

    public AffinityTopologyVersion topologyVersion() {
        return this.topVer;
    }

    RelOptCluster cluster() {
        if (this.cluster == null) {
            this.cluster = RelOptCluster.create((RelOptPlanner)Commons.emptyCluster().getPlanner(), (RexBuilder)Commons.emptyCluster().getRexBuilder());
            this.cluster.setMetadataProvider((RelMetadataProvider)new CachingRelMetadataProvider(IgniteMetadata.METADATA_PROVIDER, Commons.emptyCluster().getPlanner()));
            this.cluster.setMetadataQuerySupplier(RelMetadataQueryEx::create);
        }
        return this.cluster;
    }
}

