/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.query.calcite.prepare;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import org.apache.ignite.internal.processors.query.calcite.metadata.ColocationGroup;
import org.apache.ignite.internal.processors.query.calcite.metadata.FragmentMapping;
import org.apache.ignite.internal.processors.query.calcite.metadata.MappingService;
import org.apache.ignite.internal.processors.query.calcite.prepare.ExecutionPlan;
import org.apache.ignite.internal.processors.query.calcite.prepare.FieldsMetadata;
import org.apache.ignite.internal.processors.query.calcite.prepare.Fragment;
import org.apache.ignite.internal.processors.query.calcite.prepare.MappingQueryContext;
import org.apache.ignite.internal.processors.query.calcite.prepare.MultiStepPlan;
import org.apache.ignite.internal.processors.query.calcite.prepare.QueryTemplate;
import org.apache.ignite.internal.processors.query.calcite.rel.IgniteReceiver;
import org.apache.ignite.internal.processors.query.calcite.rel.IgniteSender;
import org.apache.ignite.internal.util.typedef.F;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractMultiStepPlan
implements MultiStepPlan {
    protected final FieldsMetadata fieldsMetadata;
    protected final FieldsMetadata paramsMetadata;
    protected final QueryTemplate queryTemplate;
    protected ExecutionPlan executionPlan;

    protected AbstractMultiStepPlan(QueryTemplate queryTemplate, FieldsMetadata fieldsMetadata, @Nullable FieldsMetadata paramsMetadata) {
        this.queryTemplate = queryTemplate;
        this.fieldsMetadata = fieldsMetadata;
        this.paramsMetadata = paramsMetadata;
    }

    @Override
    public List<Fragment> fragments() {
        return Objects.requireNonNull(this.executionPlan).fragments();
    }

    @Override
    public FieldsMetadata fieldsMetadata() {
        return this.fieldsMetadata;
    }

    @Override
    public FieldsMetadata paramsMetadata() {
        return this.paramsMetadata;
    }

    @Override
    public FragmentMapping mapping(Fragment fragment) {
        return fragment.mapping();
    }

    @Override
    public ColocationGroup target(Fragment fragment) {
        if (fragment.rootFragment()) {
            return null;
        }
        IgniteSender sender = (IgniteSender)fragment.root();
        return this.mapping(sender.targetFragmentId()).findGroup(sender.exchangeId());
    }

    @Override
    public Map<Long, List<UUID>> remotes(Fragment fragment) {
        List<IgniteReceiver> remotes = fragment.remotes();
        if (F.isEmpty(remotes)) {
            return null;
        }
        HashMap res = U.newHashMap((int)remotes.size());
        for (IgniteReceiver remote : remotes) {
            res.put(remote.exchangeId(), this.mapping(remote.sourceFragmentId()).nodeIds());
        }
        return res;
    }

    @Override
    public void init(MappingService mappingService, MappingQueryContext ctx) {
        this.executionPlan = this.queryTemplate.map(mappingService, ctx);
    }

    private FragmentMapping mapping(long fragmentId) {
        return Objects.requireNonNull(this.executionPlan).fragments().stream().filter(f -> f.fragmentId() == fragmentId).findAny().orElseThrow(() -> new IllegalStateException("Cannot find fragment with given ID. [fragmentId=" + fragmentId + ", fragments=" + this.fragments() + "]")).mapping();
    }
}

