/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.query.calcite;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.UUID;
import java.util.function.BiFunction;
import java.util.function.Function;
import org.apache.calcite.DataContexts;
import org.apache.calcite.config.Lex;
import org.apache.calcite.config.NullCollation;
import org.apache.calcite.plan.Contexts;
import org.apache.calcite.plan.ConventionTraitDef;
import org.apache.calcite.plan.RelOptCostFactory;
import org.apache.calcite.plan.RelTraitDef;
import org.apache.calcite.rel.RelCollationTraitDef;
import org.apache.calcite.rel.core.Aggregate;
import org.apache.calcite.rel.hint.HintStrategyTable;
import org.apache.calcite.rex.RexExecutor;
import org.apache.calcite.schema.SchemaPlus;
import org.apache.calcite.sql.SqlKind;
import org.apache.calcite.sql.SqlNode;
import org.apache.calcite.sql.SqlNodeList;
import org.apache.calcite.sql.SqlOperatorTable;
import org.apache.calcite.sql.parser.SqlParser;
import org.apache.calcite.sql.util.SqlOperatorTables;
import org.apache.calcite.sql.validate.SqlValidator;
import org.apache.calcite.sql2rel.SqlRexConvertletTable;
import org.apache.calcite.sql2rel.SqlToRelConverter;
import org.apache.calcite.tools.FrameworkConfig;
import org.apache.calcite.tools.Frameworks;
import org.apache.ignite.IgniteSystemProperties;
import org.apache.ignite.SystemProperty;
import org.apache.ignite.cache.query.FieldsQueryCursor;
import org.apache.ignite.calcite.CalciteQueryEngineConfiguration;
import org.apache.ignite.configuration.QueryEngineConfiguration;
import org.apache.ignite.internal.GridKernalContext;
import org.apache.ignite.internal.processors.GridProcessorAdapter;
import org.apache.ignite.internal.processors.failure.FailureProcessor;
import org.apache.ignite.internal.processors.query.GridQueryFieldMetadata;
import org.apache.ignite.internal.processors.query.IgniteSQLException;
import org.apache.ignite.internal.processors.query.QueryContext;
import org.apache.ignite.internal.processors.query.QueryEngine;
import org.apache.ignite.internal.processors.query.RunningQuery;
import org.apache.ignite.internal.processors.query.calcite.QueryRegistry;
import org.apache.ignite.internal.processors.query.calcite.QueryRegistryImpl;
import org.apache.ignite.internal.processors.query.calcite.RootQuery;
import org.apache.ignite.internal.processors.query.calcite.exec.ArrayRowHandler;
import org.apache.ignite.internal.processors.query.calcite.exec.ExchangeService;
import org.apache.ignite.internal.processors.query.calcite.exec.ExchangeServiceImpl;
import org.apache.ignite.internal.processors.query.calcite.exec.ExecutionService;
import org.apache.ignite.internal.processors.query.calcite.exec.ExecutionServiceImpl;
import org.apache.ignite.internal.processors.query.calcite.exec.MailboxRegistry;
import org.apache.ignite.internal.processors.query.calcite.exec.MailboxRegistryImpl;
import org.apache.ignite.internal.processors.query.calcite.exec.QueryTaskExecutor;
import org.apache.ignite.internal.processors.query.calcite.exec.QueryTaskExecutorImpl;
import org.apache.ignite.internal.processors.query.calcite.exec.exp.RexExecutorImpl;
import org.apache.ignite.internal.processors.query.calcite.message.MessageService;
import org.apache.ignite.internal.processors.query.calcite.message.MessageServiceImpl;
import org.apache.ignite.internal.processors.query.calcite.metadata.AffinityService;
import org.apache.ignite.internal.processors.query.calcite.metadata.AffinityServiceImpl;
import org.apache.ignite.internal.processors.query.calcite.metadata.MappingService;
import org.apache.ignite.internal.processors.query.calcite.metadata.MappingServiceImpl;
import org.apache.ignite.internal.processors.query.calcite.metadata.cost.IgniteCostFactory;
import org.apache.ignite.internal.processors.query.calcite.prepare.CacheKey;
import org.apache.ignite.internal.processors.query.calcite.prepare.ExplainPlan;
import org.apache.ignite.internal.processors.query.calcite.prepare.FieldsMetadata;
import org.apache.ignite.internal.processors.query.calcite.prepare.IgniteConvertletTable;
import org.apache.ignite.internal.processors.query.calcite.prepare.IgniteTypeCoercion;
import org.apache.ignite.internal.processors.query.calcite.prepare.MultiStepPlan;
import org.apache.ignite.internal.processors.query.calcite.prepare.PrepareServiceImpl;
import org.apache.ignite.internal.processors.query.calcite.prepare.QueryPlan;
import org.apache.ignite.internal.processors.query.calcite.prepare.QueryPlanCache;
import org.apache.ignite.internal.processors.query.calcite.prepare.QueryPlanCacheImpl;
import org.apache.ignite.internal.processors.query.calcite.schema.SchemaHolder;
import org.apache.ignite.internal.processors.query.calcite.schema.SchemaHolderImpl;
import org.apache.ignite.internal.processors.query.calcite.sql.IgniteSqlConformance;
import org.apache.ignite.internal.processors.query.calcite.sql.fun.IgniteOwnSqlOperatorTable;
import org.apache.ignite.internal.processors.query.calcite.sql.fun.IgniteStdSqlOperatorTable;
import org.apache.ignite.internal.processors.query.calcite.sql.generated.IgniteSqlParserImpl;
import org.apache.ignite.internal.processors.query.calcite.trait.CorrelationTraitDef;
import org.apache.ignite.internal.processors.query.calcite.trait.DistributionTraitDef;
import org.apache.ignite.internal.processors.query.calcite.trait.RewindabilityTraitDef;
import org.apache.ignite.internal.processors.query.calcite.type.IgniteTypeFactory;
import org.apache.ignite.internal.processors.query.calcite.type.IgniteTypeSystem;
import org.apache.ignite.internal.processors.query.calcite.util.Commons;
import org.apache.ignite.internal.processors.query.calcite.util.LifecycleAware;
import org.apache.ignite.internal.processors.query.calcite.util.Service;
import org.apache.ignite.internal.util.typedef.F;
import org.jetbrains.annotations.Nullable;

public class CalciteQueryProcessor
extends GridProcessorAdapter
implements QueryEngine {
    private static final long DFLT_IGNITE_CALCITE_PLANNER_TIMEOUT = 15000L;
    @SystemProperty(value="Timeout of calcite based sql engine's planner, in ms", type=Long.class, defaults="15000")
    public static final String IGNITE_CALCITE_PLANNER_TIMEOUT = "IGNITE_CALCITE_PLANNER_TIMEOUT";
    public static final FrameworkConfig FRAMEWORK_CONFIG = Frameworks.newConfigBuilder().executor((RexExecutor)new RexExecutorImpl(DataContexts.EMPTY)).sqlToRelConverterConfig(SqlToRelConverter.config().withTrimUnusedFields(true).withInSubQueryThreshold(Integer.MAX_VALUE).withDecorrelationEnabled(true).withExpand(false).withHintStrategyTable(HintStrategyTable.builder().hintStrategy("DISABLE_RULE", (hint, rel) -> true).hintStrategy("EXPAND_DISTINCT_AGG", (hint, rel) -> rel instanceof Aggregate).hintStrategy("QUERY_ENGINE", (hint, rel) -> true).build())).convertletTable((SqlRexConvertletTable)IgniteConvertletTable.INSTANCE).parserConfig(SqlParser.config().withParserFactory(IgniteSqlParserImpl.FACTORY).withLex(Lex.ORACLE).withConformance(IgniteSqlConformance.INSTANCE)).sqlValidatorConfig(SqlValidator.Config.DEFAULT.withIdentifierExpansion(true).withDefaultNullCollation(NullCollation.LOW).withSqlConformance(IgniteSqlConformance.INSTANCE).withTypeCoercionFactory(IgniteTypeCoercion::new)).operatorTable(SqlOperatorTables.chain((SqlOperatorTable[])new SqlOperatorTable[]{IgniteStdSqlOperatorTable.INSTANCE, IgniteOwnSqlOperatorTable.instance()})).context(Contexts.empty()).costFactory((RelOptCostFactory)new IgniteCostFactory()).typeSystem(IgniteTypeSystem.INSTANCE).traitDefs(new RelTraitDef[]{ConventionTraitDef.INSTANCE, RelCollationTraitDef.INSTANCE, DistributionTraitDef.INSTANCE, RewindabilityTraitDef.INSTANCE, CorrelationTraitDef.INSTANCE}).build();
    private final long queryPlannerTimeout = IgniteSystemProperties.getLong((String)"IGNITE_CALCITE_PLANNER_TIMEOUT", (long)15000L);
    private final QueryPlanCache qryPlanCache;
    private final QueryTaskExecutor taskExecutor;
    private final FailureProcessor failureProcessor;
    private final AffinityService partSvc;
    private final SchemaHolder schemaHolder;
    private final MessageService msgSvc;
    private final ExchangeService exchangeSvc;
    private final MappingService mappingSvc;
    private final MailboxRegistry mailboxRegistry;
    private final ExecutionService<Object[]> executionSvc;
    private final PrepareServiceImpl prepareSvc;
    private final QueryRegistry qryReg;
    private final CalciteQueryEngineConfiguration cfg;
    private volatile boolean started;

    public CalciteQueryProcessor(GridKernalContext ctx) {
        super(ctx);
        this.failureProcessor = ctx.failure();
        this.schemaHolder = new SchemaHolderImpl(ctx);
        this.qryPlanCache = new QueryPlanCacheImpl(ctx);
        this.mailboxRegistry = new MailboxRegistryImpl(ctx);
        this.taskExecutor = new QueryTaskExecutorImpl(ctx);
        this.executionSvc = new ExecutionServiceImpl<Object[]>(ctx, ArrayRowHandler.INSTANCE);
        this.partSvc = new AffinityServiceImpl(ctx);
        this.msgSvc = new MessageServiceImpl(ctx);
        this.mappingSvc = new MappingServiceImpl(ctx);
        this.exchangeSvc = new ExchangeServiceImpl(ctx);
        this.prepareSvc = new PrepareServiceImpl(ctx);
        this.qryReg = new QueryRegistryImpl(ctx);
        Object[] qryEnginesCfg = ctx.config().getSqlConfiguration().getQueryEnginesConfiguration();
        this.cfg = F.isEmpty((Object[])qryEnginesCfg) ? new CalciteQueryEngineConfiguration() : (CalciteQueryEngineConfiguration)Arrays.stream(qryEnginesCfg).filter(c -> c instanceof CalciteQueryEngineConfiguration).findAny().orElse((QueryEngineConfiguration)new CalciteQueryEngineConfiguration());
    }

    public AffinityService affinityService() {
        return this.partSvc;
    }

    public QueryPlanCache queryPlanCache() {
        return this.qryPlanCache;
    }

    public QueryTaskExecutor taskExecutor() {
        return this.taskExecutor;
    }

    public SchemaHolder schemaHolder() {
        return this.schemaHolder;
    }

    public MessageService messageService() {
        return this.msgSvc;
    }

    public MappingService mappingService() {
        return this.mappingSvc;
    }

    public ExchangeService exchangeService() {
        return this.exchangeSvc;
    }

    public MailboxRegistry mailboxRegistry() {
        return this.mailboxRegistry;
    }

    public FailureProcessor failureProcessor() {
        return this.failureProcessor;
    }

    public PrepareServiceImpl prepareService() {
        return this.prepareSvc;
    }

    public ExecutionService<Object[]> executionService() {
        return this.executionSvc;
    }

    public void onKernalStart(boolean active) {
        this.onStart(this.ctx, this.executionSvc, this.mailboxRegistry, this.partSvc, this.schemaHolder, this.msgSvc, this.taskExecutor, this.mappingSvc, this.qryPlanCache, this.exchangeSvc, this.qryReg);
        this.started = true;
    }

    public void onKernalStop(boolean cancel) {
        if (this.started) {
            this.started = false;
            this.onStop(this.qryReg, this.executionSvc, this.mailboxRegistry, this.partSvc, this.schemaHolder, this.msgSvc, this.taskExecutor, this.mappingSvc, this.qryPlanCache, this.exchangeSvc);
        }
    }

    public List<FieldsQueryCursor<List<?>>> query(@Nullable QueryContext qryCtx, @Nullable String schemaName, String sql, Object ... params) throws IgniteSQLException {
        return this.parseAndProcessQuery(qryCtx, this.executionSvc::executePlan, schemaName, sql, params);
    }

    public List<List<GridQueryFieldMetadata>> parameterMetaData(@Nullable QueryContext ctx, String schemaName, String sql) throws IgniteSQLException {
        return this.parseAndProcessQuery(ctx, (qry, plan) -> {
            try {
                List<GridQueryFieldMetadata> list = this.fieldsMeta((QueryPlan)plan, true);
                return list;
            }
            finally {
                this.qryReg.unregister(qry.id());
            }
        }, schemaName, sql, new Object[0]);
    }

    public List<List<GridQueryFieldMetadata>> resultSetMetaData(@Nullable QueryContext ctx, String schemaName, String sql) throws IgniteSQLException {
        return this.parseAndProcessQuery(ctx, (qry, plan) -> {
            try {
                List<GridQueryFieldMetadata> list = this.fieldsMeta((QueryPlan)plan, false);
                return list;
            }
            finally {
                this.qryReg.unregister(qry.id());
            }
        }, schemaName, sql, new Object[0]);
    }

    public List<FieldsQueryCursor<List<?>>> queryBatched(@Nullable QueryContext qryCtx, String schemaName, final String sql, List<Object[]> batchedParams) throws IgniteSQLException {
        final SchemaPlus schema = this.schemaHolder.schema(schemaName);
        assert (schema != null) : "Schema not found: " + schemaName;
        SqlNodeList qryNodeList = Commons.parse(sql, FRAMEWORK_CONFIG.getParserConfig());
        if (qryNodeList.size() != 1) {
            throw new IgniteSQLException("Multiline statements are not supported in batched query", 1001);
        }
        final SqlNode qryNode = qryNodeList.get(0);
        if (qryNode.getKind() != SqlKind.INSERT && qryNode.getKind() != SqlKind.UPDATE && qryNode.getKind() != SqlKind.MERGE && qryNode.getKind() != SqlKind.DELETE) {
            throw new IgniteSQLException("Unexpected operation kind for batched query [kind=" + qryNode.getKind() + "]", 2001);
        }
        ArrayList cursors = new ArrayList(batchedParams.size());
        ArrayList<RootQuery<Object[]>> qrys = new ArrayList<RootQuery<Object[]>>(batchedParams.size());
        BiFunction<RootQuery<Object[]>, Object[], QueryPlan> planSupplier = new BiFunction<RootQuery<Object[]>, Object[], QueryPlan>(){
            private QueryPlan plan;

            @Override
            public QueryPlan apply(RootQuery<Object[]> qry, Object[] params) {
                if (this.plan == null) {
                    this.plan = CalciteQueryProcessor.this.queryPlanCache().queryPlan(new CacheKey(schema.getName(), sql, null, params), () -> CalciteQueryProcessor.this.prepareSvc.prepareSingle(qryNode, qry.planningContext()));
                }
                return this.plan;
            }
        };
        for (Object[] batch : batchedParams) {
            FieldsQueryCursor cur = this.processQuery(qryCtx, qry -> this.executionSvc.executePlan((RootQuery<Object[]>)qry, (QueryPlan)planSupplier.apply((RootQuery<Object[]>)qry, batch)), schema.getName(), sql, qrys, batch);
            cursors.add(cur);
        }
        return cursors;
    }

    private <T> List<T> parseAndProcessQuery(@Nullable QueryContext qryCtx, BiFunction<RootQuery<Object[]>, QueryPlan, T> action, @Nullable String schemaName, String sql, Object ... params) throws IgniteSQLException {
        SchemaPlus schema = this.schemaHolder.schema(schemaName);
        assert (schema != null) : "Schema not found: " + schemaName;
        QueryPlan plan = this.queryPlanCache().queryPlan(new CacheKey(schema.getName(), sql, null, params));
        if (plan != null) {
            return Collections.singletonList(this.processQuery(qryCtx, qry -> action.apply((RootQuery<Object[]>)qry, plan), schema.getName(), sql, null, params));
        }
        SqlNodeList qryList = Commons.parse(sql, FRAMEWORK_CONFIG.getParserConfig());
        ArrayList<Object> res = new ArrayList<Object>(qryList.size());
        ArrayList<RootQuery<Object[]>> qrys = new ArrayList<RootQuery<Object[]>>(qryList.size());
        for (SqlNode sqlNode : qryList) {
            Object singleRes = this.processQuery(qryCtx, qry -> {
                QueryPlan plan0 = qryList.size() == 1 ? this.queryPlanCache().queryPlan(new CacheKey(schema.getName(), sql, null, params), () -> this.prepareSvc.prepareSingle(sqlNode, qry.planningContext())) : this.prepareSvc.prepareSingle(sqlNode, qry.planningContext());
                return action.apply((RootQuery<Object[]>)qry, plan0);
            }, schema.getName(), sqlNode.toString(), qrys, params);
            res.add(singleRes);
        }
        return res;
    }

    private <T> T processQuery(@Nullable QueryContext qryCtx, Function<RootQuery<Object[]>, T> action, String schema, String sql, @Nullable List<RootQuery<Object[]>> qrys, Object ... params) {
        RootQuery qry = new RootQuery(sql, this.schemaHolder.schema(schema), params, qryCtx, this.exchangeSvc, q -> this.qryReg.unregister(q.id()), this.log, this.queryPlannerTimeout);
        if (qrys != null) {
            qrys.add(qry);
        }
        this.qryReg.register(qry);
        try {
            return action.apply(qry);
        }
        catch (Throwable e) {
            boolean isCanceled = qry.isCancelled();
            if (qrys != null) {
                qrys.forEach(RootQuery::cancel);
            }
            this.qryReg.unregister(qry.id());
            if (isCanceled) {
                throw new IgniteSQLException("The query was cancelled while planning", 3014, e);
            }
            throw e;
        }
    }

    private List<GridQueryFieldMetadata> fieldsMeta(QueryPlan plan, boolean isParamsMeta) {
        IgniteTypeFactory typeFactory = Commons.typeFactory();
        switch (plan.type()) {
            case QUERY: 
            case DML: {
                MultiStepPlan msPlan = (MultiStepPlan)plan;
                FieldsMetadata meta = isParamsMeta ? msPlan.paramsMetadata() : msPlan.fieldsMetadata();
                return meta.queryFieldsMetadata(typeFactory);
            }
            case EXPLAIN: {
                ExplainPlan exPlan = (ExplainPlan)plan;
                return isParamsMeta ? Collections.emptyList() : exPlan.fieldsMeta().queryFieldsMetadata(typeFactory);
            }
        }
        return Collections.emptyList();
    }

    private void onStart(GridKernalContext ctx, Service ... services) {
        for (Service service : services) {
            if (!(service instanceof LifecycleAware)) continue;
            ((LifecycleAware)((Object)service)).onStart(ctx);
        }
    }

    private void onStop(Service ... services) {
        for (Service service : services) {
            if (!(service instanceof LifecycleAware)) continue;
            ((LifecycleAware)((Object)service)).onStop();
        }
    }

    public RunningQuery runningQuery(UUID id) {
        return this.qryReg.query(id);
    }

    public Collection<? extends RunningQuery> runningQueries() {
        return this.qryReg.runningQueries();
    }

    public QueryRegistry queryRegistry() {
        return this.qryReg;
    }

    public CalciteQueryEngineConfiguration config() {
        return this.cfg;
    }
}

