/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.io;

import java.io.IOException;
import java.util.List;
import java.util.Map;
import org.apache.iceberg.DataFile;
import org.apache.iceberg.PartitionKey;
import org.apache.iceberg.PartitionSpec;
import org.apache.iceberg.Schema;
import org.apache.iceberg.StructLike;
import org.apache.iceberg.Table;
import org.apache.iceberg.TestBase;
import org.apache.iceberg.data.GenericRecord;
import org.apache.iceberg.data.IcebergGenerics;
import org.apache.iceberg.encryption.EncryptedOutputFile;
import org.apache.iceberg.io.CloseableIterable;
import org.apache.iceberg.io.DataWriter;
import org.apache.iceberg.io.FileWriterFactory;
import org.apache.iceberg.io.OutputFileFactory;
import org.apache.iceberg.relocated.com.google.common.collect.ImmutableMap;
import org.apache.iceberg.types.Types;
import org.apache.iceberg.util.StructLikeSet;

public abstract class WriterTestBase<T>
extends TestBase {
    protected abstract FileWriterFactory<T> newWriterFactory(Schema var1, List<Integer> var2, Schema var3, Schema var4);

    protected FileWriterFactory<T> newWriterFactory(Schema dataSchema, List<Integer> equalityFieldIds, Schema equalityDeleteRowSchema) {
        return this.newWriterFactory(dataSchema, equalityFieldIds, equalityDeleteRowSchema, null);
    }

    protected FileWriterFactory<T> newWriterFactory(Schema dataSchema, Schema positionDeleteRowSchema) {
        return this.newWriterFactory(dataSchema, null, null, positionDeleteRowSchema);
    }

    protected FileWriterFactory<T> newWriterFactory(Schema dataSchema) {
        return this.newWriterFactory(dataSchema, null, null, null);
    }

    protected abstract T toRow(Integer var1, String var2);

    protected PartitionKey partitionKey(PartitionSpec spec, String value) {
        GenericRecord record = GenericRecord.create((Schema)this.table.schema()).copy((Map)ImmutableMap.of((Object)"data", (Object)value));
        PartitionKey partitionKey = new PartitionKey(spec, this.table.schema());
        partitionKey.partition((StructLike)record);
        return partitionKey;
    }

    protected StructLikeSet actualRowSet(String ... columns) throws IOException {
        StructLikeSet set = StructLikeSet.create((Types.StructType)this.table.schema().asStruct());
        try (CloseableIterable reader = IcebergGenerics.read((Table)this.table).select(columns).build();){
            reader.forEach(arg_0 -> ((StructLikeSet)set).add(arg_0));
        }
        return set;
    }

    protected DataFile writeData(FileWriterFactory<T> writerFactory, OutputFileFactory fileFactory, List<T> rows, PartitionSpec spec, StructLike partitionKey) throws IOException {
        DataWriter writer;
        EncryptedOutputFile file = fileFactory.newOutputFile(spec, partitionKey);
        try (DataWriter closeableWriter = writer = writerFactory.newDataWriter(file, spec, partitionKey);){
            for (T row : rows) {
                closeableWriter.write(row);
            }
        }
        return writer.toDataFile();
    }
}

