/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.io;

import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.apache.iceberg.DataFile;
import org.apache.iceberg.FileFormat;
import org.apache.iceberg.Parameter;
import org.apache.iceberg.ParameterizedTestExtension;
import org.apache.iceberg.Parameters;
import org.apache.iceberg.PartitionKey;
import org.apache.iceberg.PartitionSpec;
import org.apache.iceberg.Schema;
import org.apache.iceberg.StructLike;
import org.apache.iceberg.Table;
import org.apache.iceberg.TestBase;
import org.apache.iceberg.avro.Avro;
import org.apache.iceberg.data.GenericRecord;
import org.apache.iceberg.data.IcebergGenerics;
import org.apache.iceberg.data.Record;
import org.apache.iceberg.data.avro.DataReader;
import org.apache.iceberg.data.orc.GenericOrcReader;
import org.apache.iceberg.data.parquet.GenericParquetReaders;
import org.apache.iceberg.deletes.EqualityDeleteWriter;
import org.apache.iceberg.deletes.PositionDelete;
import org.apache.iceberg.deletes.PositionDeleteWriter;
import org.apache.iceberg.encryption.EncryptedOutputFile;
import org.apache.iceberg.io.CloseableIterable;
import org.apache.iceberg.io.DataWriter;
import org.apache.iceberg.io.DeleteSchemaUtil;
import org.apache.iceberg.io.FileAppenderFactory;
import org.apache.iceberg.io.InputFile;
import org.apache.iceberg.io.OutputFileFactory;
import org.apache.iceberg.orc.ORC;
import org.apache.iceberg.parquet.Parquet;
import org.apache.iceberg.relocated.com.google.common.collect.ImmutableMap;
import org.apache.iceberg.relocated.com.google.common.collect.Lists;
import org.apache.iceberg.relocated.com.google.common.collect.Sets;
import org.apache.iceberg.types.Types;
import org.apache.iceberg.util.Pair;
import org.apache.iceberg.util.StructLikeSet;
import org.apache.orc.TypeDescription;
import org.apache.parquet.schema.MessageType;
import org.assertj.core.api.AbstractCollectionAssert;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.TestTemplate;
import org.junit.jupiter.api.extension.ExtendWith;

@ExtendWith(value={ParameterizedTestExtension.class})
public abstract class TestAppenderFactory<T>
extends TestBase {
    private static final int FORMAT_V2 = 2;
    private PartitionKey partition = null;
    private OutputFileFactory fileFactory = null;
    @Parameter(index=1)
    protected FileFormat format;
    @Parameter(index=2)
    private boolean partitioned;

    @Parameters(name="formatVersion = {0}, FileFormat={1}, partitioned={2}")
    protected static List<Object> parameters() {
        return Arrays.asList(new Object[]{2, FileFormat.AVRO, false}, new Object[]{2, FileFormat.AVRO, true}, new Object[]{2, FileFormat.ORC, false}, new Object[]{2, FileFormat.ORC, true}, new Object[]{2, FileFormat.PARQUET, false}, new Object[]{2, FileFormat.PARQUET, true});
    }

    @BeforeEach
    public void setupTable() throws Exception {
        this.tableDir = Files.createTempDirectory(this.temp, "junit", new FileAttribute[0]).toFile();
        Assertions.assertThat((boolean)this.tableDir.delete()).isTrue();
        this.metadataDir = new File(this.tableDir, "metadata");
        this.table = this.partitioned ? this.create(SCHEMA, SPEC) : this.create(SCHEMA, PartitionSpec.unpartitioned());
        this.partition = this.createPartitionKey();
        this.fileFactory = OutputFileFactory.builderFor((Table)this.table, (int)1, (long)1L).format(this.format).build();
        this.table.updateProperties().defaultFormat(this.format).commit();
    }

    protected abstract FileAppenderFactory<T> createAppenderFactory(List<Integer> var1, Schema var2, Schema var3);

    protected abstract T createRow(Integer var1, String var2);

    protected abstract StructLikeSet expectedRowSet(Iterable<T> var1) throws IOException;

    private StructLikeSet actualRowSet(String ... columns) throws IOException {
        StructLikeSet set = StructLikeSet.create((Types.StructType)this.table.schema().asStruct());
        try (CloseableIterable reader = IcebergGenerics.read((Table)this.table).select(columns).build();){
            reader.forEach(arg_0 -> ((StructLikeSet)set).add(arg_0));
        }
        return set;
    }

    private PartitionKey createPartitionKey() {
        if (this.table.spec().isUnpartitioned()) {
            return null;
        }
        GenericRecord record = GenericRecord.create((Schema)this.table.schema()).copy((Map)ImmutableMap.of((Object)"data", (Object)"aaa"));
        PartitionKey partitionKey = new PartitionKey(this.table.spec(), this.table.schema());
        partitionKey.partition((StructLike)record);
        return partitionKey;
    }

    private EncryptedOutputFile createEncryptedOutputFile() {
        if (this.partition == null) {
            return this.fileFactory.newOutputFile();
        }
        return this.fileFactory.newOutputFile((StructLike)this.partition);
    }

    private List<T> testRowSet() {
        return Lists.newArrayList((Object[])new Object[]{this.createRow(1, "aaa"), this.createRow(2, "bbb"), this.createRow(3, "ccc"), this.createRow(4, "ddd"), this.createRow(5, "eee")});
    }

    private DataFile prepareDataFile(List<T> rowSet, FileAppenderFactory<T> appenderFactory) throws IOException {
        DataWriter writer;
        try (DataWriter closeableWriter = writer = appenderFactory.newDataWriter(this.createEncryptedOutputFile(), this.format, (StructLike)this.partition);){
            for (T row : rowSet) {
                closeableWriter.write(row);
            }
        }
        return writer.toDataFile();
    }

    @TestTemplate
    public void testDataWriter() throws IOException {
        FileAppenderFactory<T> appenderFactory = this.createAppenderFactory(null, null, null);
        List<T> rowSet = this.testRowSet();
        DataFile dataFile = this.prepareDataFile(rowSet, appenderFactory);
        this.table.newRowDelta().addRows(dataFile).commit();
        ((AbstractCollectionAssert)Assertions.assertThat((Collection)this.actualRowSet("*")).as("Should have the expected records.", new Object[0])).isEqualTo((Object)this.expectedRowSet(rowSet));
    }

    @TestTemplate
    public void testEqDeleteWriter() throws IOException {
        EqualityDeleteWriter eqDeleteWriter;
        ArrayList equalityFieldIds = Lists.newArrayList((Object[])new Integer[]{this.table.schema().findField("id").fieldId()});
        Schema eqDeleteRowSchema = this.table.schema().select(new String[]{"id"});
        FileAppenderFactory<T> appenderFactory = this.createAppenderFactory(equalityFieldIds, eqDeleteRowSchema, null);
        List<T> rowSet = this.testRowSet();
        DataFile dataFile = this.prepareDataFile(rowSet, appenderFactory);
        this.table.newRowDelta().addRows(dataFile).commit();
        ArrayList deletes = Lists.newArrayList((Object[])new Object[]{this.createRow(1, "aaa"), this.createRow(3, "bbb"), this.createRow(5, "ccc")});
        EncryptedOutputFile out = this.createEncryptedOutputFile();
        try (EqualityDeleteWriter closeableWriter = eqDeleteWriter = appenderFactory.newEqDeleteWriter(out, this.format, (StructLike)this.partition);){
            closeableWriter.write((Iterable)deletes);
        }
        GenericRecord gRecord = GenericRecord.create((Schema)eqDeleteRowSchema);
        HashSet expectedDeletes = Sets.newHashSet((Object[])new Record[]{gRecord.copy("id", (Object)1), gRecord.copy("id", (Object)3), gRecord.copy("id", (Object)5)});
        Assertions.assertThat((Collection)Sets.newHashSet(this.createReader(eqDeleteRowSchema, out.encryptingOutputFile().toInputFile()))).isEqualTo((Object)expectedDeletes);
        this.table.newRowDelta().addDeletes(eqDeleteWriter.toDeleteFile()).commit();
        ArrayList expected = Lists.newArrayList((Object[])new Object[]{this.createRow(2, "bbb"), this.createRow(4, "ddd")});
        ((AbstractCollectionAssert)Assertions.assertThat((Collection)this.actualRowSet("*")).as("Should have the expected records", new Object[0])).isEqualTo((Object)this.expectedRowSet(expected));
    }

    @TestTemplate
    public void testPosDeleteWriter() throws IOException {
        FileAppenderFactory<T> appenderFactory = this.createAppenderFactory(null, null, null);
        List<T> rowSet = this.testRowSet();
        DataFile dataFile = this.prepareDataFile(rowSet, appenderFactory);
        ArrayList deletes = Lists.newArrayList((Object[])new Pair[]{Pair.of((Object)dataFile.path(), (Object)0L), Pair.of((Object)dataFile.path(), (Object)2L), Pair.of((Object)dataFile.path(), (Object)4L)});
        EncryptedOutputFile out = this.createEncryptedOutputFile();
        PositionDeleteWriter eqDeleteWriter = appenderFactory.newPosDeleteWriter(out, this.format, (StructLike)this.partition);
        PositionDelete posDelete = PositionDelete.create();
        try (PositionDeleteWriter closeableWriter = eqDeleteWriter;){
            for (Pair delete : deletes) {
                closeableWriter.write(posDelete.set((CharSequence)delete.first(), ((Long)delete.second()).longValue(), null));
            }
        }
        Schema pathPosSchema = DeleteSchemaUtil.pathPosSchema();
        GenericRecord gRecord = GenericRecord.create((Schema)pathPosSchema);
        HashSet expectedDeletes = Sets.newHashSet((Object[])new Record[]{gRecord.copy("file_path", (Object)dataFile.path(), "pos", (Object)0L), gRecord.copy("file_path", (Object)dataFile.path(), "pos", (Object)2L), gRecord.copy("file_path", (Object)dataFile.path(), "pos", (Object)4L)});
        Assertions.assertThat((Collection)Sets.newHashSet(this.createReader(pathPosSchema, out.encryptingOutputFile().toInputFile()))).isEqualTo((Object)expectedDeletes);
        this.table.newRowDelta().addRows(dataFile).addDeletes(eqDeleteWriter.toDeleteFile()).validateDataFilesExist((Iterable)eqDeleteWriter.referencedDataFiles()).validateDeletedFiles().commit();
        ArrayList expected = Lists.newArrayList((Object[])new Object[]{this.createRow(2, "bbb"), this.createRow(4, "ddd")});
        ((AbstractCollectionAssert)Assertions.assertThat((Collection)this.actualRowSet("*")).as("Should have the expected records", new Object[0])).isEqualTo((Object)this.expectedRowSet(expected));
    }

    @TestTemplate
    public void testPosDeleteWriterWithRowSchema() throws IOException {
        FileAppenderFactory<T> appenderFactory = this.createAppenderFactory(null, null, this.table.schema());
        List<T> rowSet = this.testRowSet();
        DataFile dataFile = this.prepareDataFile(rowSet, appenderFactory);
        ArrayList deletes = Lists.newArrayList((Object[])new PositionDelete[]{this.positionDelete(dataFile.path(), 0L, rowSet.get(0)), this.positionDelete(dataFile.path(), 2L, rowSet.get(2)), this.positionDelete(dataFile.path(), 4L, rowSet.get(4))});
        EncryptedOutputFile out = this.createEncryptedOutputFile();
        PositionDeleteWriter eqDeleteWriter = appenderFactory.newPosDeleteWriter(out, this.format, (StructLike)this.partition);
        PositionDelete posDelete = PositionDelete.create();
        try (PositionDeleteWriter closeableWriter = eqDeleteWriter;){
            for (PositionDelete delete : deletes) {
                closeableWriter.write(posDelete.set(delete.path(), delete.pos(), delete.row()));
            }
        }
        Schema pathPosRowSchema = DeleteSchemaUtil.posDeleteSchema((Schema)this.table.schema());
        GenericRecord gRecord = GenericRecord.create((Schema)pathPosRowSchema);
        GenericRecord rowRecord = GenericRecord.create((Schema)this.table.schema());
        HashSet expectedDeletes = Sets.newHashSet((Object[])new Record[]{gRecord.copy("file_path", (Object)dataFile.path(), "pos", (Object)0L, "row", (Object)rowRecord.copy("id", (Object)1, "data", (Object)"aaa")), gRecord.copy("file_path", (Object)dataFile.path(), "pos", (Object)2L, "row", (Object)rowRecord.copy("id", (Object)3, "data", (Object)"ccc")), gRecord.copy("file_path", (Object)dataFile.path(), "pos", (Object)4L, "row", (Object)rowRecord.copy("id", (Object)5, "data", (Object)"eee"))});
        Assertions.assertThat((Collection)Sets.newHashSet(this.createReader(pathPosRowSchema, out.encryptingOutputFile().toInputFile()))).isEqualTo((Object)expectedDeletes);
        this.table.newRowDelta().addRows(dataFile).addDeletes(eqDeleteWriter.toDeleteFile()).validateDataFilesExist((Iterable)eqDeleteWriter.referencedDataFiles()).validateDeletedFiles().commit();
        ArrayList expected = Lists.newArrayList((Object[])new Object[]{this.createRow(2, "bbb"), this.createRow(4, "ddd")});
        ((AbstractCollectionAssert)Assertions.assertThat((Collection)this.actualRowSet("*")).as("Should have the expected records", new Object[0])).isEqualTo((Object)this.expectedRowSet(expected));
    }

    private CloseableIterable<Record> createReader(Schema schema, InputFile inputFile) {
        switch (this.format) {
            case PARQUET: {
                return Parquet.read((InputFile)inputFile).project(schema).createReaderFunc(fileSchema -> GenericParquetReaders.buildReader((Schema)schema, (MessageType)fileSchema)).build();
            }
            case AVRO: {
                return Avro.read((InputFile)inputFile).project(schema).createReaderFunc(DataReader::create).build();
            }
            case ORC: {
                return ORC.read((InputFile)inputFile).project(schema).createReaderFunc(fileSchema -> GenericOrcReader.buildReader((Schema)schema, (TypeDescription)fileSchema)).build();
            }
        }
        throw new UnsupportedOperationException("Unsupported file format: " + this.format);
    }
}

