/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.data.parquet;

import java.io.File;
import java.io.IOException;
import org.apache.iceberg.Files;
import org.apache.iceberg.Schema;
import org.apache.iceberg.data.Record;
import org.apache.iceberg.data.TestReadProjection;
import org.apache.iceberg.data.parquet.GenericParquetReaders;
import org.apache.iceberg.data.parquet.GenericParquetWriter;
import org.apache.iceberg.io.CloseableIterable;
import org.apache.iceberg.io.FileAppender;
import org.apache.iceberg.io.InputFile;
import org.apache.iceberg.io.OutputFile;
import org.apache.iceberg.parquet.Parquet;
import org.apache.iceberg.relocated.com.google.common.collect.Iterables;
import org.apache.parquet.schema.MessageType;
import org.assertj.core.api.Assertions;

public class TestGenericReadProjection
extends TestReadProjection {
    @Override
    protected Record writeAndRead(String desc, Schema writeSchema, Schema readSchema, Record record) throws IOException {
        File file = File.createTempFile("junit", ".parquet", this.tempDir);
        Assertions.assertThat((boolean)file.delete()).isTrue();
        try (FileAppender appender = Parquet.write((OutputFile)Files.localOutput((File)file)).schema(writeSchema).createWriterFunc(GenericParquetWriter::buildWriter).build();){
            appender.add((Object)record);
        }
        CloseableIterable records = Parquet.read((InputFile)Files.localInput((File)file)).project(readSchema).createReaderFunc(fileSchema -> GenericParquetReaders.buildReader((Schema)readSchema, (MessageType)fileSchema)).build();
        return (Record)Iterables.getOnlyElement((Iterable)records);
    }
}

