/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.data.orc;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.iceberg.Files;
import org.apache.iceberg.Schema;
import org.apache.iceberg.data.DataTestHelpers;
import org.apache.iceberg.data.GenericRecord;
import org.apache.iceberg.data.Record;
import org.apache.iceberg.data.orc.GenericOrcReader;
import org.apache.iceberg.data.orc.GenericOrcWriter;
import org.apache.iceberg.expressions.Expression;
import org.apache.iceberg.expressions.Expressions;
import org.apache.iceberg.io.CloseableIterable;
import org.apache.iceberg.io.FileAppender;
import org.apache.iceberg.io.InputFile;
import org.apache.iceberg.io.OutputFile;
import org.apache.iceberg.orc.ORC;
import org.apache.iceberg.relocated.com.google.common.collect.Iterables;
import org.apache.iceberg.relocated.com.google.common.collect.Lists;
import org.apache.iceberg.types.Type;
import org.apache.iceberg.types.Types;
import org.apache.orc.OrcConf;
import org.apache.orc.TypeDescription;
import org.assertj.core.api.AbstractBooleanAssert;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.io.TempDir;

public class TestOrcRowIterator {
    private static final Schema DATA_SCHEMA = new Schema(new Types.NestedField[]{Types.NestedField.required((int)100, (String)"id", (Type)Types.LongType.get())});
    private static final int NUM_ROWS = 8000;
    private static final List<Record> DATA_ROWS = Lists.newArrayListWithCapacity((int)8000);
    @TempDir
    private File tempDir;
    private File testFile;

    @BeforeEach
    public void writeFile() throws IOException {
        this.testFile = File.createTempFile("junit", null, this.tempDir);
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)this.testFile.delete()).as("Delete should succeed", new Object[0])).isTrue();
        try (FileAppender writer = ORC.write((OutputFile)Files.localOutput((File)this.testFile)).createWriterFunc(GenericOrcWriter::buildWriter).schema(DATA_SCHEMA).set("iceberg.orc.vectorbatch.size", "1000").set(OrcConf.ROW_INDEX_STRIDE.getAttribute(), "1000").set(OrcConf.ROWS_BETWEEN_CHECKS.getAttribute(), "4000").set(OrcConf.STRIPE_SIZE.getAttribute(), "1").build();){
            writer.addAll(DATA_ROWS);
        }
    }

    @Test
    public void testReadAllStripes() throws IOException {
        this.readAndValidate((Expression)Expressions.alwaysTrue(), DATA_ROWS);
    }

    @Test
    public void testReadFilteredRowGroupInMiddle() throws IOException {
        this.readAndValidate((Expression)Expressions.in((String)"id", (Object[])new Integer[]{500, 2500, 3500}), Lists.newArrayList((Iterable)Iterables.concat(DATA_ROWS.subList(0, 1000), DATA_ROWS.subList(2000, 4000))));
    }

    private void readAndValidate(Expression filter, List<Record> expected) throws IOException {
        ArrayList rows;
        try (CloseableIterable reader = ORC.read((InputFile)Files.localInput((File)this.testFile)).project(DATA_SCHEMA).filter(filter).createReaderFunc(fileSchema -> GenericOrcReader.buildReader((Schema)DATA_SCHEMA, (TypeDescription)fileSchema)).build();){
            rows = Lists.newArrayList((Iterable)reader);
        }
        for (int i = 0; i < expected.size(); ++i) {
            DataTestHelpers.assertEquals(DATA_SCHEMA.asStruct(), expected.get(i), (Record)rows.get(i));
        }
    }

    static {
        for (long i = 0L; i < 8000L; ++i) {
            GenericRecord row = GenericRecord.create((Schema)DATA_SCHEMA);
            row.set(0, (Object)i);
            DATA_ROWS.add((Record)row);
        }
    }
}

