/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.data.orc;

import java.io.File;
import java.io.IOException;
import org.apache.iceberg.Files;
import org.apache.iceberg.Schema;
import org.apache.iceberg.data.Record;
import org.apache.iceberg.data.TestReadProjection;
import org.apache.iceberg.data.orc.GenericOrcReader;
import org.apache.iceberg.data.orc.GenericOrcWriter;
import org.apache.iceberg.io.CloseableIterable;
import org.apache.iceberg.io.FileAppender;
import org.apache.iceberg.io.InputFile;
import org.apache.iceberg.io.OutputFile;
import org.apache.iceberg.orc.ORC;
import org.apache.iceberg.relocated.com.google.common.collect.Iterables;
import org.apache.orc.TypeDescription;
import org.assertj.core.api.Assertions;

public class TestGenericReadProjection
extends TestReadProjection {
    @Override
    protected Record writeAndRead(String desc, Schema writeSchema, Schema readSchema, Record record) throws IOException {
        File file = File.createTempFile("junit", ".orc", this.tempDir);
        Assertions.assertThat((boolean)file.delete()).isTrue();
        try (FileAppender appender = ORC.write((OutputFile)Files.localOutput((File)file)).schema(writeSchema).createWriterFunc(GenericOrcWriter::buildWriter).build();){
            appender.add((Object)record);
        }
        CloseableIterable records = ORC.read((InputFile)Files.localInput((File)file)).project(readSchema).createReaderFunc(fileSchema -> GenericOrcReader.buildReader((Schema)readSchema, (TypeDescription)fileSchema)).build();
        return (Record)Iterables.getOnlyElement((Iterable)records);
    }
}

