/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.data;

import java.io.IOException;
import java.util.List;
import org.apache.iceberg.DataFile;
import org.apache.iceberg.DeleteFile;
import org.apache.iceberg.Schema;
import org.apache.iceberg.StructLike;
import org.apache.iceberg.Table;
import org.apache.iceberg.data.GenericFileWriterFactory;
import org.apache.iceberg.data.Record;
import org.apache.iceberg.deletes.EqualityDeleteWriter;
import org.apache.iceberg.deletes.PositionDelete;
import org.apache.iceberg.deletes.PositionDeleteWriter;
import org.apache.iceberg.encryption.EncryptedFiles;
import org.apache.iceberg.encryption.EncryptedOutputFile;
import org.apache.iceberg.encryption.EncryptionKeyMetadata;
import org.apache.iceberg.io.DataWriter;
import org.apache.iceberg.io.OutputFile;
import org.apache.iceberg.types.Types;
import org.apache.iceberg.util.CharSequenceSet;
import org.apache.iceberg.util.Pair;

public class FileHelpers {
    private FileHelpers() {
    }

    public static Pair<DeleteFile, CharSequenceSet> writeDeleteFile(Table table, OutputFile out, List<Pair<CharSequence, Long>> deletes) throws IOException {
        return FileHelpers.writeDeleteFile(table, out, null, deletes);
    }

    public static Pair<DeleteFile, CharSequenceSet> writeDeleteFile(Table table, OutputFile out, StructLike partition, List<Pair<CharSequence, Long>> deletes) throws IOException {
        GenericFileWriterFactory factory = GenericFileWriterFactory.builderFor((Table)table).build();
        PositionDeleteWriter writer = factory.newPositionDeleteWriter(FileHelpers.encrypt(out), table.spec(), partition);
        PositionDelete posDelete = PositionDelete.create();
        try (PositionDeleteWriter toClose = writer;){
            for (Pair<CharSequence, Long> delete : deletes) {
                writer.write(posDelete.set((CharSequence)delete.first(), ((Long)delete.second()).longValue(), null));
            }
        }
        return Pair.of((Object)writer.toDeleteFile(), (Object)writer.referencedDataFiles());
    }

    public static DeleteFile writeDeleteFile(Table table, OutputFile out, List<Record> deletes, Schema deleteRowSchema) throws IOException {
        return FileHelpers.writeDeleteFile(table, out, null, deletes, deleteRowSchema);
    }

    public static DeleteFile writeDeleteFile(Table table, OutputFile out, StructLike partition, List<Record> deletes, Schema deleteRowSchema) throws IOException {
        EqualityDeleteWriter writer;
        int[] equalityFieldIds = deleteRowSchema.columns().stream().mapToInt(Types.NestedField::fieldId).toArray();
        GenericFileWriterFactory factory = GenericFileWriterFactory.builderFor((Table)table).equalityDeleteRowSchema(deleteRowSchema).equalityFieldIds(equalityFieldIds).build();
        try (EqualityDeleteWriter toClose = writer = factory.newEqualityDeleteWriter(FileHelpers.encrypt(out), table.spec(), partition);){
            writer.write(deletes);
        }
        return writer.toDeleteFile();
    }

    public static DataFile writeDataFile(Table table, OutputFile out, List<Record> rows) throws IOException {
        DataWriter writer;
        GenericFileWriterFactory factory = GenericFileWriterFactory.builderFor((Table)table).build();
        try (DataWriter toClose = writer = factory.newDataWriter(FileHelpers.encrypt(out), table.spec(), null);){
            writer.write(rows);
        }
        return writer.toDataFile();
    }

    public static DataFile writeDataFile(Table table, OutputFile out, StructLike partition, List<Record> rows) throws IOException {
        DataWriter writer;
        GenericFileWriterFactory factory = GenericFileWriterFactory.builderFor((Table)table).build();
        try (DataWriter toClose = writer = factory.newDataWriter(FileHelpers.encrypt(out), table.spec(), partition);){
            writer.write(rows);
        }
        return writer.toDataFile();
    }

    public static DeleteFile writePosDeleteFile(Table table, OutputFile out, StructLike partition, List<PositionDelete<?>> deletes) throws IOException {
        PositionDeleteWriter writer;
        GenericFileWriterFactory factory = GenericFileWriterFactory.builderFor((Table)table).positionDeleteRowSchema(table.schema()).build();
        try (PositionDeleteWriter toClose = writer = factory.newPositionDeleteWriter(FileHelpers.encrypt(out), table.spec(), partition);){
            for (PositionDelete<?> delete : deletes) {
                writer.write(delete);
            }
        }
        return writer.toDeleteFile();
    }

    private static EncryptedOutputFile encrypt(OutputFile out) {
        return EncryptedFiles.encryptedOutput((OutputFile)out, (EncryptionKeyMetadata)EncryptionKeyMetadata.EMPTY);
    }
}

