/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.parquet;

import java.io.File;
import java.io.IOException;
import java.util.Map;
import java.util.UUID;
import org.apache.iceberg.FileFormat;
import org.apache.iceberg.Files;
import org.apache.iceberg.Metrics;
import org.apache.iceberg.MetricsConfig;
import org.apache.iceberg.Schema;
import org.apache.iceberg.TestMetrics;
import org.apache.iceberg.data.Record;
import org.apache.iceberg.data.parquet.GenericParquetWriter;
import org.apache.iceberg.io.FileAppender;
import org.apache.iceberg.io.InputFile;
import org.apache.iceberg.io.OutputFile;
import org.apache.iceberg.parquet.Parquet;
import org.apache.iceberg.parquet.ParquetIO;
import org.apache.iceberg.relocated.com.google.common.collect.ImmutableMap;
import org.apache.iceberg.relocated.com.google.common.collect.Lists;
import org.apache.parquet.hadoop.ParquetFileReader;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class TestParquetMetrics
extends TestMetrics {
    private static final Map<String, String> SMALL_ROW_GROUP_CONFIG = ImmutableMap.of((Object)"write.parquet.row-group-size-bytes", (Object)"1600");

    @Parameterized.Parameters(name="formatVersion = {0}")
    public static Object[] parameters() {
        return new Object[]{1, 2};
    }

    public TestParquetMetrics(int formatVersion) {
        super(formatVersion);
    }

    public FileFormat fileFormat() {
        return FileFormat.PARQUET;
    }

    protected OutputFile createOutputFile() throws IOException {
        File tmpFolder = this.temp.newFolder("parquet");
        String filename = UUID.randomUUID().toString();
        return Files.localOutput((File)new File(tmpFolder, FileFormat.PARQUET.addExtension(filename)));
    }

    public Metrics getMetrics(Schema schema, Record ... records) throws IOException {
        return this.getMetrics(schema, MetricsConfig.getDefault(), records);
    }

    public Metrics getMetrics(Schema schema, MetricsConfig metricsConfig, Record ... records) throws IOException {
        return this.getMetrics(schema, this.createOutputFile(), (Map<String, String>)ImmutableMap.of(), metricsConfig, records);
    }

    private Metrics getMetrics(Schema schema, OutputFile file, Map<String, String> properties, MetricsConfig metricsConfig, Record ... records) throws IOException {
        FileAppender writer;
        try (FileAppender appender = writer = Parquet.write((OutputFile)file).schema(schema).setAll(properties).createWriterFunc(GenericParquetWriter::buildWriter).metricsConfig(metricsConfig).build();){
            appender.addAll((Iterable)Lists.newArrayList((Object[])records));
        }
        return writer.metrics();
    }

    protected Metrics getMetricsForRecordsWithSmallRowGroups(Schema schema, OutputFile outputFile, Record ... records) throws IOException {
        return this.getMetrics(schema, outputFile, SMALL_ROW_GROUP_CONFIG, MetricsConfig.getDefault(), records);
    }

    public int splitCount(InputFile inputFile) throws IOException {
        try (ParquetFileReader reader = ParquetFileReader.open((org.apache.parquet.io.InputFile)ParquetIO.file((InputFile)inputFile));){
            int n = reader.getRowGroups().size();
            return n;
        }
    }

    public boolean supportsSmallRowGroups() {
        return true;
    }
}

