/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.io;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.function.Function;
import org.apache.iceberg.DataFile;
import org.apache.iceberg.DeleteFile;
import org.apache.iceberg.FileContent;
import org.apache.iceberg.FileFormat;
import org.apache.iceberg.Files;
import org.apache.iceberg.PartitionKey;
import org.apache.iceberg.PartitionSpec;
import org.apache.iceberg.RowDelta;
import org.apache.iceberg.Schema;
import org.apache.iceberg.StructLike;
import org.apache.iceberg.Table;
import org.apache.iceberg.TableTestBase;
import org.apache.iceberg.avro.Avro;
import org.apache.iceberg.avro.AvroIterable;
import org.apache.iceberg.data.GenericAppenderFactory;
import org.apache.iceberg.data.GenericRecord;
import org.apache.iceberg.data.IcebergGenerics;
import org.apache.iceberg.data.Record;
import org.apache.iceberg.data.avro.DataReader;
import org.apache.iceberg.data.orc.GenericOrcReader;
import org.apache.iceberg.data.parquet.GenericParquetReaders;
import org.apache.iceberg.io.BaseTaskWriter;
import org.apache.iceberg.io.CloseableIterable;
import org.apache.iceberg.io.DeleteSchemaUtil;
import org.apache.iceberg.io.FileAppenderFactory;
import org.apache.iceberg.io.FileIO;
import org.apache.iceberg.io.InputFile;
import org.apache.iceberg.io.OutputFileFactory;
import org.apache.iceberg.io.WriteResult;
import org.apache.iceberg.orc.ORC;
import org.apache.iceberg.parquet.Parquet;
import org.apache.iceberg.relocated.com.google.common.collect.ImmutableList;
import org.apache.iceberg.relocated.com.google.common.collect.Lists;
import org.apache.iceberg.types.Types;
import org.apache.iceberg.util.ArrayUtil;
import org.apache.iceberg.util.StructLikeSet;
import org.apache.orc.TypeDescription;
import org.apache.parquet.schema.MessageType;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class TestTaskEqualityDeltaWriter
extends TableTestBase {
    private static final int FORMAT_V2 = 2;
    private static final long TARGET_FILE_SIZE = 0x8000000L;
    private final FileFormat format;
    private final GenericRecord gRecord = GenericRecord.create((Schema)SCHEMA);
    private final GenericRecord posRecord = GenericRecord.create((Schema)DeleteSchemaUtil.pathPosSchema());
    private OutputFileFactory fileFactory = null;
    private int idFieldId;
    private int dataFieldId;

    @Parameterized.Parameters(name="FileFormat = {0}")
    public static Object[][] parameters() {
        return new Object[][]{{"avro"}, {"orc"}, {"parquet"}};
    }

    public TestTaskEqualityDeltaWriter(String fileFormat) {
        super(2);
        this.format = FileFormat.fromString((String)fileFormat);
    }

    @Before
    public void setupTable() throws IOException {
        this.tableDir = this.temp.newFolder();
        Assert.assertTrue((boolean)this.tableDir.delete());
        this.metadataDir = new File(this.tableDir, "metadata");
        this.table = this.create(SCHEMA, PartitionSpec.unpartitioned());
        this.fileFactory = OutputFileFactory.builderFor((Table)this.table, (int)1, (long)1L).format(this.format).build();
        this.idFieldId = this.table.schema().findField("id").fieldId();
        this.dataFieldId = this.table.schema().findField("data").fieldId();
        this.table.updateProperties().defaultFormat(this.format).commit();
    }

    private Record createRecord(Integer id, String data) {
        return this.gRecord.copy("id", (Object)id, "data", (Object)data);
    }

    @Test
    public void testPureInsert() throws IOException {
        ArrayList eqDeleteFieldIds = Lists.newArrayList((Object[])new Integer[]{this.idFieldId, this.dataFieldId});
        Schema eqDeleteRowSchema = this.table.schema();
        GenericTaskDeltaWriter deltaWriter = this.createTaskWriter(eqDeleteFieldIds, eqDeleteRowSchema);
        ArrayList expected = Lists.newArrayList();
        for (int i = 0; i < 20; ++i) {
            Record record = this.createRecord(i, String.format("val-%d", i));
            expected.add(record);
            deltaWriter.write(record);
        }
        WriteResult result = deltaWriter.complete();
        Assert.assertEquals((String)"Should only have a data file.", (long)1L, (long)result.dataFiles().length);
        Assert.assertEquals((String)"Should have no delete file", (long)0L, (long)result.deleteFiles().length);
        this.commitTransaction(result);
        Assert.assertEquals((String)"Should have expected records", (Object)this.expectedRowSet(expected), (Object)this.actualRowSet("*"));
        deltaWriter = this.createTaskWriter(eqDeleteFieldIds, eqDeleteRowSchema);
        for (int i = 20; i < 30; ++i) {
            Record record = this.createRecord(i, String.format("val-%d", i));
            expected.add(record);
            deltaWriter.write(record);
        }
        result = deltaWriter.complete();
        Assert.assertEquals((String)"Should only have a data file.", (long)1L, (long)result.dataFiles().length);
        Assert.assertEquals((String)"Should have no delete file", (long)0L, (long)result.deleteFiles().length);
        this.commitTransaction(result);
        Assert.assertEquals((String)"Should have expected records", (Object)this.expectedRowSet(expected), (Object)this.actualRowSet("*"));
    }

    @Test
    public void testInsertDuplicatedKey() throws IOException {
        ArrayList equalityFieldIds = Lists.newArrayList((Object[])new Integer[]{this.idFieldId});
        Schema eqDeleteRowSchema = this.table.schema();
        GenericTaskDeltaWriter deltaWriter = this.createTaskWriter(equalityFieldIds, eqDeleteRowSchema);
        deltaWriter.write(this.createRecord(1, "aaa"));
        deltaWriter.write(this.createRecord(2, "bbb"));
        deltaWriter.write(this.createRecord(3, "ccc"));
        deltaWriter.write(this.createRecord(4, "ddd"));
        deltaWriter.write(this.createRecord(4, "eee"));
        deltaWriter.write(this.createRecord(3, "fff"));
        deltaWriter.write(this.createRecord(2, "ggg"));
        deltaWriter.write(this.createRecord(1, "hhh"));
        WriteResult result = deltaWriter.complete();
        this.commitTransaction(result);
        Assert.assertEquals((String)"Should have a data file.", (long)1L, (long)result.dataFiles().length);
        Assert.assertEquals((String)"Should have a pos-delete file", (long)1L, (long)result.deleteFiles().length);
        DeleteFile posDeleteFile = result.deleteFiles()[0];
        Assert.assertEquals((String)"Should be a pos-delete file", (Object)FileContent.POSITION_DELETES, (Object)posDeleteFile.content());
        Assert.assertEquals((long)1L, (long)result.referencedDataFiles().length);
        Assert.assertEquals((String)"Should have expected records", (Object)this.expectedRowSet((Iterable<Record>)ImmutableList.of((Object)this.createRecord(4, "eee"), (Object)this.createRecord(3, "fff"), (Object)this.createRecord(2, "ggg"), (Object)this.createRecord(1, "hhh"))), (Object)this.actualRowSet("*"));
        DataFile dataFile = result.dataFiles()[0];
        Assert.assertEquals((Object)ImmutableList.of((Object)this.createRecord(1, "aaa"), (Object)this.createRecord(2, "bbb"), (Object)this.createRecord(3, "ccc"), (Object)this.createRecord(4, "ddd"), (Object)this.createRecord(4, "eee"), (Object)this.createRecord(3, "fff"), (Object)this.createRecord(2, "ggg"), (Object)this.createRecord(1, "hhh")), this.readRecordsAsList(this.table.schema(), dataFile.path()));
        Schema posDeleteSchema = DeleteSchemaUtil.pathPosSchema();
        Assert.assertEquals((Object)ImmutableList.of((Object)this.posRecord.copy("file_path", (Object)dataFile.path(), "pos", (Object)0L), (Object)this.posRecord.copy("file_path", (Object)dataFile.path(), "pos", (Object)1L), (Object)this.posRecord.copy("file_path", (Object)dataFile.path(), "pos", (Object)2L), (Object)this.posRecord.copy("file_path", (Object)dataFile.path(), "pos", (Object)3L)), this.readRecordsAsList(posDeleteSchema, posDeleteFile.path()));
    }

    @Test
    public void testUpsertSameRow() throws IOException {
        ArrayList eqDeleteFieldIds = Lists.newArrayList((Object[])new Integer[]{this.idFieldId, this.dataFieldId});
        Schema eqDeleteRowSchema = this.table.schema();
        GenericTaskDeltaWriter deltaWriter = this.createTaskWriter(eqDeleteFieldIds, eqDeleteRowSchema);
        Record record = this.createRecord(1, "aaa");
        deltaWriter.write(record);
        deltaWriter.delete(record);
        deltaWriter.write(record);
        WriteResult result = deltaWriter.complete();
        Assert.assertEquals((String)"Should have a data file.", (long)1L, (long)result.dataFiles().length);
        Assert.assertEquals((String)"Should have a pos-delete file.", (long)1L, (long)result.deleteFiles().length);
        this.commitTransaction(result);
        Assert.assertEquals((String)"Should have an expected record", (Object)this.expectedRowSet((Iterable<Record>)ImmutableList.of((Object)record)), (Object)this.actualRowSet("*"));
        DataFile dataFile = result.dataFiles()[0];
        Assert.assertEquals((Object)ImmutableList.of((Object)record, (Object)record), this.readRecordsAsList(this.table.schema(), dataFile.path()));
        DeleteFile posDeleteFile = result.deleteFiles()[0];
        Assert.assertEquals((Object)ImmutableList.of((Object)this.posRecord.copy("file_path", (Object)dataFile.path(), "pos", (Object)0L)), this.readRecordsAsList(DeleteSchemaUtil.pathPosSchema(), posDeleteFile.path()));
        deltaWriter = this.createTaskWriter(eqDeleteFieldIds, eqDeleteRowSchema);
        deltaWriter.delete(record);
        result = deltaWriter.complete();
        Assert.assertEquals((String)"Should have 0 data file.", (long)0L, (long)result.dataFiles().length);
        Assert.assertEquals((String)"Should have 1 eq-delete file", (long)1L, (long)result.deleteFiles().length);
        this.commitTransaction(result);
        Assert.assertEquals((String)"Should have no record", (Object)this.expectedRowSet((Iterable<Record>)ImmutableList.of()), (Object)this.actualRowSet("*"));
    }

    @Test
    public void testUpsertData() throws IOException {
        ArrayList eqDeleteFieldIds = Lists.newArrayList((Object[])new Integer[]{this.dataFieldId});
        Schema eqDeleteRowSchema = this.table.schema().select(new String[]{"data"});
        GenericTaskDeltaWriter deltaWriter = this.createTaskWriter(eqDeleteFieldIds, eqDeleteRowSchema);
        deltaWriter.write(this.createRecord(1, "aaa"));
        deltaWriter.write(this.createRecord(2, "bbb"));
        deltaWriter.write(this.createRecord(3, "aaa"));
        deltaWriter.write(this.createRecord(3, "ccc"));
        deltaWriter.write(this.createRecord(4, "ccc"));
        WriteResult result = deltaWriter.complete();
        Assert.assertEquals((String)"Should have a data file", (long)1L, (long)result.dataFiles().length);
        Assert.assertEquals((String)"Should have a pos-delete file for deduplication purpose", (long)1L, (long)result.deleteFiles().length);
        Assert.assertEquals((String)"Should be pos-delete file", (Object)FileContent.POSITION_DELETES, (Object)result.deleteFiles()[0].content());
        Assert.assertEquals((long)1L, (long)result.referencedDataFiles().length);
        this.commitTransaction(result);
        Assert.assertEquals((String)"Should have expected records", (Object)this.expectedRowSet((Iterable<Record>)ImmutableList.of((Object)this.createRecord(2, "bbb"), (Object)this.createRecord(3, "aaa"), (Object)this.createRecord(4, "ccc"))), (Object)this.actualRowSet("*"));
        deltaWriter = this.createTaskWriter(eqDeleteFieldIds, eqDeleteRowSchema);
        GenericRecord keyRecord = GenericRecord.create((Schema)eqDeleteRowSchema);
        Function<String, Record> keyFunc = data -> keyRecord.copy("data", data);
        deltaWriter.deleteKey(keyFunc.apply("aaa"));
        deltaWriter.write(this.createRecord(5, "aaa"));
        deltaWriter.deleteKey(keyFunc.apply("aaa"));
        deltaWriter.write(this.createRecord(6, "aaa"));
        deltaWriter.deleteKey(keyFunc.apply("ccc"));
        deltaWriter.write(this.createRecord(7, "ccc"));
        deltaWriter.deleteKey(keyFunc.apply("bbb"));
        result = deltaWriter.complete();
        Assert.assertEquals((long)1L, (long)result.dataFiles().length);
        Assert.assertEquals((long)2L, (long)result.deleteFiles().length);
        this.commitTransaction(result);
        Assert.assertEquals((String)"Should have expected records", (Object)this.expectedRowSet((Iterable<Record>)ImmutableList.of((Object)this.createRecord(6, "aaa"), (Object)this.createRecord(7, "ccc"))), (Object)this.actualRowSet("*"));
        DataFile dataFile = result.dataFiles()[0];
        Assert.assertEquals((Object)ImmutableList.of((Object)this.createRecord(5, "aaa"), (Object)this.createRecord(6, "aaa"), (Object)this.createRecord(7, "ccc")), this.readRecordsAsList(this.table.schema(), dataFile.path()));
        DeleteFile eqDeleteFile = result.deleteFiles()[0];
        Assert.assertEquals((Object)FileContent.EQUALITY_DELETES, (Object)eqDeleteFile.content());
        Assert.assertEquals((Object)ImmutableList.of((Object)keyFunc.apply("aaa"), (Object)keyFunc.apply("ccc"), (Object)keyFunc.apply("bbb")), this.readRecordsAsList(eqDeleteRowSchema, eqDeleteFile.path()));
        DeleteFile posDeleteFile = result.deleteFiles()[1];
        Schema posDeleteSchema = DeleteSchemaUtil.pathPosSchema();
        Assert.assertEquals((Object)FileContent.POSITION_DELETES, (Object)posDeleteFile.content());
        Assert.assertEquals((Object)ImmutableList.of((Object)this.posRecord.copy("file_path", (Object)dataFile.path(), "pos", (Object)0L)), this.readRecordsAsList(posDeleteSchema, posDeleteFile.path()));
    }

    @Test
    public void testUpsertDataWithFullRowSchema() throws IOException {
        ArrayList eqDeleteFieldIds = Lists.newArrayList((Object[])new Integer[]{this.dataFieldId});
        Schema eqDeleteRowSchema = this.table.schema();
        GenericTaskDeltaWriter deltaWriter = this.createTaskWriter(eqDeleteFieldIds, eqDeleteRowSchema);
        deltaWriter.write(this.createRecord(1, "aaa"));
        deltaWriter.write(this.createRecord(2, "bbb"));
        deltaWriter.write(this.createRecord(3, "aaa"));
        deltaWriter.write(this.createRecord(3, "ccc"));
        deltaWriter.write(this.createRecord(4, "ccc"));
        WriteResult result = deltaWriter.complete();
        Assert.assertEquals((String)"Should have a data file", (long)1L, (long)result.dataFiles().length);
        Assert.assertEquals((String)"Should have a pos-delete file for deduplication purpose", (long)1L, (long)result.deleteFiles().length);
        Assert.assertEquals((String)"Should be pos-delete file", (Object)FileContent.POSITION_DELETES, (Object)result.deleteFiles()[0].content());
        Assert.assertEquals((long)1L, (long)result.referencedDataFiles().length);
        this.commitTransaction(result);
        Assert.assertEquals((String)"Should have expected records", (Object)this.expectedRowSet((Iterable<Record>)ImmutableList.of((Object)this.createRecord(2, "bbb"), (Object)this.createRecord(3, "aaa"), (Object)this.createRecord(4, "ccc"))), (Object)this.actualRowSet("*"));
        deltaWriter = this.createTaskWriter(eqDeleteFieldIds, eqDeleteRowSchema);
        deltaWriter.delete(this.createRecord(3, "aaa"));
        deltaWriter.write(this.createRecord(5, "aaa"));
        deltaWriter.delete(this.createRecord(5, "aaa"));
        deltaWriter.write(this.createRecord(6, "aaa"));
        deltaWriter.delete(this.createRecord(4, "ccc"));
        deltaWriter.write(this.createRecord(7, "ccc"));
        deltaWriter.delete(this.createRecord(2, "bbb"));
        result = deltaWriter.complete();
        Assert.assertEquals((long)1L, (long)result.dataFiles().length);
        Assert.assertEquals((long)2L, (long)result.deleteFiles().length);
        Assert.assertEquals((long)1L, (long)result.referencedDataFiles().length);
        this.commitTransaction(result);
        Assert.assertEquals((String)"Should have expected records", (Object)this.expectedRowSet((Iterable<Record>)ImmutableList.of((Object)this.createRecord(6, "aaa"), (Object)this.createRecord(7, "ccc"))), (Object)this.actualRowSet("*"));
        DataFile dataFile = result.dataFiles()[0];
        Assert.assertEquals((Object)ImmutableList.of((Object)this.createRecord(5, "aaa"), (Object)this.createRecord(6, "aaa"), (Object)this.createRecord(7, "ccc")), this.readRecordsAsList(this.table.schema(), dataFile.path()));
        DeleteFile eqDeleteFile = result.deleteFiles()[0];
        Assert.assertEquals((Object)FileContent.EQUALITY_DELETES, (Object)eqDeleteFile.content());
        Assert.assertEquals((Object)ImmutableList.of((Object)this.createRecord(3, "aaa"), (Object)this.createRecord(4, "ccc"), (Object)this.createRecord(2, "bbb")), this.readRecordsAsList(eqDeleteRowSchema, eqDeleteFile.path()));
        DeleteFile posDeleteFile = result.deleteFiles()[1];
        Schema posDeleteSchema = DeleteSchemaUtil.pathPosSchema();
        Assert.assertEquals((Object)FileContent.POSITION_DELETES, (Object)posDeleteFile.content());
        Assert.assertEquals((Object)ImmutableList.of((Object)this.posRecord.copy("file_path", (Object)dataFile.path(), "pos", (Object)0L)), this.readRecordsAsList(posDeleteSchema, posDeleteFile.path()));
    }

    private void commitTransaction(WriteResult result) {
        RowDelta rowDelta = this.table.newRowDelta();
        Arrays.stream(result.dataFiles()).forEach(arg_0 -> ((RowDelta)rowDelta).addRows(arg_0));
        Arrays.stream(result.deleteFiles()).forEach(arg_0 -> ((RowDelta)rowDelta).addDeletes(arg_0));
        rowDelta.validateDeletedFiles().validateDataFilesExist((Iterable)Lists.newArrayList((Object[])result.referencedDataFiles())).commit();
    }

    private StructLikeSet expectedRowSet(Iterable<Record> records) {
        StructLikeSet set = StructLikeSet.create((Types.StructType)this.table.schema().asStruct());
        records.forEach(arg_0 -> ((StructLikeSet)set).add(arg_0));
        return set;
    }

    private StructLikeSet actualRowSet(String ... columns) throws IOException {
        StructLikeSet set = StructLikeSet.create((Types.StructType)this.table.schema().asStruct());
        try (CloseableIterable reader = IcebergGenerics.read((Table)this.table).select(columns).build();){
            reader.forEach(arg_0 -> ((StructLikeSet)set).add(arg_0));
        }
        return set;
    }

    private GenericTaskDeltaWriter createTaskWriter(List<Integer> equalityFieldIds, Schema eqDeleteRowSchema) {
        GenericAppenderFactory appenderFactory = new GenericAppenderFactory(this.table.schema(), this.table.spec(), ArrayUtil.toIntArray(equalityFieldIds), eqDeleteRowSchema, null);
        ArrayList columns = Lists.newArrayList();
        for (Integer fieldId : equalityFieldIds) {
            columns.add(this.table.schema().findField(fieldId.intValue()).name());
        }
        Schema deleteSchema = this.table.schema().select((Collection)columns);
        return new GenericTaskDeltaWriter(this.table.schema(), deleteSchema, this.table.spec(), this.format, (FileAppenderFactory)appenderFactory, this.fileFactory, this.table.io(), 0x8000000L);
    }

    private List<Record> readRecordsAsList(Schema schema, CharSequence path) throws IOException {
        AvroIterable iterable;
        InputFile inputFile = Files.localInput((String)path.toString());
        switch (this.format) {
            case PARQUET: {
                iterable = Parquet.read((InputFile)inputFile).project(schema).createReaderFunc(fileSchema -> GenericParquetReaders.buildReader((Schema)schema, (MessageType)fileSchema)).build();
                break;
            }
            case AVRO: {
                iterable = Avro.read((InputFile)inputFile).project(schema).createReaderFunc(DataReader::create).build();
                break;
            }
            case ORC: {
                iterable = ORC.read((InputFile)inputFile).project(schema).createReaderFunc(fileSchema -> GenericOrcReader.buildReader((Schema)schema, (TypeDescription)fileSchema)).build();
                break;
            }
            default: {
                throw new UnsupportedOperationException("Unsupported file format: " + this.format);
            }
        }
        try (AvroIterable closeableIterable = iterable;){
            ArrayList arrayList = Lists.newArrayList((Iterable)closeableIterable);
            return arrayList;
        }
    }

    private static class GenericTaskDeltaWriter
    extends BaseTaskWriter<Record> {
        private final GenericEqualityDeltaWriter deltaWriter;

        private GenericTaskDeltaWriter(Schema schema, Schema deleteSchema, PartitionSpec spec, FileFormat format, FileAppenderFactory<Record> appenderFactory, OutputFileFactory fileFactory, FileIO io, long targetFileSize) {
            super(spec, format, appenderFactory, fileFactory, io, targetFileSize);
            this.deltaWriter = new GenericEqualityDeltaWriter(null, schema, deleteSchema);
        }

        public void write(Record row) throws IOException {
            this.deltaWriter.write(row);
        }

        public void delete(Record row) throws IOException {
            this.deltaWriter.delete(row);
        }

        public void deleteKey(Record key) throws IOException {
            this.deltaWriter.deleteKey(key);
        }

        public void close() throws IOException {
            this.deltaWriter.close();
        }

        private class GenericEqualityDeltaWriter
        extends BaseTaskWriter.BaseEqualityDeltaWriter {
            private GenericEqualityDeltaWriter(PartitionKey partition, Schema schema, Schema eqDeleteSchema) {
                super((BaseTaskWriter)GenericTaskDeltaWriter.this, (StructLike)partition, schema, eqDeleteSchema);
            }

            protected StructLike asStructLike(Record row) {
                return row;
            }

            protected StructLike asStructLikeKey(Record data) {
                return data;
            }
        }
    }
}

