/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.io;

import java.io.File;
import java.io.IOException;
import org.apache.iceberg.DataFile;
import org.apache.iceberg.DeleteFile;
import org.apache.iceberg.FileFormat;
import org.apache.iceberg.PartitionSpec;
import org.apache.iceberg.RowDelta;
import org.apache.iceberg.StructLike;
import org.apache.iceberg.Table;
import org.apache.iceberg.expressions.Expressions;
import org.apache.iceberg.expressions.Term;
import org.apache.iceberg.io.BasePositionDeltaWriter;
import org.apache.iceberg.io.ClusteredDataWriter;
import org.apache.iceberg.io.ClusteredPositionDeleteWriter;
import org.apache.iceberg.io.FileWriterFactory;
import org.apache.iceberg.io.OutputFileFactory;
import org.apache.iceberg.io.PartitioningWriter;
import org.apache.iceberg.io.WriteResult;
import org.apache.iceberg.io.WriterTestBase;
import org.apache.iceberg.relocated.com.google.common.collect.ImmutableList;
import org.apache.iceberg.util.StructLikeSet;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public abstract class TestPositionDeltaWriters<T>
extends WriterTestBase<T> {
    private static final int TABLE_FORMAT_VERSION = 2;
    private static final long TARGET_FILE_SIZE = 0x8000000L;
    private final FileFormat fileFormat;
    private OutputFileFactory fileFactory = null;

    @Parameterized.Parameters(name="FileFormat={0}")
    public static Object[] parameters() {
        return new Object[][]{{FileFormat.AVRO}, {FileFormat.ORC}, {FileFormat.PARQUET}};
    }

    public TestPositionDeltaWriters(FileFormat fileFormat) {
        super(2);
        this.fileFormat = fileFormat;
    }

    protected abstract StructLikeSet toSet(Iterable<T> var1);

    protected FileFormat format() {
        return this.fileFormat;
    }

    @Before
    public void setupTable() throws Exception {
        this.tableDir = this.temp.newFolder();
        Assert.assertTrue((boolean)this.tableDir.delete());
        this.metadataDir = new File(this.tableDir, "metadata");
        this.table = this.create(SCHEMA, PartitionSpec.unpartitioned());
        this.fileFactory = OutputFileFactory.builderFor((Table)this.table, (int)1, (long)1L).format(this.fileFormat).build();
    }

    @Test
    public void testPositionDeltaWithOneDataWriter() throws IOException {
        FileWriterFactory writerFactory = this.newWriterFactory(this.table.schema());
        ClusteredDataWriter dataWriter = new ClusteredDataWriter(writerFactory, this.fileFactory, this.table.io(), 0x8000000L);
        ClusteredPositionDeleteWriter deleteWriter = new ClusteredPositionDeleteWriter(writerFactory, this.fileFactory, this.table.io(), 0x8000000L);
        BasePositionDeltaWriter deltaWriter = new BasePositionDeltaWriter((PartitioningWriter)dataWriter, (PartitioningWriter)deleteWriter);
        deltaWriter.insert(this.toRow(1, "insert"), this.table.spec(), null);
        deltaWriter.update(this.toRow(2, "update"), this.table.spec(), null);
        deltaWriter.close();
        WriteResult result = deltaWriter.result();
        DataFile[] dataFiles = result.dataFiles();
        DeleteFile[] deleteFiles = result.deleteFiles();
        CharSequence[] referencedDataFiles = result.referencedDataFiles();
        Assert.assertEquals((String)"Must be 1 data files", (long)1L, (long)dataFiles.length);
        Assert.assertEquals((String)"Must be no delete files", (long)0L, (long)deleteFiles.length);
        Assert.assertEquals((String)"Must not reference data files", (long)0L, (long)referencedDataFiles.length);
    }

    @Test
    public void testPositionDeltaInsertOnly() throws IOException {
        FileWriterFactory writerFactory = this.newWriterFactory(this.table.schema());
        ClusteredDataWriter insertWriter = new ClusteredDataWriter(writerFactory, this.fileFactory, this.table.io(), 0x8000000L);
        ClusteredDataWriter updateWriter = new ClusteredDataWriter(writerFactory, this.fileFactory, this.table.io(), 0x8000000L);
        ClusteredPositionDeleteWriter deleteWriter = new ClusteredPositionDeleteWriter(writerFactory, this.fileFactory, this.table.io(), 0x8000000L);
        BasePositionDeltaWriter deltaWriter = new BasePositionDeltaWriter((PartitioningWriter)insertWriter, (PartitioningWriter)updateWriter, (PartitioningWriter)deleteWriter);
        deltaWriter.insert(this.toRow(1, "aaa"), this.table.spec(), null);
        deltaWriter.close();
        WriteResult result = deltaWriter.result();
        DataFile[] dataFiles = result.dataFiles();
        DeleteFile[] deleteFiles = result.deleteFiles();
        CharSequence[] referencedDataFiles = result.referencedDataFiles();
        Assert.assertEquals((String)"Must be 1 data files", (long)1L, (long)dataFiles.length);
        Assert.assertEquals((String)"Must be no delete files", (long)0L, (long)deleteFiles.length);
        Assert.assertEquals((String)"Must not reference data files", (long)0L, (long)referencedDataFiles.length);
        RowDelta rowDelta = this.table.newRowDelta();
        for (DataFile dataFile : dataFiles) {
            rowDelta.addRows(dataFile);
        }
        rowDelta.commit();
        ImmutableList expectedRows = ImmutableList.of(this.toRow(1, "aaa"));
        Assert.assertEquals((String)"Records should match", (Object)this.toSet((Iterable<T>)expectedRows), (Object)this.actualRowSet("*"));
    }

    @Test
    public void testPositionDeltaDeleteOnly() throws IOException {
        FileWriterFactory writerFactory = this.newWriterFactory(this.table.schema());
        ImmutableList rows1 = ImmutableList.of(this.toRow(1, "aaa"), this.toRow(2, "aaa"), this.toRow(11, "aaa"));
        DataFile dataFile1 = this.writeData(writerFactory, this.fileFactory, rows1, this.table.spec(), (StructLike)null);
        this.table.newFastAppend().appendFile(dataFile1).commit();
        this.table.updateSpec().addField((Term)Expressions.ref((String)"data")).commit();
        ImmutableList rows2 = ImmutableList.of(this.toRow(3, "bbb"), this.toRow(4, "bbb"));
        DataFile dataFile2 = this.writeData(writerFactory, this.fileFactory, rows2, this.table.spec(), (StructLike)this.partitionKey(this.table.spec(), "bbb"));
        this.table.newFastAppend().appendFile(dataFile2).commit();
        PartitionSpec unpartitionedSpec = (PartitionSpec)this.table.specs().get(0);
        PartitionSpec partitionedSpec = (PartitionSpec)this.table.specs().get(1);
        ClusteredDataWriter insertWriter = new ClusteredDataWriter(writerFactory, this.fileFactory, this.table.io(), 0x8000000L);
        ClusteredDataWriter updateWriter = new ClusteredDataWriter(writerFactory, this.fileFactory, this.table.io(), 0x8000000L);
        ClusteredPositionDeleteWriter deleteWriter = new ClusteredPositionDeleteWriter(writerFactory, this.fileFactory, this.table.io(), 0x8000000L);
        BasePositionDeltaWriter deltaWriter = new BasePositionDeltaWriter((PartitioningWriter)insertWriter, (PartitioningWriter)updateWriter, (PartitioningWriter)deleteWriter);
        deltaWriter.delete(dataFile1.path(), 2L, unpartitionedSpec, null);
        deltaWriter.delete(dataFile2.path(), 1L, partitionedSpec, (StructLike)this.partitionKey(partitionedSpec, "bbb"));
        deltaWriter.close();
        WriteResult result = deltaWriter.result();
        DataFile[] dataFiles = result.dataFiles();
        DeleteFile[] deleteFiles = result.deleteFiles();
        CharSequence[] referencedDataFiles = result.referencedDataFiles();
        Assert.assertEquals((String)"Must be 0 data files", (long)0L, (long)dataFiles.length);
        Assert.assertEquals((String)"Must be 2 delete files", (long)2L, (long)deleteFiles.length);
        Assert.assertEquals((String)"Must reference 2 data files", (long)2L, (long)referencedDataFiles.length);
        RowDelta rowDelta = this.table.newRowDelta();
        for (DeleteFile deleteFile : deleteFiles) {
            rowDelta.addDeletes(deleteFile);
        }
        rowDelta.commit();
        ImmutableList expectedRows = ImmutableList.of(this.toRow(1, "aaa"), this.toRow(2, "aaa"), this.toRow(3, "bbb"));
        Assert.assertEquals((String)"Records should match", (Object)this.toSet((Iterable<T>)expectedRows), (Object)this.actualRowSet("*"));
    }

    @Test
    public void testPositionDeltaMultipleSpecs() throws IOException {
        FileWriterFactory writerFactory = this.newWriterFactory(this.table.schema());
        ImmutableList rows1 = ImmutableList.of(this.toRow(1, "aaa"), this.toRow(2, "aaa"), this.toRow(11, "aaa"));
        DataFile dataFile1 = this.writeData(writerFactory, this.fileFactory, rows1, this.table.spec(), (StructLike)null);
        this.table.newFastAppend().appendFile(dataFile1).commit();
        this.table.updateSpec().addField((Term)Expressions.ref((String)"data")).commit();
        ImmutableList rows2 = ImmutableList.of(this.toRow(3, "bbb"), this.toRow(4, "bbb"));
        DataFile dataFile2 = this.writeData(writerFactory, this.fileFactory, rows2, this.table.spec(), (StructLike)this.partitionKey(this.table.spec(), "bbb"));
        this.table.newFastAppend().appendFile(dataFile2).commit();
        PartitionSpec unpartitionedSpec = (PartitionSpec)this.table.specs().get(0);
        PartitionSpec partitionedSpec = (PartitionSpec)this.table.specs().get(1);
        ClusteredDataWriter insertWriter = new ClusteredDataWriter(writerFactory, this.fileFactory, this.table.io(), 0x8000000L);
        ClusteredDataWriter updateWriter = new ClusteredDataWriter(writerFactory, this.fileFactory, this.table.io(), 0x8000000L);
        ClusteredPositionDeleteWriter deleteWriter = new ClusteredPositionDeleteWriter(writerFactory, this.fileFactory, this.table.io(), 0x8000000L);
        BasePositionDeltaWriter deltaWriter = new BasePositionDeltaWriter((PartitioningWriter)insertWriter, (PartitioningWriter)updateWriter, (PartitioningWriter)deleteWriter);
        deltaWriter.delete(dataFile1.path(), 2L, unpartitionedSpec, null);
        deltaWriter.delete(dataFile2.path(), 1L, partitionedSpec, (StructLike)this.partitionKey(partitionedSpec, "bbb"));
        deltaWriter.insert(this.toRow(10, "ccc"), partitionedSpec, (StructLike)this.partitionKey(partitionedSpec, "ccc"));
        deltaWriter.close();
        WriteResult result = deltaWriter.result();
        DataFile[] dataFiles = result.dataFiles();
        DeleteFile[] deleteFiles = result.deleteFiles();
        CharSequence[] referencedDataFiles = result.referencedDataFiles();
        Assert.assertEquals((String)"Must be 1 data files", (long)1L, (long)dataFiles.length);
        Assert.assertEquals((String)"Must be 2 delete files", (long)2L, (long)deleteFiles.length);
        Assert.assertEquals((String)"Must reference 2 data files", (long)2L, (long)referencedDataFiles.length);
        RowDelta rowDelta = this.table.newRowDelta();
        for (DataFile dataFile : dataFiles) {
            rowDelta.addRows(dataFile);
        }
        for (DataFile dataFile : deleteFiles) {
            rowDelta.addDeletes((DeleteFile)dataFile);
        }
        rowDelta.commit();
        ImmutableList expectedRows = ImmutableList.of(this.toRow(1, "aaa"), this.toRow(2, "aaa"), this.toRow(3, "bbb"), this.toRow(10, "ccc"));
        Assert.assertEquals((String)"Records should match", (Object)this.toSet((Iterable<T>)expectedRows), (Object)this.actualRowSet("*"));
    }
}

