/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.io;

import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.iceberg.FileFormat;
import org.apache.iceberg.PartitionSpec;
import org.apache.iceberg.RowDelta;
import org.apache.iceberg.Schema;
import org.apache.iceberg.Table;
import org.apache.iceberg.TableTestBase;
import org.apache.iceberg.data.GenericAppenderFactory;
import org.apache.iceberg.data.GenericRecord;
import org.apache.iceberg.data.IcebergGenerics;
import org.apache.iceberg.data.Record;
import org.apache.iceberg.io.BaseTaskWriter;
import org.apache.iceberg.io.CloseableIterable;
import org.apache.iceberg.io.FileAppenderFactory;
import org.apache.iceberg.io.FileIO;
import org.apache.iceberg.io.OutputFileFactory;
import org.apache.iceberg.io.WriteResult;
import org.apache.iceberg.relocated.com.google.common.collect.Lists;
import org.apache.iceberg.types.Types;
import org.apache.iceberg.util.StructLikeSet;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class TestBaseTaskWriter
extends TableTestBase {
    private static final int FORMAT_V2 = 2;
    private final FileFormat format;
    private final GenericRecord gRecord = GenericRecord.create((Schema)SCHEMA);
    private OutputFileFactory fileFactory = null;
    private FileAppenderFactory<Record> appenderFactory = null;

    @Parameterized.Parameters(name="FileFormat = {0}")
    public static Object[][] parameters() {
        return new Object[][]{{"avro"}, {"orc"}, {"parquet"}};
    }

    public TestBaseTaskWriter(String fileFormat) {
        super(2);
        this.format = FileFormat.fromString((String)fileFormat);
    }

    @Before
    public void setupTable() throws IOException {
        this.tableDir = this.temp.newFolder();
        Assert.assertTrue((boolean)this.tableDir.delete());
        this.metadataDir = new File(this.tableDir, "metadata");
        this.table = this.create(SCHEMA, PartitionSpec.unpartitioned());
        this.fileFactory = OutputFileFactory.builderFor((Table)this.table, (int)1, (long)1L).format(this.format).build();
        int firstFieldId = this.table.schema().findField("id").fieldId();
        int secondFieldId = this.table.schema().findField("data").fieldId();
        this.appenderFactory = new GenericAppenderFactory(this.table.schema(), this.table.spec(), new int[]{firstFieldId, secondFieldId}, this.table.schema(), null);
        this.table.updateProperties().defaultFormat(this.format).commit();
    }

    private Record createRecord(Integer id, String data) {
        return this.gRecord.copy("id", (Object)id, "data", (Object)data);
    }

    @Test
    public void testWriteZeroRecord() throws IOException {
        try (TestTaskWriter writer = this.createTaskWriter(0x8000000L);){
            writer.close();
            WriteResult result = writer.complete();
            Assert.assertEquals((long)0L, (long)result.dataFiles().length);
            Assert.assertEquals((long)0L, (long)result.deleteFiles().length);
            writer.close();
            result = writer.complete();
            Assert.assertEquals((long)0L, (long)result.dataFiles().length);
            Assert.assertEquals((long)0L, (long)result.deleteFiles().length);
        }
    }

    @Test
    public void testAbort() throws IOException {
        List files;
        ArrayList records = Lists.newArrayList();
        for (int i = 0; i < 2000; ++i) {
            records.add(this.createRecord(i, "aaa"));
        }
        try (TestTaskWriter taskWriter = this.createTaskWriter(4L);){
            for (Record record : records) {
                taskWriter.write(record);
                taskWriter.delete(record);
            }
            taskWriter.close();
            files = Files.list(Paths.get(this.tableDir.getPath(), "data")).filter(p -> !p.toString().endsWith(".crc")).collect(Collectors.toList());
            Assert.assertEquals((String)("Should have 4 files but the files are: " + files), (long)4L, (long)files.size());
            taskWriter.abort();
        }
        for (Path path : files) {
            Assert.assertFalse((boolean)Files.exists(path, new LinkOption[0]));
        }
    }

    @Test
    public void testRollIfExceedTargetFileSize() throws IOException {
        WriteResult result;
        ArrayList records = Lists.newArrayListWithCapacity((int)8000);
        for (int i = 0; i < 2000; ++i) {
            records.add(this.createRecord(i, "aaa"));
            records.add(this.createRecord(i, "bbb"));
            records.add(this.createRecord(i, "ccc"));
            records.add(this.createRecord(i, "ddd"));
        }
        try (TestTaskWriter taskWriter = this.createTaskWriter(4L);){
            for (Record record : records) {
                taskWriter.write(record);
            }
            result = taskWriter.complete();
            Assert.assertEquals((long)8L, (long)result.dataFiles().length);
            Assert.assertEquals((long)0L, (long)result.deleteFiles().length);
        }
        RowDelta rowDelta = this.table.newRowDelta();
        Arrays.stream(result.dataFiles()).forEach(arg_0 -> ((RowDelta)rowDelta).addRows(arg_0));
        rowDelta.commit();
        ArrayList expected = Lists.newArrayList();
        try (TestTaskWriter taskWriter = this.createTaskWriter(3L);){
            for (Record record : records) {
                taskWriter.delete(record);
                int id = (Integer)record.get(0, Integer.class);
                String data = (String)record.get(1, String.class);
                Record newRecord = this.createRecord(id, data.toUpperCase());
                expected.add(newRecord);
                taskWriter.write(newRecord);
            }
            result = taskWriter.complete();
            Assert.assertEquals((long)8L, (long)result.dataFiles().length);
            Assert.assertEquals((long)8L, (long)result.deleteFiles().length);
        }
        rowDelta = this.table.newRowDelta();
        Arrays.stream(result.dataFiles()).forEach(arg_0 -> ((RowDelta)rowDelta).addRows(arg_0));
        Arrays.stream(result.deleteFiles()).forEach(arg_0 -> ((RowDelta)rowDelta).addDeletes(arg_0));
        rowDelta.commit();
        Assert.assertEquals((String)"Should have expected records", (Object)this.expectedRowSet(expected), (Object)this.actualRowSet("*"));
    }

    private StructLikeSet expectedRowSet(Iterable<Record> records) {
        StructLikeSet set = StructLikeSet.create((Types.StructType)this.table.schema().asStruct());
        records.forEach(arg_0 -> ((StructLikeSet)set).add(arg_0));
        return set;
    }

    private StructLikeSet actualRowSet(String ... columns) throws IOException {
        StructLikeSet set = StructLikeSet.create((Types.StructType)this.table.schema().asStruct());
        try (CloseableIterable reader = IcebergGenerics.read((Table)this.table).select(columns).build();){
            reader.forEach(arg_0 -> ((StructLikeSet)set).add(arg_0));
        }
        return set;
    }

    private TestTaskWriter createTaskWriter(long targetFileSize) {
        return new TestTaskWriter(this.table.spec(), this.format, this.appenderFactory, this.fileFactory, this.table.io(), targetFileSize);
    }

    private static class TestTaskWriter
    extends BaseTaskWriter<Record> {
        private BaseTaskWriter.RollingFileWriter dataWriter = new BaseTaskWriter.RollingFileWriter((BaseTaskWriter)this, null);
        private BaseTaskWriter.RollingEqDeleteWriter deleteWriter = new BaseTaskWriter.RollingEqDeleteWriter((BaseTaskWriter)this, null);

        private TestTaskWriter(PartitionSpec spec, FileFormat format, FileAppenderFactory<Record> appenderFactory, OutputFileFactory fileFactory, FileIO io, long targetFileSize) {
            super(spec, format, appenderFactory, fileFactory, io, targetFileSize);
        }

        public void write(Record row) throws IOException {
            this.dataWriter.write((Object)row);
        }

        void delete(Record row) throws IOException {
            this.deleteWriter.write((Object)row);
        }

        public void close() throws IOException {
            if (this.dataWriter != null) {
                this.dataWriter.close();
            }
            if (this.deleteWriter != null) {
                this.deleteWriter.close();
            }
        }
    }
}

