/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.data;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.iceberg.ContentFile;
import org.apache.iceberg.DataFile;
import org.apache.iceberg.DeleteFile;
import org.apache.iceberg.FileScanTask;
import org.apache.iceberg.Files;
import org.apache.iceberg.PartitionSpec;
import org.apache.iceberg.Schema;
import org.apache.iceberg.StructLike;
import org.apache.iceberg.Table;
import org.apache.iceberg.TestHelpers;
import org.apache.iceberg.TestTables;
import org.apache.iceberg.data.FileHelpers;
import org.apache.iceberg.data.GenericRecord;
import org.apache.iceberg.data.Record;
import org.apache.iceberg.io.CloseableIterable;
import org.apache.iceberg.io.OutputFile;
import org.apache.iceberg.relocated.com.google.common.collect.ImmutableList;
import org.apache.iceberg.relocated.com.google.common.collect.Iterables;
import org.apache.iceberg.relocated.com.google.common.collect.Lists;
import org.apache.iceberg.types.Type;
import org.apache.iceberg.types.Types;
import org.apache.iceberg.util.CharSequenceSet;
import org.apache.iceberg.util.Pair;
import org.assertj.core.api.Assertions;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TemporaryFolder;

public class TestDataFileIndexStatsFilters {
    private static final Schema SCHEMA = new Schema(new Types.NestedField[]{Types.NestedField.optional((int)1, (String)"id", (Type)Types.IntegerType.get()), Types.NestedField.optional((int)2, (String)"data", (Type)Types.StringType.get()), Types.NestedField.required((int)3, (String)"category", (Type)Types.StringType.get())});
    @Rule
    public TemporaryFolder temp = new TemporaryFolder();
    private Table table;
    private List<Record> records = null;
    private List<Record> oddRecords = null;
    private List<Record> evenRecords = null;
    private DataFile dataFile = null;
    private DataFile dataFileWithoutNulls = null;
    private DataFile dataFileOnlyNulls = null;

    @Before
    public void createTableAndData() throws IOException {
        File location = this.temp.newFolder();
        this.table = TestTables.create((File)location, (String)"test", (Schema)SCHEMA, (PartitionSpec)PartitionSpec.unpartitioned(), (int)2);
        this.records = Lists.newArrayList();
        GenericRecord record = GenericRecord.create((Schema)this.table.schema());
        this.records.add(record.copy("id", (Object)1, "data", (Object)"a", "category", (Object)"odd"));
        this.records.add(record.copy("id", (Object)2, "data", (Object)"b", "category", (Object)"even"));
        this.records.add(record.copy("id", (Object)3, "data", (Object)"c", "category", (Object)"odd"));
        this.records.add(record.copy("id", (Object)4, "data", (Object)"d", "category", (Object)"even"));
        this.records.add(record.copy("id", (Object)5, "data", (Object)"e", "category", (Object)"odd"));
        this.records.add(record.copy("id", (Object)6, "data", (Object)"f", "category", (Object)"even"));
        this.records.add(record.copy("id", (Object)7, "data", (Object)"g", "category", (Object)"odd"));
        this.records.add(record.copy("id", (Object)8, "data", null, "category", (Object)"even"));
        this.oddRecords = this.records.stream().filter(rec -> rec.getField("category").equals("odd")).collect(Collectors.toList());
        this.evenRecords = this.records.stream().filter(rec -> rec.getField("category").equals("even")).collect(Collectors.toList());
        this.dataFile = FileHelpers.writeDataFile(this.table, Files.localOutput((File)this.temp.newFile()), this.records);
        this.dataFileWithoutNulls = FileHelpers.writeDataFile(this.table, Files.localOutput((File)this.temp.newFile()), this.records.stream().filter(rec -> rec.getField("data") != null).collect(Collectors.toList()));
        this.dataFileOnlyNulls = FileHelpers.writeDataFile(this.table, Files.localOutput((File)this.temp.newFile()), this.records.stream().filter(rec -> rec.getField("data") == null).collect(Collectors.toList()));
    }

    @After
    public void dropTable() {
        TestTables.clearTables();
    }

    @Test
    public void testPositionDeletePlanningPath() throws IOException {
        ArrayList tasks;
        this.table.newAppend().appendFile(this.dataFile).commit();
        ArrayList deletes = Lists.newArrayList();
        deletes.add(Pair.of((Object)this.dataFile.path(), (Object)0L));
        deletes.add(Pair.of((Object)this.dataFile.path(), (Object)1L));
        Pair<DeleteFile, CharSequenceSet> posDeletes = FileHelpers.writeDeleteFile(this.table, Files.localOutput((File)this.temp.newFile()), deletes);
        this.table.newRowDelta().addDeletes((DeleteFile)posDeletes.first()).validateDataFilesExist((Iterable)posDeletes.second()).commit();
        try (CloseableIterable tasksIterable = this.table.newScan().planFiles();){
            tasks = Lists.newArrayList((Iterable)tasksIterable);
        }
        Assert.assertEquals((String)"Should produce one task", (long)1L, (long)tasks.size());
        FileScanTask task = (FileScanTask)tasks.get(0);
        Assert.assertEquals((String)"Should have one delete file, file_path matches", (long)1L, (long)task.deletes().size());
    }

    @Test
    public void testPositionDeletePlanningPathFilter() throws IOException {
        ArrayList tasks;
        this.table.newAppend().appendFile(this.dataFile).commit();
        ArrayList deletes = Lists.newArrayList();
        deletes.add(Pair.of((Object)"some-other-file.parquet", (Object)0L));
        deletes.add(Pair.of((Object)"some-other-file.parquet", (Object)1L));
        Pair<DeleteFile, CharSequenceSet> posDeletes = FileHelpers.writeDeleteFile(this.table, Files.localOutput((File)this.temp.newFile()), deletes);
        this.table.newRowDelta().addDeletes((DeleteFile)posDeletes.first()).validateDataFilesExist((Iterable)posDeletes.second()).commit();
        try (CloseableIterable tasksIterable = this.table.newScan().planFiles();){
            tasks = Lists.newArrayList((Iterable)tasksIterable);
        }
        Assert.assertEquals((String)"Should produce one task", (long)1L, (long)tasks.size());
        FileScanTask task = (FileScanTask)tasks.get(0);
        Assert.assertEquals((String)"Should not have delete file, filtered by file_path stats", (long)0L, (long)task.deletes().size());
    }

    @Test
    public void testEqualityDeletePlanningStats() throws IOException {
        ArrayList tasks;
        this.table.newAppend().appendFile(this.dataFile).commit();
        ArrayList deletes = Lists.newArrayList();
        Schema deleteRowSchema = SCHEMA.select(new String[]{"data"});
        GenericRecord delete = GenericRecord.create((Schema)deleteRowSchema);
        deletes.add(delete.copy("data", (Object)"d"));
        DeleteFile posDeletes = FileHelpers.writeDeleteFile(this.table, Files.localOutput((File)this.temp.newFile()), deletes, deleteRowSchema);
        this.table.newRowDelta().addDeletes(posDeletes).commit();
        try (CloseableIterable tasksIterable = this.table.newScan().planFiles();){
            tasks = Lists.newArrayList((Iterable)tasksIterable);
        }
        Assert.assertEquals((String)"Should produce one task", (long)1L, (long)tasks.size());
        FileScanTask task = (FileScanTask)tasks.get(0);
        Assert.assertEquals((String)"Should have one delete file, data contains a matching value", (long)1L, (long)task.deletes().size());
    }

    @Test
    public void testEqualityDeletePlanningStatsFilter() throws IOException {
        ArrayList tasks;
        this.table.newAppend().appendFile(this.dataFile).commit();
        ArrayList deletes = Lists.newArrayList();
        Schema deleteRowSchema = this.table.schema().select(new String[]{"data"});
        GenericRecord delete = GenericRecord.create((Schema)deleteRowSchema);
        deletes.add(delete.copy("data", (Object)"x"));
        deletes.add(delete.copy("data", (Object)"y"));
        deletes.add(delete.copy("data", (Object)"z"));
        DeleteFile posDeletes = FileHelpers.writeDeleteFile(this.table, Files.localOutput((File)this.temp.newFile()), deletes, deleteRowSchema);
        this.table.newRowDelta().addDeletes(posDeletes).commit();
        try (CloseableIterable tasksIterable = this.table.newScan().planFiles();){
            tasks = Lists.newArrayList((Iterable)tasksIterable);
        }
        Assert.assertEquals((String)"Should produce one task", (long)1L, (long)tasks.size());
        FileScanTask task = (FileScanTask)tasks.get(0);
        Assert.assertEquals((String)"Should not have delete file, filtered by data column stats", (long)0L, (long)task.deletes().size());
    }

    @Test
    public void testEqualityDeletePlanningStatsNullValueWithAllNullDeletes() throws IOException {
        ArrayList tasks;
        this.table.newAppend().appendFile(this.dataFile).commit();
        ArrayList deletes = Lists.newArrayList();
        Schema deleteRowSchema = SCHEMA.select(new String[]{"data"});
        GenericRecord delete = GenericRecord.create((Schema)deleteRowSchema);
        deletes.add(delete.copy("data", null));
        DeleteFile posDeletes = FileHelpers.writeDeleteFile(this.table, Files.localOutput((File)this.temp.newFile()), deletes, deleteRowSchema);
        this.table.newRowDelta().addDeletes(posDeletes).commit();
        try (CloseableIterable tasksIterable = this.table.newScan().planFiles();){
            tasks = Lists.newArrayList((Iterable)tasksIterable);
        }
        Assert.assertEquals((String)"Should produce one task", (long)1L, (long)tasks.size());
        FileScanTask task = (FileScanTask)tasks.get(0);
        Assert.assertEquals((String)"Should have delete file, data contains a null value", (long)1L, (long)task.deletes().size());
    }

    @Test
    public void testEqualityDeletePlanningStatsNoNullValuesWithAllNullDeletes() throws IOException {
        ArrayList tasks;
        this.table.newAppend().appendFile(this.dataFileWithoutNulls).commit();
        ArrayList deletes = Lists.newArrayList();
        Schema deleteRowSchema = SCHEMA.select(new String[]{"data"});
        GenericRecord delete = GenericRecord.create((Schema)deleteRowSchema);
        deletes.add(delete.copy("data", null));
        DeleteFile posDeletes = FileHelpers.writeDeleteFile(this.table, Files.localOutput((File)this.temp.newFile()), deletes, deleteRowSchema);
        this.table.newRowDelta().addDeletes(posDeletes).commit();
        try (CloseableIterable tasksIterable = this.table.newScan().planFiles();){
            tasks = Lists.newArrayList((Iterable)tasksIterable);
        }
        Assert.assertEquals((String)"Should produce one task", (long)1L, (long)tasks.size());
        FileScanTask task = (FileScanTask)tasks.get(0);
        Assert.assertEquals((String)"Should have no delete files, data contains no null values", (long)0L, (long)task.deletes().size());
    }

    @Test
    public void testEqualityDeletePlanningStatsAllNullValuesWithNoNullDeletes() throws IOException {
        ArrayList tasks;
        this.table.newAppend().appendFile(this.dataFileOnlyNulls).commit();
        ArrayList deletes = Lists.newArrayList();
        Schema deleteRowSchema = SCHEMA.select(new String[]{"data"});
        GenericRecord delete = GenericRecord.create((Schema)deleteRowSchema);
        deletes.add(delete.copy("data", (Object)"d"));
        DeleteFile posDeletes = FileHelpers.writeDeleteFile(this.table, Files.localOutput((File)this.temp.newFile()), deletes, deleteRowSchema);
        this.table.newRowDelta().addDeletes(posDeletes).commit();
        try (CloseableIterable tasksIterable = this.table.newScan().planFiles();){
            tasks = Lists.newArrayList((Iterable)tasksIterable);
        }
        Assert.assertEquals((String)"Should produce one task", (long)1L, (long)tasks.size());
        FileScanTask task = (FileScanTask)tasks.get(0);
        Assert.assertEquals((String)"Should have no delete files, data contains no null values", (long)0L, (long)task.deletes().size());
    }

    @Test
    public void testEqualityDeletePlanningStatsSomeNullValuesWithSomeNullDeletes() throws IOException {
        ArrayList tasks;
        this.table.newAppend().appendFile(this.dataFile).commit();
        ArrayList deletes = Lists.newArrayList();
        Schema deleteRowSchema = SCHEMA.select(new String[]{"data"});
        GenericRecord delete = GenericRecord.create((Schema)deleteRowSchema);
        deletes.add(delete.copy("data", null));
        deletes.add(delete.copy("data", (Object)"x"));
        DeleteFile posDeletes = FileHelpers.writeDeleteFile(this.table, Files.localOutput((File)this.temp.newFile()), deletes, deleteRowSchema);
        this.table.newRowDelta().addDeletes(posDeletes).commit();
        try (CloseableIterable tasksIterable = this.table.newScan().planFiles();){
            tasks = Lists.newArrayList((Iterable)tasksIterable);
        }
        Assert.assertEquals((String)"Should produce one task", (long)1L, (long)tasks.size());
        FileScanTask task = (FileScanTask)tasks.get(0);
        Assert.assertEquals((String)"Should have one delete file, data and deletes have null values", (long)1L, (long)task.deletes().size());
    }

    @Test
    public void testDifferentDeleteTypes() throws IOException {
        this.table.newAppend().appendFile(this.dataFile).commit();
        DeleteFile globalEqDeleteFile1 = this.writeEqDeletes("id", 7, 8);
        this.table.newRowDelta().addDeletes(globalEqDeleteFile1).commit();
        this.table.updateSpec().addField("category").commit();
        TestHelpers.Row evenPartition = TestHelpers.Row.of((Object[])new Object[]{"even"});
        TestHelpers.Row oddPartition = TestHelpers.Row.of((Object[])new Object[]{"odd"});
        DataFile dataFileWithEvenRecords = this.writeData((StructLike)evenPartition, this.evenRecords);
        DataFile dataFileWithOddRecords = this.writeData((StructLike)oddPartition, this.oddRecords);
        this.table.newFastAppend().appendFile(dataFileWithEvenRecords).appendFile(dataFileWithOddRecords).commit();
        DeleteFile partitionEqDeleteFile1 = this.writeEqDeletes((StructLike)evenPartition, "id", 2);
        DeleteFile partitionEqDeleteFile2 = this.writeEqDeletes((StructLike)evenPartition, "id", 4);
        DeleteFile partitionEqDeleteFile3 = this.writeEqDeletes((StructLike)evenPartition, "id", 25);
        this.table.newRowDelta().addDeletes(partitionEqDeleteFile1).addDeletes(partitionEqDeleteFile2).addDeletes(partitionEqDeleteFile3).commit();
        Pair<DeleteFile, CharSequenceSet> partitionPosDeletes = this.writePosDeletes((StructLike)evenPartition, (List<Pair<CharSequence, Long>>)ImmutableList.of((Object)Pair.of((Object)dataFileWithEvenRecords.path(), (Object)0L), (Object)Pair.of((Object)"some-other-file.parquet", (Object)0L)));
        this.table.newRowDelta().addDeletes((DeleteFile)partitionPosDeletes.first()).validateDataFilesExist((Iterable)partitionPosDeletes.second()).commit();
        Pair<DeleteFile, CharSequenceSet> pathPosDeletes = this.writePosDeletes((StructLike)evenPartition, (List<Pair<CharSequence, Long>>)ImmutableList.of((Object)Pair.of((Object)dataFileWithEvenRecords.path(), (Object)1L), (Object)Pair.of((Object)dataFileWithEvenRecords.path(), (Object)2L)));
        this.table.newRowDelta().addDeletes((DeleteFile)pathPosDeletes.first()).validateDataFilesExist((Iterable)pathPosDeletes.second()).commit();
        this.table.updateSpec().removeField("category").commit();
        DeleteFile globalEqDeleteFile2 = this.writeEqDeletes("id", 20, 21);
        this.table.newRowDelta().addDeletes(globalEqDeleteFile2);
        List<FileScanTask> tasks = this.planTasks();
        Assertions.assertThat(tasks).hasSize(3);
        for (FileScanTask task : tasks) {
            if (this.coversDataFile(task, this.dataFile)) {
                this.assertDeletes(task, globalEqDeleteFile1);
                continue;
            }
            if (this.coversDataFile(task, dataFileWithEvenRecords)) {
                this.assertDeletes(task, partitionEqDeleteFile1, partitionEqDeleteFile2, (DeleteFile)pathPosDeletes.first(), (DeleteFile)partitionPosDeletes.first());
                continue;
            }
            if (this.coversDataFile(task, dataFileWithOddRecords)) {
                Assertions.assertThat((List)task.deletes()).isEmpty();
                continue;
            }
            Assertions.fail((String)("Unexpected task: " + task));
        }
    }

    private boolean coversDataFile(FileScanTask task, DataFile file) {
        return ((DataFile)task.file()).path().toString().equals(file.path().toString());
    }

    private void assertDeletes(FileScanTask task, DeleteFile ... expectedDeleteFiles) {
        CharSequenceSet actualDeletePaths = this.deletePaths(task);
        Assertions.assertThat((int)actualDeletePaths.size()).isEqualTo(expectedDeleteFiles.length);
        for (DeleteFile expectedDeleteFile : expectedDeleteFiles) {
            Assertions.assertThat((boolean)actualDeletePaths.contains((Object)expectedDeleteFile.path())).isTrue();
        }
    }

    private CharSequenceSet deletePaths(FileScanTask task) {
        return CharSequenceSet.of((Iterable)Iterables.transform((Iterable)task.deletes(), ContentFile::path));
    }

    private List<FileScanTask> planTasks() throws IOException {
        try (CloseableIterable tasksIterable = this.table.newScan().planFiles();){
            ArrayList arrayList = Lists.newArrayList((Iterable)tasksIterable);
            return arrayList;
        }
    }

    private DataFile writeData(StructLike partition, List<Record> data) throws IOException {
        return FileHelpers.writeDataFile(this.table, Files.localOutput((File)this.temp.newFile()), partition, data);
    }

    private DeleteFile writeEqDeletes(String col, Object ... values) throws IOException {
        return this.writeEqDeletes(null, col, values);
    }

    private DeleteFile writeEqDeletes(StructLike partition, String col, Object ... values) throws IOException {
        Schema deleteSchema = SCHEMA.select(new String[]{col});
        GenericRecord delete = GenericRecord.create((Schema)deleteSchema);
        ArrayList deletes = Lists.newArrayList();
        for (Object value : values) {
            deletes.add(delete.copy(col, value));
        }
        OutputFile out = Files.localOutput((File)this.temp.newFile());
        return FileHelpers.writeDeleteFile(this.table, out, partition, deletes, deleteSchema);
    }

    private Pair<DeleteFile, CharSequenceSet> writePosDeletes(StructLike partition, List<Pair<CharSequence, Long>> deletes) throws IOException {
        OutputFile out = Files.localOutput((File)this.temp.newFile());
        return FileHelpers.writeDeleteFile(this.table, out, partition, deletes);
    }
}

