/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.data;

import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.util.List;
import org.apache.hadoop.conf.Configuration;
import org.apache.iceberg.AppendFiles;
import org.apache.iceberg.DataFile;
import org.apache.iceberg.DataFiles;
import org.apache.iceberg.FileFormat;
import org.apache.iceberg.Files;
import org.apache.iceberg.PartitionSpec;
import org.apache.iceberg.StructLike;
import org.apache.iceberg.Table;
import org.apache.iceberg.data.GenericAppenderFactory;
import org.apache.iceberg.data.Record;
import org.apache.iceberg.io.FileAppender;
import org.apache.iceberg.relocated.com.google.common.base.Preconditions;
import org.assertj.core.api.Assertions;
import org.junit.rules.TemporaryFolder;

public class GenericAppenderHelper {
    private static final String ORC_CONFIG_PREFIX = "^orc.*";
    private static final String PARQUET_CONFIG_PATTERN = ".*parquet.*";
    private final Table table;
    private final FileFormat fileFormat;
    private final TemporaryFolder tmp;
    private final Path temp;
    private final Configuration conf;

    @Deprecated
    public GenericAppenderHelper(Table table, FileFormat fileFormat, TemporaryFolder tmp, Configuration conf) {
        this.table = table;
        this.fileFormat = fileFormat;
        this.tmp = tmp;
        this.temp = null;
        this.conf = conf;
    }

    public GenericAppenderHelper(Table table, FileFormat fileFormat, Path temp, Configuration conf) {
        this.table = table;
        this.fileFormat = fileFormat;
        this.tmp = null;
        this.temp = temp;
        this.conf = conf;
    }

    public GenericAppenderHelper(Table table, FileFormat fileFormat, TemporaryFolder tmp) {
        this(table, fileFormat, tmp, null);
    }

    public GenericAppenderHelper(Table table, FileFormat fileFormat, Path temp) {
        this(table, fileFormat, temp, null);
    }

    public void appendToTable(String branch, DataFile ... dataFiles) {
        Preconditions.checkNotNull((Object)this.table, (Object)"table not set");
        AppendFiles append = (AppendFiles)this.table.newAppend().toBranch(branch != null ? branch : "main");
        for (DataFile dataFile : dataFiles) {
            append = append.appendFile(dataFile);
        }
        append.commit();
    }

    public void appendToTable(DataFile ... dataFiles) {
        this.appendToTable((String)null, dataFiles);
    }

    public void appendToTable(List<Record> records) throws IOException {
        this.appendToTable(null, null, records);
    }

    public void appendToTable(String branch, List<Record> records) throws IOException {
        this.appendToTable(null, branch, records);
    }

    public void appendToTable(StructLike partition, String branch, List<Record> records) throws IOException {
        this.appendToTable(branch, this.writeFile(partition, records));
    }

    public void appendToTable(StructLike partition, List<Record> records) throws IOException {
        this.appendToTable(this.writeFile(partition, records));
    }

    public DataFile writeFile(List<Record> records) throws IOException {
        Preconditions.checkNotNull((Object)this.table, (Object)"table not set");
        File file = null != this.tmp ? this.tmp.newFile() : File.createTempFile("junit", null, this.temp.toFile());
        Assertions.assertThat((boolean)file.delete()).isTrue();
        return GenericAppenderHelper.appendToLocalFile(this.table, file, this.fileFormat, null, records, this.conf);
    }

    public DataFile writeFile(StructLike partition, List<Record> records) throws IOException {
        Preconditions.checkNotNull((Object)this.table, (Object)"table not set");
        File file = null != this.tmp ? this.tmp.newFile() : File.createTempFile("junit", null, this.temp.toFile());
        Assertions.assertThat((boolean)file.delete()).isTrue();
        return GenericAppenderHelper.appendToLocalFile(this.table, file, this.fileFormat, partition, records, this.conf);
    }

    private static DataFile appendToLocalFile(Table table, File file, FileFormat format, StructLike partition, List<Record> records, Configuration conf) throws IOException {
        FileAppender appender;
        GenericAppenderFactory appenderFactory = new GenericAppenderFactory(table.schema());
        if (FileFormat.ORC.equals((Object)format) && conf != null) {
            appenderFactory.setAll(conf.getValByRegex(ORC_CONFIG_PREFIX));
        }
        if (FileFormat.PARQUET.equals((Object)format) && conf != null) {
            appenderFactory.setAll(conf.getValByRegex(PARQUET_CONFIG_PATTERN));
        }
        try (FileAppender fileAppender = appender = appenderFactory.newAppender(Files.localOutput((File)file), format);){
            fileAppender.addAll(records);
        }
        return DataFiles.builder((PartitionSpec)table.spec()).withRecordCount((long)records.size()).withFileSizeInBytes(file.length()).withPath(Files.localInput((File)file).location()).withMetrics(appender.metrics()).withFormat(format).withPartition(partition).withSplitOffsets(appender.splitOffsets()).build();
    }
}

