/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hugegraph.service.query;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import org.apache.hugegraph.entity.query.GremlinCollection;
import org.apache.hugegraph.exception.InternalException;
import org.apache.hugegraph.mapper.query.GremlinCollectionMapper;
import org.apache.hugegraph.util.SQLUtil;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Isolation;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.StringUtils;

@Service
public class GremlinCollectionService {
    @Autowired
    private GremlinCollectionMapper mapper;

    public IPage<GremlinCollection> list(int connId, String content, Boolean nameOrderAsc, Boolean timeOrderAsc, long current, long pageSize) {
        QueryWrapper query = Wrappers.query();
        Page page = new Page(current, pageSize);
        if (!StringUtils.isEmpty((Object)content)) {
            String value = SQLUtil.escapeLike(content);
            if (nameOrderAsc != null) {
                assert (timeOrderAsc == null);
                ((QueryWrapper)query.eq((Object)"conn_id", (Object)connId)).and(wrapper -> ((QueryWrapper)((QueryWrapper)wrapper.like((Object)"name", (Object)value)).or()).like((Object)"content", (Object)value));
                query.orderBy(true, nameOrderAsc.booleanValue(), (Object[])new String[]{"name"});
                return this.mapper.selectPage((IPage)page, (Wrapper)query);
            }
            if (timeOrderAsc != null) {
                assert (nameOrderAsc == null);
                ((QueryWrapper)query.eq((Object)"conn_id", (Object)connId)).and(wrapper -> ((QueryWrapper)((QueryWrapper)wrapper.like((Object)"name", (Object)value)).or()).like((Object)"content", (Object)value));
                query.orderBy(true, timeOrderAsc.booleanValue(), (Object[])new String[]{"create_time"});
                return this.mapper.selectPage((IPage)page, (Wrapper)query);
            }
            assert (nameOrderAsc == null && timeOrderAsc == null);
            return this.mapper.selectByContentInPage((IPage<GremlinCollection>)page, connId, content);
        }
        if (nameOrderAsc != null) {
            assert (timeOrderAsc == null);
            ((QueryWrapper)query.eq((Object)"conn_id", (Object)connId)).orderBy(true, nameOrderAsc.booleanValue(), (Object[])new String[]{"name"});
            return this.mapper.selectPage((IPage)page, (Wrapper)query);
        }
        boolean isAsc = timeOrderAsc != null && timeOrderAsc != false;
        ((QueryWrapper)query.eq((Object)"conn_id", (Object)connId)).orderBy(true, isAsc, (Object[])new String[]{"create_time"});
        return this.mapper.selectPage((IPage)page, (Wrapper)query);
    }

    public GremlinCollection get(int id) {
        return (GremlinCollection)this.mapper.selectById(Integer.valueOf(id));
    }

    public GremlinCollection getByName(int connId, String name) {
        QueryWrapper query = Wrappers.query();
        query.eq((Object)"conn_id", (Object)connId);
        query.eq((Object)"name", (Object)name);
        return (GremlinCollection)this.mapper.selectOne((Wrapper)query);
    }

    public int count() {
        return this.mapper.selectCount(null);
    }

    @Transactional(isolation=Isolation.READ_COMMITTED)
    public void save(GremlinCollection collection) {
        if (this.mapper.insert(collection) != 1) {
            throw new InternalException("entity.insert.failed", collection);
        }
    }

    @Transactional(isolation=Isolation.READ_COMMITTED)
    public void update(GremlinCollection collection) {
        if (this.mapper.updateById(collection) != 1) {
            throw new InternalException("entity.update.failed", collection);
        }
    }

    @Transactional(isolation=Isolation.READ_COMMITTED)
    public void remove(int id) {
        if (this.mapper.deleteById(Integer.valueOf(id)) != 1) {
            throw new InternalException("entity.delete.failed", id);
        }
    }
}

