/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hugegraph.service.algorithm;

import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import org.apache.hugegraph.driver.HugeClient;
import org.apache.hugegraph.driver.TraverserManager;
import org.apache.hugegraph.entity.algorithm.ShortestPath;
import org.apache.hugegraph.entity.enums.AsyncTaskStatus;
import org.apache.hugegraph.entity.enums.ExecuteStatus;
import org.apache.hugegraph.entity.enums.ExecuteType;
import org.apache.hugegraph.entity.query.ExecuteHistory;
import org.apache.hugegraph.entity.query.GraphView;
import org.apache.hugegraph.entity.query.GremlinResult;
import org.apache.hugegraph.entity.query.JsonView;
import org.apache.hugegraph.entity.query.TableView;
import org.apache.hugegraph.service.HugeClientPoolService;
import org.apache.hugegraph.service.query.ExecuteHistoryService;
import org.apache.hugegraph.structure.graph.Edge;
import org.apache.hugegraph.structure.graph.Path;
import org.apache.hugegraph.structure.graph.Vertex;
import org.apache.hugegraph.util.HubbleUtil;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class OltpAlgoService {
    private static final Logger log = LogManager.getLogger(OltpAlgoService.class);
    @Autowired
    private HugeClientPoolService poolService;
    @Autowired
    private ExecuteHistoryService historyService;

    private HugeClient getClient(int connId) {
        return this.poolService.getOrCreate(connId);
    }

    public GremlinResult shortestPath(int connId, ShortestPath body) {
        HugeClient client = this.getClient(connId);
        TraverserManager traverser = client.traverser();
        Path result = traverser.shortestPath(body.getSource(), body.getTarget(), body.getDirection(), body.getLabel(), body.getMaxDepth(), body.getMaxDegree(), body.getSkipDegree(), body.getCapacity());
        JsonView jsonView = new JsonView();
        jsonView.setData(result.objects());
        Date createTime = HubbleUtil.nowDate();
        TableView tableView = this.buildPathTableView(result);
        GraphView graphView = this.buildPathGraphView(result);
        ExecuteStatus status = ExecuteStatus.SUCCESS;
        ExecuteHistory history = new ExecuteHistory(null, connId, 0L, ExecuteType.ALGORITHM, body.toString(), status, AsyncTaskStatus.UNKNOWN, -1L, createTime);
        this.historyService.save(history);
        return GremlinResult.builder().type(GremlinResult.Type.PATH).jsonView(jsonView).tableView(tableView).graphView(graphView).build();
    }

    private TableView buildPathTableView(Path result) {
        List elements = result.objects();
        ArrayList<Object> paths = new ArrayList<Object>(elements.size());
        ArrayList ids = new ArrayList();
        elements.forEach(element -> {
            if (element instanceof Vertex) {
                ids.add(((Vertex)element).id());
            } else if (element instanceof Edge) {
                ids.add(((Edge)element).id());
            } else {
                ids.add(element);
            }
        });
        paths.add(ImmutableMap.of((Object)"path", ids));
        return new TableView(TableView.PATH_HEADER, paths);
    }

    private GraphView buildPathGraphView(Path result) {
        HashMap<Object, Vertex> vertices = new HashMap<Object, Vertex>();
        HashMap<String, Edge> edges = new HashMap<String, Edge>();
        List elements = result.objects();
        for (Object element : elements) {
            if (element instanceof Vertex) {
                Vertex vertex = (Vertex)element;
                vertices.put(vertex.id(), vertex);
                continue;
            }
            if (element instanceof Edge) {
                Edge edge = (Edge)element;
                edges.put(edge.id(), edge);
                continue;
            }
            return GraphView.EMPTY;
        }
        return new GraphView(vertices.values(), new ArrayList<Edge>());
    }
}

