/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hugegraph.entity.load;

import com.fasterxml.jackson.annotation.JsonProperty;
import org.apache.hugegraph.annotation.MergeProperty;
import org.apache.hugegraph.common.Mergeable;

public class LoadParameter
implements Mergeable {
    @MergeProperty
    @JsonProperty(value="check_vertex")
    private boolean checkVertex = false;
    @MergeProperty
    @JsonProperty(value="insert_timeout")
    private int insertTimeout = 60;
    @MergeProperty
    @JsonProperty(value="max_parse_errors")
    private int maxParseErrors = 1;
    @MergeProperty
    @JsonProperty(value="max_insert_errors")
    private int maxInsertErrors = 500;
    @MergeProperty
    @JsonProperty(value="retry_times")
    private int retryTimes = 3;
    @MergeProperty
    @JsonProperty(value="retry_interval")
    private int retryInterval = 10;

    public static LoadParameterBuilder builder() {
        return new LoadParameterBuilder();
    }

    public boolean isCheckVertex() {
        return this.checkVertex;
    }

    public int getInsertTimeout() {
        return this.insertTimeout;
    }

    public int getMaxParseErrors() {
        return this.maxParseErrors;
    }

    public int getMaxInsertErrors() {
        return this.maxInsertErrors;
    }

    public int getRetryTimes() {
        return this.retryTimes;
    }

    public int getRetryInterval() {
        return this.retryInterval;
    }

    @JsonProperty(value="check_vertex")
    public void setCheckVertex(boolean checkVertex) {
        this.checkVertex = checkVertex;
    }

    @JsonProperty(value="insert_timeout")
    public void setInsertTimeout(int insertTimeout) {
        this.insertTimeout = insertTimeout;
    }

    @JsonProperty(value="max_parse_errors")
    public void setMaxParseErrors(int maxParseErrors) {
        this.maxParseErrors = maxParseErrors;
    }

    @JsonProperty(value="max_insert_errors")
    public void setMaxInsertErrors(int maxInsertErrors) {
        this.maxInsertErrors = maxInsertErrors;
    }

    @JsonProperty(value="retry_times")
    public void setRetryTimes(int retryTimes) {
        this.retryTimes = retryTimes;
    }

    @JsonProperty(value="retry_interval")
    public void setRetryInterval(int retryInterval) {
        this.retryInterval = retryInterval;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof LoadParameter)) {
            return false;
        }
        LoadParameter other = (LoadParameter)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.isCheckVertex() != other.isCheckVertex()) {
            return false;
        }
        if (this.getInsertTimeout() != other.getInsertTimeout()) {
            return false;
        }
        if (this.getMaxParseErrors() != other.getMaxParseErrors()) {
            return false;
        }
        if (this.getMaxInsertErrors() != other.getMaxInsertErrors()) {
            return false;
        }
        if (this.getRetryTimes() != other.getRetryTimes()) {
            return false;
        }
        return this.getRetryInterval() == other.getRetryInterval();
    }

    protected boolean canEqual(Object other) {
        return other instanceof LoadParameter;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isCheckVertex() ? 79 : 97);
        result = result * 59 + this.getInsertTimeout();
        result = result * 59 + this.getMaxParseErrors();
        result = result * 59 + this.getMaxInsertErrors();
        result = result * 59 + this.getRetryTimes();
        result = result * 59 + this.getRetryInterval();
        return result;
    }

    public String toString() {
        return "LoadParameter(checkVertex=" + this.isCheckVertex() + ", insertTimeout=" + this.getInsertTimeout() + ", maxParseErrors=" + this.getMaxParseErrors() + ", maxInsertErrors=" + this.getMaxInsertErrors() + ", retryTimes=" + this.getRetryTimes() + ", retryInterval=" + this.getRetryInterval() + ")";
    }

    public LoadParameter() {
    }

    public LoadParameter(boolean checkVertex, int insertTimeout, int maxParseErrors, int maxInsertErrors, int retryTimes, int retryInterval) {
        this.checkVertex = checkVertex;
        this.insertTimeout = insertTimeout;
        this.maxParseErrors = maxParseErrors;
        this.maxInsertErrors = maxInsertErrors;
        this.retryTimes = retryTimes;
        this.retryInterval = retryInterval;
    }

    public static class LoadParameterBuilder {
        private boolean checkVertex;
        private int insertTimeout;
        private int maxParseErrors;
        private int maxInsertErrors;
        private int retryTimes;
        private int retryInterval;

        LoadParameterBuilder() {
        }

        @JsonProperty(value="check_vertex")
        public LoadParameterBuilder checkVertex(boolean checkVertex) {
            this.checkVertex = checkVertex;
            return this;
        }

        @JsonProperty(value="insert_timeout")
        public LoadParameterBuilder insertTimeout(int insertTimeout) {
            this.insertTimeout = insertTimeout;
            return this;
        }

        @JsonProperty(value="max_parse_errors")
        public LoadParameterBuilder maxParseErrors(int maxParseErrors) {
            this.maxParseErrors = maxParseErrors;
            return this;
        }

        @JsonProperty(value="max_insert_errors")
        public LoadParameterBuilder maxInsertErrors(int maxInsertErrors) {
            this.maxInsertErrors = maxInsertErrors;
            return this;
        }

        @JsonProperty(value="retry_times")
        public LoadParameterBuilder retryTimes(int retryTimes) {
            this.retryTimes = retryTimes;
            return this;
        }

        @JsonProperty(value="retry_interval")
        public LoadParameterBuilder retryInterval(int retryInterval) {
            this.retryInterval = retryInterval;
            return this;
        }

        public LoadParameter build() {
            return new LoadParameter(this.checkVertex, this.insertTimeout, this.maxParseErrors, this.maxInsertErrors, this.retryTimes, this.retryInterval);
        }

        public String toString() {
            return "LoadParameter.LoadParameterBuilder(checkVertex=" + this.checkVertex + ", insertTimeout=" + this.insertTimeout + ", maxParseErrors=" + this.maxParseErrors + ", maxInsertErrors=" + this.maxInsertErrors + ", retryTimes=" + this.retryTimes + ", retryInterval=" + this.retryInterval + ")";
        }
    }
}

