/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.sync.common.metrics;

import com.codahale.metrics.Counter;
import com.codahale.metrics.Timer;
import org.apache.hadoop.conf.Configuration;
import org.apache.hudi.common.util.StringUtils;
import org.apache.hudi.common.util.VisibleForTesting;
import org.apache.hudi.config.metrics.HoodieMetricsConfig;
import org.apache.hudi.hadoop.fs.HadoopFSUtils;
import org.apache.hudi.metrics.Metrics;
import org.apache.hudi.storage.HoodieStorage;
import org.apache.hudi.storage.HoodieStorageUtils;
import org.apache.hudi.storage.StorageConfiguration;
import org.apache.hudi.sync.common.HoodieSyncConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HoodieMetaSyncMetrics {
    private static final Logger LOG = LoggerFactory.getLogger(HoodieMetaSyncMetrics.class);
    private static final String TIMER_ACTION = "timer";
    private static final String COUNTER_ACTION = "counter";
    private static final String META_SYNC_RECREATE_TABLE_METRIC = "meta_sync.recreate_table";
    private static final String META_SYNC_RECREATE_TABLE_FAILURE_METRIC = "meta_sync.recreate_table.failure";
    private static final String META_SYNC_ACTION = "meta_sync";
    private static final String RECREATE_TABLE_DURATION_MS_METRIC = "recreate_table_duration_ms";
    private Metrics metrics;
    private HoodieMetricsConfig metricsConfig;
    private transient HoodieStorage storage;
    private final String syncToolName;
    private static String recreateAndSyncFailureCounterName;
    private static String recreateAndSyncTimerName;
    private Timer recreateAndSyncTimer;
    private Counter recreateAndSyncFailureCounter;

    public HoodieMetaSyncMetrics(HoodieSyncConfig config, String syncToolName) {
        this.metricsConfig = config.getMetricsConfig();
        this.syncToolName = syncToolName;
        if (this.metricsConfig.isMetricsOn()) {
            this.storage = HoodieStorageUtils.getStorage((String)config.getBasePath(), (StorageConfiguration)HadoopFSUtils.getStorageConf((Configuration)config.getHadoopConf()));
            this.metrics = Metrics.getInstance((HoodieMetricsConfig)this.metricsConfig, (HoodieStorage)this.storage);
            recreateAndSyncTimerName = this.getMetricsName(TIMER_ACTION, META_SYNC_RECREATE_TABLE_METRIC);
            recreateAndSyncFailureCounterName = this.getMetricsName(COUNTER_ACTION, META_SYNC_RECREATE_TABLE_FAILURE_METRIC);
        }
    }

    public Metrics getMetrics() {
        return this.metrics;
    }

    public Timer.Context getRecreateAndSyncTimer() {
        if (this.metricsConfig.isMetricsOn() && this.recreateAndSyncTimer == null) {
            this.recreateAndSyncTimer = this.createTimer(recreateAndSyncTimerName);
        }
        return this.recreateAndSyncTimer == null ? null : this.recreateAndSyncTimer.time();
    }

    private Timer createTimer(String name) {
        return this.metricsConfig.isMetricsOn() ? this.metrics.getRegistry().timer(name) : null;
    }

    public void incrementRecreateAndSyncFailureCounter() {
        this.recreateAndSyncFailureCounter = this.getCounter(this.recreateAndSyncFailureCounter, recreateAndSyncFailureCounterName);
        this.recreateAndSyncFailureCounter.inc();
    }

    public void updateRecreateAndSyncDurationInMs(long durationInNs) {
        if (this.metricsConfig.isMetricsOn()) {
            long durationInMs = this.getDurationInMs(durationInNs);
            LOG.info("Sending recreate and sync metrics {}", (Object)durationInMs);
            this.metrics.registerGauge(this.getMetricsName(META_SYNC_ACTION, RECREATE_TABLE_DURATION_MS_METRIC), durationInMs);
        }
    }

    private long getDurationInMs(long ctxDuration) {
        return ctxDuration / 1000000L;
    }

    @VisibleForTesting
    public String getMetricsName(String action, String metric) {
        if (StringUtils.isNullOrEmpty((String)this.metricsConfig.getMetricReporterMetricsNamePrefix())) {
            return String.format("%s.%s.%s", action, metric, this.syncToolName);
        }
        return String.format("%s.%s.%s.%s", this.metricsConfig.getMetricReporterMetricsNamePrefix(), action, metric, this.syncToolName);
    }

    public Counter getCounter(Counter counter, String name) {
        if (counter == null) {
            return this.metrics.getRegistry().counter(name);
        }
        return counter;
    }
}

