/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.catalog;

import java.io.Serializable;
import java.lang.invoke.LambdaMetafactory;
import java.util.Locale;
import java.util.Properties;
import org.apache.hadoop.conf.Configuration;
import org.apache.hudi.AvroConversionUtils$;
import org.apache.hudi.DataSourceOptionsHelper$;
import org.apache.hudi.HoodieWriterUtils$;
import org.apache.hudi.avro.AvroSchemaUtils;
import org.apache.hudi.common.config.DFSPropertiesConfiguration;
import org.apache.hudi.common.config.TypedProperties;
import org.apache.hudi.common.model.HoodieTableType;
import org.apache.hudi.common.table.HoodieTableConfig;
import org.apache.hudi.common.table.HoodieTableMetaClient;
import org.apache.hudi.common.table.timeline.TimelineUtils;
import org.apache.hudi.common.util.StringUtils;
import org.apache.hudi.common.util.ValidationUtils;
import org.apache.hudi.config.HoodieWriteConfig;
import org.apache.hudi.hadoop.fs.HadoopFSUtils;
import org.apache.hudi.keygen.constant.KeyGeneratorOptions;
import org.apache.hudi.keygen.constant.KeyGeneratorType;
import org.apache.hudi.keygen.factory.HoodieSparkKeyGeneratorFactory;
import org.apache.hudi.org.apache.spark.sql.avro.SchemaConverters$;
import org.apache.hudi.storage.HoodieStorageUtils;
import org.apache.hudi.storage.StorageConfiguration;
import org.apache.hudi.util.SparkConfigUtils$;
import org.apache.spark.internal.Logging;
import org.apache.spark.sql.AnalysisException;
import org.apache.spark.sql.AnalysisException$;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.catalyst.TableIdentifier;
import org.apache.spark.sql.catalyst.catalog.CatalogTable;
import org.apache.spark.sql.catalyst.catalog.CatalogTableType;
import org.apache.spark.sql.catalyst.catalog.CatalogTableType$;
import org.apache.spark.sql.catalyst.catalog.HoodieCatalogTable$;
import org.apache.spark.sql.hudi.HoodieOptionConfig$;
import org.apache.spark.sql.hudi.HoodieSqlCommonUtils$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.Metadata;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.sql.types.StructType$;
import org.slf4j.Logger;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.GenTraversableOnce;
import scala.collection.JavaConverters$;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableOnce;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.ArrayOps;
import scala.collection.mutable.Map$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\t\rb\u0001B\u00181\u0001uB\u0001b\u000e\u0001\u0003\u0006\u0004%\tA\u0013\u0005\t\u001f\u0002\u0011\t\u0011)A\u0005\u0017\"A\u0001\u000b\u0001BA\u0002\u0013\u0005\u0011\u000b\u0003\u0005W\u0001\t\u0005\r\u0011\"\u0001X\u0011!i\u0006A!A!B\u0013\u0011\u0006\"\u00020\u0001\t\u0003y\u0006bB2\u0001\u0005\u0004%I\u0001\u001a\u0005\u0007k\u0002\u0001\u000b\u0011B3\t\u000fY\u0004!\u0019!C\u0001o\"9\u0011q\u0001\u0001!\u0002\u0013A\b\"CA\u0005\u0001\t\u0007I\u0011AA\u0006\u0011!\t\u0019\u0002\u0001Q\u0001\n\u00055\u0001\u0002CA\u000b\u0001\t\u0007I\u0011A<\t\u000f\u0005]\u0001\u0001)A\u0005q\"I\u0011\u0011\u0004\u0001C\u0002\u0013\u0005\u00111\u0004\u0005\t\u0003G\u0001\u0001\u0015!\u0003\u0002\u001e!Q\u0011Q\u0005\u0001\t\u0006\u0004%\t!a\n\t\u0015\u0005]\u0002\u0001#b\u0001\n\u0003\tI\u0004C\u0005\u0002B\u0001A)\u0019!C\u0001o\"I\u00111\t\u0001\t\u0006\u0004%\ta\u001e\u0005\u000b\u0003\u000b\u0002\u0001R1A\u0005\u0002\u0005\u001d\u0003\"CA+\u0001!\u0015\r\u0011\"\u0001x\u0011)\t9\u0006\u0001EC\u0002\u0013\u0005\u0011\u0011\f\u0005\u000b\u0003C\u0002\u0001R1A\u0005\u0002\u0005\r\u0004BCA6\u0001!\u0015\r\u0011\"\u0001\u0002Z!Q\u0011Q\u000e\u0001\t\u0006\u0004%\t!a\u0007\t\u0015\u0005=\u0004\u0001#b\u0001\n\u0003\t\t\b\u0003\u0006\u0002\u0000\u0001A)\u0019!C\u0001\u0003cB!\"!!\u0001\u0011\u000b\u0007I\u0011AA9\u0011)\t\u0019\t\u0001EC\u0002\u0013\u0005\u0011\u0011\u000f\u0005\b\u0003\u000b\u0003A\u0011AAD\u0011\u001d\tY\n\u0001C\u0001\u00037Aq!!(\u0001\t\u0003\ty\nC\u0004\u0002\"\u0002!I!a)\t\u000f\u0005-\u0006\u0001\"\u0003\u0002.\"I\u00111\u0018\u0001\u0012\u0002\u0013%\u0011Q\u0018\u0005\n\u0003'\u0004\u0011\u0013!C\u0005\u0003{Cq!!6\u0001\t\u0013\t9\u000eC\u0004\u0002\\\u0002!I!!8\b\u000f\u0005u\b\u0007#\u0001\u0002\u0000\u001a1q\u0006\rE\u0001\u0005\u0003AaAX\u0015\u0005\u0002\t\r\u0001\"\u0003B\u0003S\t\u0007I\u0011\u0001B\u0004\u0011!\u0011y!\u000bQ\u0001\n\t%\u0001b\u0002B\tS\u0011\u0005!1\u0003\u0005\b\u0005#IC\u0011\u0001B\u000e\u0005IAun\u001c3jK\u000e\u000bG/\u00197pOR\u000b'\r\\3\u000b\u0005E\u0012\u0014aB2bi\u0006dwn\u001a\u0006\u0003gQ\n\u0001bY1uC2L8\u000f\u001e\u0006\u0003kY\n1a]9m\u0015\t9\u0004(A\u0003ta\u0006\u00148N\u0003\u0002:u\u00051\u0011\r]1dQ\u0016T\u0011aO\u0001\u0004_J<7\u0001A\n\u0004\u0001y\"\u0005CA C\u001b\u0005\u0001%\"A!\u0002\u000bM\u001c\u0017\r\\1\n\u0005\r\u0003%AB!osJ+g\r\u0005\u0002F\u00116\taI\u0003\u0002Hm\u0005A\u0011N\u001c;fe:\fG.\u0003\u0002J\r\n9Aj\\4hS:<W#A&\u0011\u00051kU\"\u0001\u001b\n\u00059#$\u0001D*qCJ\\7+Z:tS>t\u0017AB:qCJ\\\u0007%A\u0003uC\ndW-F\u0001S!\t\u0019F+D\u00011\u0013\t)\u0006G\u0001\u0007DCR\fGn\\4UC\ndW-A\u0005uC\ndWm\u0018\u0013fcR\u0011\u0001l\u0017\t\u0003\u007feK!A\u0017!\u0003\tUs\u0017\u000e\u001e\u0005\b9\u0012\t\t\u00111\u0001S\u0003\rAH%M\u0001\u0007i\u0006\u0014G.\u001a\u0011\u0002\rqJg.\u001b;?)\r\u0001\u0017M\u0019\t\u0003'\u0002AQa\u000e\u0004A\u0002-CQ\u0001\u0015\u0004A\u0002I\u000b1b\u001d;pe\u0006<WmQ8oMV\tQ\rE\u0002gW6l\u0011a\u001a\u0006\u0003Q&\fqa\u001d;pe\u0006<WM\u0003\u0002kq\u0005!\u0001.\u001e3j\u0013\tawM\u0001\u000bTi>\u0014\u0018mZ3D_:4\u0017nZ;sCRLwN\u001c\t\u0003]Nl\u0011a\u001c\u0006\u0003aF\fAaY8oM*\u0011!\u000fO\u0001\u0007Q\u0006$wn\u001c9\n\u0005Q|'!D\"p]\u001aLw-\u001e:bi&|g.\u0001\u0007ti>\u0014\u0018mZ3D_:4\u0007%\u0001\tdCR\fGn\\4UC\ndWMT1nKV\t\u0001\u0010E\u0002z\u0003\u0003q!A\u001f@\u0011\u0005m\u0004U\"\u0001?\u000b\u0005ud\u0014A\u0002\u001fs_>$h(\u0003\u0002\u0000\u0001\u00061\u0001K]3eK\u001aLA!a\u0001\u0002\u0006\t11\u000b\u001e:j]\u001eT!a !\u0002#\r\fG/\u00197pOR\u000b'\r\\3OC6,\u0007%A\tdCR\fGn\\4Qe>\u0004XM\u001d;jKN,\"!!\u0004\u0011\u000be\fy\u0001\u001f=\n\t\u0005E\u0011Q\u0001\u0002\u0004\u001b\u0006\u0004\u0018AE2bi\u0006dwn\u001a)s_B,'\u000f^5fg\u0002\nQ\u0002^1cY\u0016dunY1uS>t\u0017A\u0004;bE2,Gj\\2bi&|g\u000eI\u0001\u0012Q>|G-[3UC\ndW-\u0012=jgR\u001cXCAA\u000f!\ry\u0014qD\u0005\u0004\u0003C\u0001%a\u0002\"p_2,\u0017M\\\u0001\u0013Q>|G-[3UC\ndW-\u0012=jgR\u001c\b%\u0001\u0006nKR\f7\t\\5f]R,\"!!\u000b\u0011\t\u0005-\u00121G\u0007\u0003\u0003[Q1\u0001UA\u0018\u0015\r\t\t$[\u0001\u0007G>lWn\u001c8\n\t\u0005U\u0012Q\u0006\u0002\u0016\u0011>|G-[3UC\ndW-T3uC\u000ec\u0017.\u001a8u\u0003-!\u0018M\u00197f\u0007>tg-[4\u0016\u0005\u0005m\u0002\u0003BA\u0016\u0003{IA!a\u0010\u0002.\t\t\u0002j\\8eS\u0016$\u0016M\u00197f\u0007>tg-[4\u0002\u0013Q\f'\r\\3OC6,\u0017\u0001\u00043bi\u0006\u0014\u0017m]3OC6,\u0017!\u0003;bE2,G+\u001f9f+\t\tI\u0005\u0005\u0003\u0002L\u0005ESBAA'\u0015\u0011\ty%a\f\u0002\u000b5|G-\u001a7\n\t\u0005M\u0013Q\n\u0002\u0010\u0011>|G-[3UC\ndW\rV=qK\u0006iA/\u00192mKRK\b/\u001a(b[\u0016\f1\u0002\u001d:j[\u0006\u0014\u0018pS3zgV\u0011\u00111\f\t\u0005\u007f\u0005u\u00030C\u0002\u0002`\u0001\u0013Q!\u0011:sCf\fQ\u0002\u001d:f\u0007>l'-\u001b8f\u0017\u0016LXCAA3!\u0011y\u0014q\r=\n\u0007\u0005%\u0004I\u0001\u0004PaRLwN\\\u0001\u0010a\u0006\u0014H/\u001b;j_:4\u0015.\u001a7eg\u0006\u0001\u0013n]'vYRL\u0007\u000f\\3CCN,g)\u001b7f\r>\u0014X.\u0019;t\u000b:\f'\r\\3e\u0003-!\u0018M\u00197f'\u000eDW-\\1\u0016\u0005\u0005M\u0004\u0003BA;\u0003wj!!a\u001e\u000b\u0007\u0005eD'A\u0003usB,7/\u0003\u0003\u0002~\u0005]$AC*ueV\u001cG\u000fV=qK\u0006aB/\u00192mKN\u001b\u0007.Z7b/&$\bn\\;u\u001b\u0016$\u0018MR5fY\u0012\u001c\u0018A\u00033bi\u0006\u001c6\r[3nC\u0006y\u0001/\u0019:uSRLwN\\*dQ\u0016l\u0017-A\thKR\u0004\u0016M\u001d;ji&|g\u000eU1uQN,\"!!#\u0011\u000b\u0005-\u0015Q\u0013=\u000f\t\u00055\u0015\u0011\u0013\b\u0004w\u0006=\u0015\"A!\n\u0007\u0005M\u0005)A\u0004qC\u000e\\\u0017mZ3\n\t\u0005]\u0015\u0011\u0014\u0002\u0004'\u0016\f(bAAJ\u0001\u0006\u0011\u0012n\u001d)beRLG/[8oK\u0012$\u0016M\u00197f\u0003=Ig.\u001b;I_>$\u0017.\u001a+bE2,G#\u0001-\u0002+A\f'o]3TG\",W.Y!oI\u000e{gNZ5hgR\u0011\u0011Q\u0015\t\b\u007f\u0005\u001d\u00161OA\u0007\u0013\r\tI\u000b\u0011\u0002\u0007)V\u0004H.\u001a\u001a\u0002!\u0015DHO]1UC\ndWmQ8oM&<G\u0003CA\u0007\u0003_\u000b\u0019,a.\t\u000f\u0005E6\u00051\u0001\u0002\u001e\u0005YA/\u00192mK\u0016C\u0018n\u001d;t\u0011%\t)l\tI\u0001\u0002\u0004\ti!A\tpe&<\u0017N\u001c+bE2,7i\u001c8gS\u001eD\u0011\"!/$!\u0003\u0005\r!!\u0004\u0002\u0015M\fHn\u00149uS>t7/\u0001\u000efqR\u0014\u0018\rV1cY\u0016\u001cuN\u001c4jO\u0012\"WMZ1vYR$#'\u0006\u0002\u0002@*\"\u0011QBAaW\t\t\u0019\r\u0005\u0003\u0002F\u0006=WBAAd\u0015\u0011\tI-a3\u0002\u0013Ut7\r[3dW\u0016$'bAAg\u0001\u0006Q\u0011M\u001c8pi\u0006$\u0018n\u001c8\n\t\u0005E\u0017q\u0019\u0002\u0012k:\u001c\u0007.Z2lK\u00124\u0016M]5b]\u000e,\u0017AG3yiJ\fG+\u00192mK\u000e{gNZ5hI\u0011,g-Y;mi\u0012\u001a\u0014a\u00077pC\u0012$\u0016M\u00197f'\u000eDW-\\1Cs6+G/Y\"mS\u0016tG\u000f\u0006\u0002\u0002ZB)q(a\u001a\u0002t\u0005\u0001b/\u001a:jMf$\u0015\r^1TG\",W.\u0019\u000b\b1\u0006}\u00171^Az\u0011\u001d\t\to\na\u0001\u0003G\fq\u0002^1cY\u0016LE-\u001a8uS\u001aLWM\u001d\t\u0005\u0003K\f9/D\u00013\u0013\r\tIO\r\u0002\u0010)\u0006\u0014G.Z%eK:$\u0018NZ5fe\"9\u0011QI\u0014A\u0002\u00055\bcA*\u0002p&\u0019\u0011\u0011\u001f\u0019\u0003!\r\u000bG/\u00197pOR\u000b'\r\\3UsB,\u0007bBAAO\u0001\u0007\u0011Q\u001f\t\u0007\u0003\u0017\u000b)*a>\u0011\t\u0005U\u0014\u0011`\u0005\u0005\u0003w\f9HA\u0006TiJ,8\r\u001e$jK2$\u0017A\u0005%p_\u0012LWmQ1uC2|w\rV1cY\u0016\u0004\"aU\u0015\u0014\u0005%rDCAA\u0000\u0003=qW-\u001a3GS2$XM\u001d)s_B\u001cXC\u0001B\u0005!\u0015\tYIa\u0003y\u0013\u0011\u0011i!!'\u0003\t1K7\u000f^\u0001\u0011]\u0016,GMR5mi\u0016\u0014\bK]8qg\u0002\nQ!\u00199qYf$R\u0001\u0019B\u000b\u00053AaAa\u0006.\u0001\u0004Y\u0015\u0001D:qCJ\\7+Z:tS>t\u0007bBAq[\u0001\u0007\u00111\u001d\u000b\u0006A\nu!q\u0004\u0005\u0007\u0005/q\u0003\u0019A&\t\r\t\u0005b\u00061\u0001S\u00031\u0019\u0017\r^1m_\u001e$\u0016M\u00197f\u0001")
public class HoodieCatalogTable
implements Logging {
    private HoodieTableMetaClient metaClient;
    private HoodieTableConfig tableConfig;
    private String tableName;
    private String databaseName;
    private HoodieTableType tableType;
    private String tableTypeName;
    private String[] primaryKeys;
    private Option<String> preCombineKey;
    private String[] partitionFields;
    private boolean isMultipleBaseFileFormatsEnabled;
    private StructType tableSchema;
    private StructType tableSchemaWithoutMetaFields;
    private StructType dataSchema;
    private StructType partitionSchema;
    private final SparkSession spark;
    private CatalogTable table;
    private final StorageConfiguration<Configuration> storageConf;
    private final String catalogTableName;
    private final scala.collection.immutable.Map<String, String> catalogProperties;
    private final String tableLocation;
    private final boolean hoodieTableExists;
    private transient Logger org$apache$spark$internal$Logging$$log_;
    private volatile int bitmap$0;

    public static HoodieCatalogTable apply(SparkSession sparkSession, CatalogTable catalogTable) {
        return HoodieCatalogTable$.MODULE$.apply(sparkSession, catalogTable);
    }

    public static HoodieCatalogTable apply(SparkSession sparkSession, TableIdentifier tableIdentifier) {
        return HoodieCatalogTable$.MODULE$.apply(sparkSession, tableIdentifier);
    }

    public static List<String> needFilterProps() {
        return HoodieCatalogTable$.MODULE$.needFilterProps();
    }

    public String logName() {
        return Logging.logName$((Logging)this);
    }

    public Logger log() {
        return Logging.log$((Logging)this);
    }

    public void logInfo(Function0<String> msg) {
        Logging.logInfo$((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.logDebug$((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg) {
        Logging.logTrace$((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.logWarning$((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.logError$((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter);
    }

    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public boolean initializeLogIfNecessary$default$2() {
        return Logging.initializeLogIfNecessary$default$2$((Logging)this);
    }

    public void initializeForcefully(boolean isInterpreter, boolean silent) {
        Logging.initializeForcefully$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    public SparkSession spark() {
        return this.spark;
    }

    public CatalogTable table() {
        return this.table;
    }

    public void table_$eq(CatalogTable x$1) {
        this.table = x$1;
    }

    private StorageConfiguration<Configuration> storageConf() {
        return this.storageConf;
    }

    public String catalogTableName() {
        return this.catalogTableName;
    }

    public scala.collection.immutable.Map<String, String> catalogProperties() {
        return this.catalogProperties;
    }

    public String tableLocation() {
        return this.tableLocation;
    }

    public boolean hoodieTableExists() {
        return this.hoodieTableExists;
    }

    private HoodieTableMetaClient metaClient$lzycompute() {
        HoodieCatalogTable hoodieCatalogTable = this;
        synchronized (hoodieCatalogTable) {
            if ((this.bitmap$0 & 1) == 0) {
                this.metaClient = HoodieTableMetaClient.builder().setBasePath(this.tableLocation()).setConf(this.storageConf()).build();
                this.bitmap$0 |= 1;
            }
        }
        return this.metaClient;
    }

    public HoodieTableMetaClient metaClient() {
        if ((this.bitmap$0 & 1) == 0) {
            return this.metaClient$lzycompute();
        }
        return this.metaClient;
    }

    private HoodieTableConfig tableConfig$lzycompute() {
        HoodieCatalogTable hoodieCatalogTable = this;
        synchronized (hoodieCatalogTable) {
            if ((this.bitmap$0 & 2) == 0) {
                this.tableConfig = this.metaClient().getTableConfig();
                this.bitmap$0 |= 2;
            }
        }
        return this.tableConfig;
    }

    public HoodieTableConfig tableConfig() {
        if ((this.bitmap$0 & 2) == 0) {
            return this.tableConfig$lzycompute();
        }
        return this.tableConfig;
    }

    private String tableName$lzycompute() {
        HoodieCatalogTable hoodieCatalogTable = this;
        synchronized (hoodieCatalogTable) {
            if ((this.bitmap$0 & 4) == 0) {
                this.tableName = this.tableConfig().getTableName();
                this.bitmap$0 |= 4;
            }
        }
        return this.tableName;
    }

    public String tableName() {
        if ((this.bitmap$0 & 4) == 0) {
            return this.tableName$lzycompute();
        }
        return this.tableName;
    }

    private String databaseName$lzycompute() {
        HoodieCatalogTable hoodieCatalogTable = this;
        synchronized (hoodieCatalogTable) {
            if ((this.bitmap$0 & 8) == 0) {
                this.databaseName = this.tableConfig().getDatabaseName();
                this.bitmap$0 |= 8;
            }
        }
        return this.databaseName;
    }

    public String databaseName() {
        if ((this.bitmap$0 & 8) == 0) {
            return this.databaseName$lzycompute();
        }
        return this.databaseName;
    }

    private HoodieTableType tableType$lzycompute() {
        HoodieCatalogTable hoodieCatalogTable = this;
        synchronized (hoodieCatalogTable) {
            if ((this.bitmap$0 & 0x10) == 0) {
                this.tableType = this.tableConfig().getTableType();
                this.bitmap$0 |= 0x10;
            }
        }
        return this.tableType;
    }

    public HoodieTableType tableType() {
        if ((this.bitmap$0 & 0x10) == 0) {
            return this.tableType$lzycompute();
        }
        return this.tableType;
    }

    private String tableTypeName$lzycompute() {
        HoodieCatalogTable hoodieCatalogTable = this;
        synchronized (hoodieCatalogTable) {
            if ((this.bitmap$0 & 0x20) == 0) {
                this.tableTypeName = this.tableType().name();
                this.bitmap$0 |= 0x20;
            }
        }
        return this.tableTypeName;
    }

    public String tableTypeName() {
        if ((this.bitmap$0 & 0x20) == 0) {
            return this.tableTypeName$lzycompute();
        }
        return this.tableTypeName;
    }

    private String[] primaryKeys$lzycompute() {
        HoodieCatalogTable hoodieCatalogTable = this;
        synchronized (hoodieCatalogTable) {
            if ((this.bitmap$0 & 0x40) == 0) {
                this.primaryKeys = this.tableConfig().getRecordKeyFields().orElse((String[])Array$.MODULE$.empty(ClassTag$.MODULE$.apply(String.class)));
                this.bitmap$0 |= 0x40;
            }
        }
        return this.primaryKeys;
    }

    public String[] primaryKeys() {
        if ((this.bitmap$0 & 0x40) == 0) {
            return this.primaryKeys$lzycompute();
        }
        return this.primaryKeys;
    }

    private Option<String> preCombineKey$lzycompute() {
        HoodieCatalogTable hoodieCatalogTable = this;
        synchronized (hoodieCatalogTable) {
            if ((this.bitmap$0 & 0x80) == 0) {
                this.preCombineKey = Option$.MODULE$.apply((Object)this.tableConfig().getPreCombineField());
                this.bitmap$0 |= 0x80;
            }
        }
        return this.preCombineKey;
    }

    public Option<String> preCombineKey() {
        if ((this.bitmap$0 & 0x80) == 0) {
            return this.preCombineKey$lzycompute();
        }
        return this.preCombineKey;
    }

    private String[] partitionFields$lzycompute() {
        HoodieCatalogTable hoodieCatalogTable = this;
        synchronized (hoodieCatalogTable) {
            if ((this.bitmap$0 & 0x100) == 0) {
                this.partitionFields = this.tableConfig().getPartitionFields().orElse((String[])Array$.MODULE$.empty(ClassTag$.MODULE$.apply(String.class)));
                this.bitmap$0 |= 0x100;
            }
        }
        return this.partitionFields;
    }

    public String[] partitionFields() {
        if ((this.bitmap$0 & 0x100) == 0) {
            return this.partitionFields$lzycompute();
        }
        return this.partitionFields;
    }

    private boolean isMultipleBaseFileFormatsEnabled$lzycompute() {
        HoodieCatalogTable hoodieCatalogTable = this;
        synchronized (hoodieCatalogTable) {
            if ((this.bitmap$0 & 0x200) == 0) {
                this.isMultipleBaseFileFormatsEnabled = this.tableConfig().isMultipleBaseFileFormatsEnabled();
                this.bitmap$0 |= 0x200;
            }
        }
        return this.isMultipleBaseFileFormatsEnabled;
    }

    public boolean isMultipleBaseFileFormatsEnabled() {
        if ((this.bitmap$0 & 0x200) == 0) {
            return this.isMultipleBaseFileFormatsEnabled$lzycompute();
        }
        return this.isMultipleBaseFileFormatsEnabled;
    }

    private StructType tableSchema$lzycompute() {
        HoodieCatalogTable hoodieCatalogTable = this;
        synchronized (hoodieCatalogTable) {
            if ((this.bitmap$0 & 0x400) == 0) {
                StructType structType;
                Option<StructType> schemaFromMetaOpt = this.loadTableSchemaByMetaClient();
                if (schemaFromMetaOpt.nonEmpty()) {
                    structType = (StructType)schemaFromMetaOpt.get();
                } else if (this.table().schema().nonEmpty()) {
                    structType = HoodieSqlCommonUtils$.MODULE$.addMetaFields(this.table().schema());
                } else {
                    throw new AnalysisException(new StringBuilder(33).append(this.catalogTableName()).append(" does not contains schema fields.").toString(), AnalysisException$.MODULE$.$lessinit$greater$default$2(), AnalysisException$.MODULE$.$lessinit$greater$default$3(), AnalysisException$.MODULE$.$lessinit$greater$default$4(), AnalysisException$.MODULE$.$lessinit$greater$default$5(), AnalysisException$.MODULE$.$lessinit$greater$default$6(), AnalysisException$.MODULE$.$lessinit$greater$default$7());
                }
                this.tableSchema = structType;
                this.bitmap$0 |= 0x400;
            }
        }
        return this.tableSchema;
    }

    public StructType tableSchema() {
        if ((this.bitmap$0 & 0x400) == 0) {
            return this.tableSchema$lzycompute();
        }
        return this.tableSchema;
    }

    private StructType tableSchemaWithoutMetaFields$lzycompute() {
        HoodieCatalogTable hoodieCatalogTable = this;
        synchronized (hoodieCatalogTable) {
            if ((this.bitmap$0 & 0x800) == 0) {
                this.tableSchemaWithoutMetaFields = HoodieSqlCommonUtils$.MODULE$.removeMetaFields(this.tableSchema());
                this.bitmap$0 |= 0x800;
            }
        }
        return this.tableSchemaWithoutMetaFields;
    }

    public StructType tableSchemaWithoutMetaFields() {
        if ((this.bitmap$0 & 0x800) == 0) {
            return this.tableSchemaWithoutMetaFields$lzycompute();
        }
        return this.tableSchemaWithoutMetaFields;
    }

    private StructType dataSchema$lzycompute() {
        HoodieCatalogTable hoodieCatalogTable = this;
        synchronized (hoodieCatalogTable) {
            if ((this.bitmap$0 & 0x1000) == 0) {
                this.dataSchema = StructType$.MODULE$.apply((Seq)this.tableSchema().filterNot((Function1 & Serializable & scala.Serializable)f -> BoxesRunTime.boxToBoolean((boolean)HoodieCatalogTable.$anonfun$dataSchema$1(this, f))));
                this.bitmap$0 |= 0x1000;
            }
        }
        return this.dataSchema;
    }

    public StructType dataSchema() {
        if ((this.bitmap$0 & 0x1000) == 0) {
            return this.dataSchema$lzycompute();
        }
        return this.dataSchema;
    }

    private StructType partitionSchema$lzycompute() {
        HoodieCatalogTable hoodieCatalogTable = this;
        synchronized (hoodieCatalogTable) {
            if ((this.bitmap$0 & 0x2000) == 0) {
                this.partitionSchema = StructType$.MODULE$.apply((Seq)this.tableSchema().filter((Function1 & Serializable & scala.Serializable)f -> BoxesRunTime.boxToBoolean((boolean)HoodieCatalogTable.$anonfun$partitionSchema$1(this, f))));
                this.bitmap$0 |= 0x2000;
            }
        }
        return this.partitionSchema;
    }

    public StructType partitionSchema() {
        if ((this.bitmap$0 & 0x2000) == 0) {
            return this.partitionSchema$lzycompute();
        }
        return this.partitionSchema;
    }

    public Seq<String> getPartitionPaths() {
        java.util.List<String> droppedPartitions = TimelineUtils.getDroppedPartitions(this.metaClient(), org.apache.hudi.common.util.Option.empty(), org.apache.hudi.common.util.Option.empty());
        return (Seq)HoodieSqlCommonUtils$.MODULE$.getAllPartitionPaths(this.spark(), this.table(), this.metaClient().getStorage()).filter((Function1 & Serializable & scala.Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)HoodieCatalogTable.$anonfun$getPartitionPaths$1(droppedPartitions, x$2)));
    }

    public boolean isPartitionedTable() {
        return this.table().partitionColumnNames().nonEmpty();
    }

    /*
     * Unable to fully structure code
     */
    public void initHoodieTable() {
        block4: {
            this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)LambdaMetafactory.altMetafactory(null, null, null, ()Ljava/lang/Object;, $anonfun$initHoodieTable$1(org.apache.spark.sql.catalyst.catalog.HoodieCatalogTable ), ()Ljava/lang/String;)((HoodieCatalogTable)this));
            var4_1 = this.parseSchemaAndConfigs();
            if (var4_1 == null) {
                throw new MatchError(var4_1);
            }
            finalSchema = (StructType)var4_1._1();
            tableConfigs = (scala.collection.immutable.Map)var4_1._2();
            var3_4 = new Tuple2((Object)finalSchema, (Object)tableConfigs);
            finalSchema = (StructType)var3_4._1();
            tableConfigs = (scala.collection.immutable.Map)var3_4._2();
            dataSchema = HoodieSqlCommonUtils$.MODULE$.removeMetaFields(finalSchema);
            qual$1 = this.table();
            x$1 = finalSchema;
            x$2 = qual$1.copy$default$1();
            x$3 = qual$1.copy$default$2();
            x$4 = qual$1.copy$default$3();
            x$5 = qual$1.copy$default$5();
            x$6 = qual$1.copy$default$6();
            x$7 = qual$1.copy$default$7();
            x$8 = qual$1.copy$default$8();
            x$9 = qual$1.copy$default$9();
            x$10 = qual$1.copy$default$10();
            x$11 = qual$1.copy$default$11();
            x$12 = qual$1.copy$default$12();
            x$13 = qual$1.copy$default$13();
            x$14 = qual$1.copy$default$14();
            x$15 = qual$1.copy$default$15();
            x$16 = qual$1.copy$default$16();
            x$17 = qual$1.copy$default$17();
            x$18 = qual$1.copy$default$18();
            x$19 = qual$1.copy$default$19();
            x$20 = qual$1.copy$default$20();
            this.table_$eq(qual$1.copy(x$2, x$3, x$4, x$1, x$5, x$6, x$7, x$8, x$9, x$10, x$11, x$12, x$13, x$14, x$15, x$16, x$17, x$18, x$19, x$20));
            properties = TypedProperties.fromMap((java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)tableConfigs).asJava());
            catalogDatabaseName = HoodieSqlCommonUtils$.MODULE$.formatName(this.spark(), (String)this.table().identifier().database().getOrElse((Function0)(Function0 & Serializable & scala.Serializable)LambdaMetafactory.altMetafactory(null, null, null, ()Ljava/lang/Object;, $anonfun$initHoodieTable$2(org.apache.spark.sql.catalyst.catalog.HoodieCatalogTable ), ()Ljava/lang/String;)((HoodieCatalogTable)this)));
            if (!this.hoodieTableExists()) break block4;
            if (StringUtils.isNullOrEmpty(this.databaseName())) ** GOTO lbl-1000
            v0 = this.databaseName();
            var35_31 = catalogDatabaseName;
            if (!(v0 != null ? v0.equals(var35_31) == false : var35_31 != null)) lbl-1000:
            // 2 sources

            {
                v1 = true;
            } else {
                v1 = false;
            }
            ValidationUtils.checkArgument(v1, "The database names from this hoodie path and this catalog table is not same.");
            recordName = AvroSchemaUtils.getAvroRecordQualifiedName(this.table().identifier().table());
            x$21 = dataSchema;
            x$22 = recordName;
            x$23 = SchemaConverters$.MODULE$.toAvroType$default$2();
            x$24 = SchemaConverters$.MODULE$.toAvroType$default$4();
            HoodieTableMetaClient.newTableBuilder().fromProperties(properties).setDatabaseName(catalogDatabaseName).setTableCreateSchema(SchemaConverters$.MODULE$.toAvroType((DataType)x$21, x$23, x$22, x$24).toString()).initTable(this.storageConf(), this.tableLocation());
            return;
        }
        var42_37 = AvroConversionUtils$.MODULE$.getAvroRecordNameAndNamespace(this.table().identifier().table());
        if (var42_37 == null) {
            throw new MatchError(var42_37);
        }
        recordName = (String)var42_37._1();
        namespace = (String)var42_37._2();
        var41_40 = new Tuple2((Object)recordName, (Object)namespace);
        recordName = (String)var41_40._1();
        namespace = (String)var41_40._2();
        schema = SchemaConverters$.MODULE$.toAvroType((DataType)dataSchema, false, recordName, namespace);
        partitionColumns = SparkConfigUtils$.MODULE$.containsConfigProperty((scala.collection.immutable.Map<String, String>)tableConfigs, KeyGeneratorOptions.PARTITIONPATH_FIELD_NAME) != false ? SparkConfigUtils$.MODULE$.getStringWithAltKeys((Map<String, String>)tableConfigs, KeyGeneratorOptions.PARTITIONPATH_FIELD_NAME) : (this.table().partitionColumnNames().isEmpty() != false ? null : this.table().partitionColumnNames().mkString(","));
        HoodieTableMetaClient.newTableBuilder().fromProperties(properties).setTableVersion(Predef$.MODULE$.Integer2int(Integer.valueOf(SparkConfigUtils$.MODULE$.getStringWithAltKeys((Map<String, String>)tableConfigs, HoodieWriteConfig.WRITE_TABLE_VERSION)))).setDatabaseName(catalogDatabaseName).setTableName(this.table().identifier().table()).setTableCreateSchema(schema.toString()).setPartitionFields(partitionColumns).initTable(this.storageConf(), this.tableLocation());
    }

    /*
     * Unable to fully structure code
     */
    private Tuple2<StructType, scala.collection.immutable.Map<String, String>> parseSchemaAndConfigs() {
        globalProps = ((TraversableOnce)JavaConverters$.MODULE$.propertiesAsScalaMapConverter((Properties)DFSPropertiesConfiguration.getGlobalProps()).asScala()).toMap(Predef$.MODULE$.$conforms());
        globalTableConfigs = HoodieWriterUtils$.MODULE$.mappingSparkDatasourceConfigsToTableConfigs((scala.collection.immutable.Map<String, String>)globalProps);
        globalSqlOptions = HoodieOptionConfig$.MODULE$.mapHoodieConfigsToSqlOptions(globalTableConfigs);
        sqlOptions = HoodieOptionConfig$.MODULE$.withDefaultSqlOptions((scala.collection.immutable.Map<String, String>)globalSqlOptions.$plus$plus(HoodieOptionConfig$.MODULE$.mapHoodieConfigsToSqlOptions(this.catalogProperties())));
        var9_5 = new Tuple2((Object)this.table().tableType(), (Object)BoxesRunTime.boxToBoolean((boolean)this.hoodieTableExists()));
        if (var9_5 == null) ** GOTO lbl-1000
        var10_6 = (CatalogTableType)var9_5._1();
        var11_7 = var9_5._2$mcZ$sp();
        v0 = CatalogTableType$.MODULE$.EXTERNAL();
        var12_8 = var10_6;
        if (!(v0 != null ? v0.equals(var12_8) == false : var12_8 != null) && var11_7) {
            existingTableConfig = ((TraversableOnce)JavaConverters$.MODULE$.propertiesAsScalaMapConverter((Properties)this.tableConfig().getProps()).asScala()).toMap(Predef$.MODULE$.$conforms());
            currentTableConfig = globalTableConfigs.$plus$plus((GenTraversableOnce)existingTableConfig);
            catalogTableProps = HoodieOptionConfig$.MODULE$.mapSqlOptionsToTableConfigs(this.catalogProperties());
            HoodieWriterUtils$.MODULE$.validateTableConfig(this.spark(), catalogTableProps, HoodieWriterUtils$.MODULE$.convertMapToHoodieConfig((scala.collection.immutable.Map<String, String>)existingTableConfig));
            options = this.extraTableConfig(this.hoodieTableExists(), (scala.collection.immutable.Map<String, String>)currentTableConfig, this.extraTableConfig$default$3()).$plus$plus(HoodieOptionConfig$.MODULE$.mapSqlOptionsToTableConfigs(sqlOptions)).$plus$plus((GenTraversableOnce)currentTableConfig);
            v1 = new Tuple2((Object)this.tableSchema(), (Object)options);
        } else if (var9_5 != null && !(var17_13 = var9_5._2$mcZ$sp())) {
            ValidationUtils.checkArgument(this.table().schema().nonEmpty(), new StringBuilder(33).append("Missing schema for Create Table: ").append(this.catalogTableName()).toString());
            schema = this.table().schema();
            options = this.extraTableConfig(false, globalTableConfigs, sqlOptions).$plus$plus(HoodieOptionConfig$.MODULE$.mapSqlOptionsToTableConfigs(sqlOptions));
            v1 = new Tuple2((Object)HoodieSqlCommonUtils$.MODULE$.addMetaFields(schema), (Object)options);
        } else {
            if (var9_5 != null) {
                var20_16 = (CatalogTableType)var9_5._1();
                var21_17 = var9_5._2$mcZ$sp();
                v2 = CatalogTableType$.MODULE$.MANAGED();
                var22_18 = var20_16;
                if (!(v2 != null ? v2.equals(var22_18) == false : var22_18 != null) && var21_17) {
                    throw new AnalysisException(new StringBuilder(81).append("Can not create the managed table('").append(this.catalogTableName()).append("')").append(". The associated location('").append(this.tableLocation()).append("') already exists.").toString(), AnalysisException$.MODULE$.$lessinit$greater$default$2(), AnalysisException$.MODULE$.$lessinit$greater$default$3(), AnalysisException$.MODULE$.$lessinit$greater$default$4(), AnalysisException$.MODULE$.$lessinit$greater$default$5(), AnalysisException$.MODULE$.$lessinit$greater$default$6(), AnalysisException$.MODULE$.$lessinit$greater$default$7());
                }
            }
            throw new MatchError((Object)var9_5);
        }
        var8_19 = v1;
        if (var8_19 == null) {
            throw new MatchError((Object)var8_19);
        }
        finalSchema = (StructType)var8_19._1();
        tableConfigs = (scala.collection.immutable.Map)var8_19._2();
        var7_22 = new Tuple2((Object)finalSchema, (Object)tableConfigs);
        finalSchema = (StructType)var7_22._1();
        tableConfigs = (scala.collection.immutable.Map)var7_22._2();
        HoodieOptionConfig$.MODULE$.validateTable(this.spark(), finalSchema, HoodieOptionConfig$.MODULE$.mapHoodieConfigsToSqlOptions((scala.collection.immutable.Map<String, String>)tableConfigs));
        resolver = this.spark().sessionState().conf().resolver();
        dataSchema = (Seq)finalSchema.filterNot((Function1)(Function1 & Serializable & scala.Serializable)LambdaMetafactory.altMetafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, $anonfun$parseSchemaAndConfigs$1$adapted(org.apache.spark.sql.catalyst.catalog.HoodieCatalogTable scala.Function2 org.apache.spark.sql.types.StructField ), (Lorg/apache/spark/sql/types/StructField;)Ljava/lang/Object;)((HoodieCatalogTable)this, (Function2)resolver));
        this.verifyDataSchema(this.table().identifier(), this.table().tableType(), (Seq<StructField>)dataSchema);
        return new Tuple2((Object)finalSchema, (Object)tableConfigs);
    }

    private scala.collection.immutable.Map<String, String> extraTableConfig(boolean tableExists, scala.collection.immutable.Map<String, String> originTableConfig, scala.collection.immutable.Map<String, String> sqlOptions) {
        scala.collection.mutable.Map extraConfig = Map$.MODULE$.empty();
        if (tableExists) {
            Seq<String> allPartitionPaths = this.getPartitionPaths();
            if (originTableConfig.contains((Object)HoodieTableConfig.HIVE_STYLE_PARTITIONING_ENABLE.key())) {
                extraConfig.update((Object)HoodieTableConfig.HIVE_STYLE_PARTITIONING_ENABLE.key(), originTableConfig.apply((Object)HoodieTableConfig.HIVE_STYLE_PARTITIONING_ENABLE.key()));
            } else {
                extraConfig.update((Object)HoodieTableConfig.HIVE_STYLE_PARTITIONING_ENABLE.key(), (Object)String.valueOf(HoodieSqlCommonUtils$.MODULE$.isHiveStyledPartitioning(allPartitionPaths, this.table())));
            }
            if (originTableConfig.contains((Object)HoodieTableConfig.URL_ENCODE_PARTITIONING.key())) {
                extraConfig.update((Object)HoodieTableConfig.URL_ENCODE_PARTITIONING.key(), originTableConfig.apply((Object)HoodieTableConfig.URL_ENCODE_PARTITIONING.key()));
            } else {
                extraConfig.update((Object)HoodieTableConfig.URL_ENCODE_PARTITIONING.key(), (Object)String.valueOf(HoodieSqlCommonUtils$.MODULE$.isUrlEncodeEnabled(allPartitionPaths, this.table())));
            }
        } else {
            extraConfig.update((Object)HoodieTableConfig.HIVE_STYLE_PARTITIONING_ENABLE.key(), (Object)"true");
            extraConfig.update((Object)HoodieTableConfig.URL_ENCODE_PARTITIONING.key(), (Object)HoodieTableConfig.URL_ENCODE_PARTITIONING.defaultValue());
        }
        if (originTableConfig.contains((Object)HoodieTableConfig.KEY_GENERATOR_CLASS_NAME.key())) {
            extraConfig.update((Object)HoodieTableConfig.KEY_GENERATOR_CLASS_NAME.key(), (Object)HoodieSparkKeyGeneratorFactory.convertToSparkKeyGenerator((String)originTableConfig.apply((Object)HoodieTableConfig.KEY_GENERATOR_CLASS_NAME.key())));
        } else if (originTableConfig.contains((Object)HoodieTableConfig.KEY_GENERATOR_TYPE.key())) {
            extraConfig.update((Object)HoodieTableConfig.KEY_GENERATOR_CLASS_NAME.key(), (Object)HoodieSparkKeyGeneratorFactory.convertToSparkKeyGenerator(KeyGeneratorType.valueOf((String)originTableConfig.apply((Object)HoodieTableConfig.KEY_GENERATOR_TYPE.key())).getClassName()));
        } else {
            String primaryKeys = this.table().properties().getOrElse((Object)HoodieOptionConfig$.MODULE$.SQL_KEY_TABLE_PRIMARY_KEY().sqlKeyName(), (Function0 & Serializable & scala.Serializable)() -> this.table().storage().properties().get((Object)HoodieOptionConfig$.MODULE$.SQL_KEY_TABLE_PRIMARY_KEY().sqlKeyName())).toString();
            Option partitionFieldsOpt = Option$.MODULE$.apply((Object)SparkConfigUtils$.MODULE$.getStringWithAltKeys((Map<String, String>)originTableConfig, HoodieTableConfig.PARTITION_FIELDS)).orElse((Function0 & Serializable & scala.Serializable)() -> sqlOptions.get((Object)KeyGeneratorOptions.PARTITIONPATH_FIELD_NAME.key()));
            String partitions = (String)partitionFieldsOpt.getOrElse((Function0 & Serializable & scala.Serializable)() -> this.table().partitionColumnNames().mkString(","));
            extraConfig.update((Object)HoodieTableConfig.KEY_GENERATOR_CLASS_NAME.key(), (Object)DataSourceOptionsHelper$.MODULE$.inferKeyGenClazz(primaryKeys, partitions));
        }
        return extraConfig.toMap(Predef$.MODULE$.$conforms());
    }

    private scala.collection.immutable.Map<String, String> extraTableConfig$default$2() {
        return Predef$.MODULE$.Map().empty();
    }

    private scala.collection.immutable.Map<String, String> extraTableConfig$default$3() {
        return Predef$.MODULE$.Map().empty();
    }

    private Option<StructType> loadTableSchemaByMetaClient() {
        None$ none$;
        Function2 resolver2 = this.spark().sessionState().conf().resolver();
        try {
            none$ = HoodieSqlCommonUtils$.MODULE$.getTableSqlSchema(this.metaClient(), true).map((Function1 & Serializable & scala.Serializable)originSchema -> {
                Tuple2 tuple2 = new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])originSchema.fields())).map((Function1 & Serializable & scala.Serializable)f -> {
                    boolean x$1 = true;
                    String x$2 = f.copy$default$1();
                    DataType x$3 = f.copy$default$2();
                    Metadata x$4 = f.copy$default$4();
                    StructField nullableField = f.copy(x$2, x$3, x$1, x$4);
                    Option<StructField> catalogField = HoodieSqlCommonUtils$.MODULE$.findColumnByName(this.table().schema(), nullableField.name(), (Function2<String, String, Object>)resolver2);
                    if (catalogField.isDefined()) {
                        return (StructField)((StructField)catalogField.get()).getComment().map((Function1 & Serializable & scala.Serializable)comment -> nullableField.withComment(comment)).getOrElse((Function0 & Serializable & scala.Serializable)() -> nullableField);
                    }
                    return nullableField;
                }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(StructField.class))))).partition((Function1 & Serializable & scala.Serializable)f -> BoxesRunTime.boxToBoolean((boolean)HoodieCatalogTable.$anonfun$loadTableSchemaByMetaClient$5(this, f)));
                if (tuple2 == null) {
                    throw new MatchError((Object)tuple2);
                }
                StructField[] partFields = (StructField[])tuple2._1();
                StructField[] dataFields = (StructField[])tuple2._2();
                Tuple2 tuple22 = new Tuple2((Object)partFields, (Object)dataFields);
                StructField[] partFields2 = (StructField[])tuple22._1();
                StructField[] dataFields2 = (StructField[])tuple22._2();
                scala.collection.immutable.Map nameToField = new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])partFields2)).map((Function1 & Serializable & scala.Serializable)field -> new Tuple2((Object)field.name(), field), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tuple2.class))))).toMap(Predef$.MODULE$.$conforms());
                Seq orderedPartFields = new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])this.partitionFields())).map((Function1 & Serializable & scala.Serializable)x$8 -> (StructField)nameToField.apply(x$8), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(StructField.class))))).toSeq();
                return new StructType((StructField[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])dataFields2)).$plus$plus((GenTraversableOnce)orderedPartFields, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(StructField.class))));
            });
        }
        catch (Throwable cause) {
            this.logWarning((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Failed to load table schema from meta client.", cause);
            none$ = None$.MODULE$;
        }
        return none$;
    }

    private void verifyDataSchema(TableIdentifier tableIdentifier, CatalogTableType tableType, Seq<StructField> dataSchema) {
        CatalogTableType catalogTableType = tableType;
        CatalogTableType catalogTableType2 = CatalogTableType$.MODULE$.VIEW();
        if (catalogTableType == null ? catalogTableType2 != null : !catalogTableType.equals(catalogTableType2)) {
            Seq invalidChars = (Seq)new .colon.colon((Object)",", (List)new .colon.colon((Object)":", (List)new .colon.colon((Object)";", (List)Nil$.MODULE$)));
            dataSchema.foreach((Function1 & Serializable & scala.Serializable)f -> {
                HoodieCatalogTable.$anonfun$verifyDataSchema$4(tableIdentifier, invalidChars, f);
                return BoxedUnit.UNIT;
            });
            return;
        }
    }

    public static final /* synthetic */ boolean $anonfun$dataSchema$1(HoodieCatalogTable $this, StructField f) {
        return new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])$this.partitionFields())).contains((Object)f.name());
    }

    public static final /* synthetic */ boolean $anonfun$partitionSchema$1(HoodieCatalogTable $this, StructField f) {
        return new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])$this.partitionFields())).contains((Object)f.name());
    }

    public static final /* synthetic */ boolean $anonfun$getPartitionPaths$1(java.util.List droppedPartitions$1, String x$2) {
        return !droppedPartitions$1.contains(x$2);
    }

    public static final /* synthetic */ String $anonfun$initHoodieTable$1(HoodieCatalogTable $this) {
        return new StringBuilder(27).append("Init hoodie.properties for ").append($this.table().identifier().unquotedString()).toString();
    }

    public static final /* synthetic */ String $anonfun$initHoodieTable$2(HoodieCatalogTable $this) {
        return $this.spark().sessionState().catalog().getCurrentDatabase();
    }

    public static final /* synthetic */ boolean $anonfun$parseSchemaAndConfigs$2(Function2 resolver$1, StructField f$1, String x$6) {
        return BoxesRunTime.unboxToBoolean((Object)resolver$1.apply((Object)x$6, (Object)f$1.name()));
    }

    public static final /* synthetic */ boolean $anonfun$parseSchemaAndConfigs$1(HoodieCatalogTable $this, Function2 resolver$1, StructField f) {
        return $this.table().partitionColumnNames().exists((Function1 & Serializable & scala.Serializable)x$6 -> BoxesRunTime.boxToBoolean((boolean)HoodieCatalogTable.$anonfun$parseSchemaAndConfigs$2(resolver$1, f, x$6)));
    }

    public static final /* synthetic */ boolean $anonfun$loadTableSchemaByMetaClient$5(HoodieCatalogTable $this, StructField f) {
        return new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])$this.partitionFields())).contains((Object)f.name());
    }

    public static final /* synthetic */ boolean $anonfun$verifyDataSchema$2(StructField f$2, CharSequence x$1) {
        return f$2.name().contains(x$1);
    }

    public static final /* synthetic */ void $anonfun$verifyDataSchema$1(Seq invalidChars$1, TableIdentifier tableIdentifier$1, StructField f) {
        DataType dataType = f.dataType();
        if (dataType instanceof StructType) {
            StructType structType = (StructType)dataType;
            HoodieCatalogTable.verifyNestedColumnNames$1(structType, invalidChars$1, tableIdentifier$1);
            return;
        }
        if (invalidChars$1.exists((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)HoodieCatalogTable.$anonfun$verifyDataSchema$2(f, x$1)))) {
            String invalidCharsString = ((TraversableOnce)invalidChars$1.map((Function1 & Serializable & scala.Serializable)c -> new StringBuilder(2).append("'").append((String)c).append("'").toString(), Seq$.MODULE$.canBuildFrom())).mkString(", ");
            String errMsg = new StringBuilder(123).append("Cannot create a table having a nested column whose name contains ").append("invalid characters (").append(invalidCharsString).append(") in Hive metastore. Table: ").append(tableIdentifier$1).append("; ").append("Column: ").append(f.name()).toString();
            throw new AnalysisException(errMsg, AnalysisException$.MODULE$.$lessinit$greater$default$2(), AnalysisException$.MODULE$.$lessinit$greater$default$3(), AnalysisException$.MODULE$.$lessinit$greater$default$4(), AnalysisException$.MODULE$.$lessinit$greater$default$5(), AnalysisException$.MODULE$.$lessinit$greater$default$6(), AnalysisException$.MODULE$.$lessinit$greater$default$7());
        }
    }

    private static final void verifyNestedColumnNames$1(StructType schema, Seq invalidChars$1, TableIdentifier tableIdentifier$1) {
        schema.foreach((Function1 & Serializable & scala.Serializable)f -> {
            HoodieCatalogTable.$anonfun$verifyDataSchema$1(invalidChars$1, tableIdentifier$1, f);
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ void $anonfun$verifyDataSchema$4(TableIdentifier tableIdentifier$1, Seq invalidChars$1, StructField f) {
        DataType dataType = f.dataType();
        if (f.name().contains(",")) {
            throw new AnalysisException(new StringBuilder(101).append("Cannot create a table having a column whose name ").append("contains commas in Hive metastore. Table: ").append(tableIdentifier$1).append("; Column: ").append(f.name()).toString(), AnalysisException$.MODULE$.$lessinit$greater$default$2(), AnalysisException$.MODULE$.$lessinit$greater$default$3(), AnalysisException$.MODULE$.$lessinit$greater$default$4(), AnalysisException$.MODULE$.$lessinit$greater$default$5(), AnalysisException$.MODULE$.$lessinit$greater$default$6(), AnalysisException$.MODULE$.$lessinit$greater$default$7());
        }
        if (dataType instanceof StructType) {
            StructType structType = (StructType)dataType;
            HoodieCatalogTable.verifyNestedColumnNames$1(structType, invalidChars$1, tableIdentifier$1);
            return;
        }
    }

    public HoodieCatalogTable(SparkSession spark, CatalogTable table) {
        this.spark = spark;
        this.table = table;
        Logging.$init$((Logging)this);
        Object object = this.table().provider().map((Function1 & Serializable & scala.Serializable)x$1 -> x$1.toLowerCase(Locale.ROOT)).orNull(Predef$.MODULE$.$conforms());
        String string = "hudi";
        ValidationUtils.checkArgument(!(object != null ? !object.equals(string) : string != null), new StringBuilder(21).append(" ").append(this.table().qualifiedName()).append(" is not a Hudi table").toString());
        this.storageConf = HadoopFSUtils.getStorageConfWithCopy(spark.sessionState().newHadoopConf());
        this.catalogTableName = this.table().qualifiedName();
        this.catalogProperties = HoodieOptionConfig$.MODULE$.makeOptionsCaseInsensitive((scala.collection.immutable.Map<String, String>)this.table().storage().properties().$plus$plus((GenTraversableOnce)this.table().properties()));
        this.tableLocation = HoodieSqlCommonUtils$.MODULE$.getTableLocation(this.table(), spark);
        this.hoodieTableExists = HoodieSqlCommonUtils$.MODULE$.tableExistsInPath(this.tableLocation(), HoodieStorageUtils.getStorage(this.tableLocation(), this.storageConf()));
    }

    public static final /* synthetic */ Object $anonfun$parseSchemaAndConfigs$1$adapted(HoodieCatalogTable $this, Function2 resolver$1, StructField f) {
        return BoxesRunTime.boxToBoolean((boolean)HoodieCatalogTable.$anonfun$parseSchemaAndConfigs$1($this, resolver$1, f));
    }
}

