/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.timeline.service.handlers;

import java.io.IOException;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicLong;
import java.util.stream.Collectors;
import org.apache.hudi.common.table.timeline.dto.InstantStateDTO;
import org.apache.hudi.common.table.view.FileSystemViewManager;
import org.apache.hudi.exception.HoodieIOException;
import org.apache.hudi.storage.HoodieStorage;
import org.apache.hudi.storage.StorageConfiguration;
import org.apache.hudi.storage.StoragePath;
import org.apache.hudi.timeline.service.TimelineService;
import org.apache.hudi.timeline.service.handlers.Handler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InstantStateHandler
extends Handler {
    private static final Logger LOG = LoggerFactory.getLogger(InstantStateHandler.class);
    private static final String BASE_URL = "/v1/hoodie/instantstate";
    public static final String INSTANT_STATE_DIR_PATH_PARAM = "instantstatedirpath";
    public static final String ALL_INSTANT_STATE_URL = String.format("%s/%s", "/v1/hoodie/instantstate", "all");
    public static final String REFRESH_INSTANT_STATE = String.format("%s/%s", "/v1/hoodie/instantstate", "refresh/");
    private final ConcurrentHashMap<String, List<InstantStateDTO>> cachedInstantStates = new ConcurrentHashMap();
    private final AtomicLong requestCount = new AtomicLong();

    public InstantStateHandler(StorageConfiguration<?> conf, TimelineService.Config timelineServiceConfig, HoodieStorage storage, FileSystemViewManager viewManager) throws IOException {
        super(conf, timelineServiceConfig, storage, viewManager);
    }

    public List<InstantStateDTO> getAllInstantStates(String instantStatePath) {
        if (this.requestCount.incrementAndGet() >= (long)this.timelineServiceConfig.instantStateForceRefreshRequestNumber.intValue()) {
            this.refresh(instantStatePath);
        }
        return this.cachedInstantStates.computeIfAbsent(instantStatePath, k -> this.scanInstantState(new StoragePath((String)k)));
    }

    public boolean refresh(String instantStatePath) {
        try {
            this.cachedInstantStates.put(instantStatePath, this.scanInstantState(new StoragePath(instantStatePath)));
            this.requestCount.set(0L);
        }
        catch (Exception e) {
            LOG.error("Failed to load instant states, path: " + instantStatePath, (Throwable)e);
            return false;
        }
        return true;
    }

    public List<InstantStateDTO> scanInstantState(StoragePath instantStatePath) {
        try {
            if (this.storage.exists(instantStatePath)) {
                return this.storage.listDirectEntries(instantStatePath).stream().map(InstantStateDTO::fromStoragePathInfo).collect(Collectors.toList());
            }
            return Collections.emptyList();
        }
        catch (IOException e) {
            throw new HoodieIOException("Failed to load instant states, path: " + instantStatePath, e);
        }
    }
}

