/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.table.marker;

import com.fasterxml.jackson.core.type.TypeReference;
import java.io.IOException;
import java.util.Collections;
import java.util.ConcurrentModificationException;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.hudi.common.engine.HoodieEngineContext;
import org.apache.hudi.common.fs.FSUtils;
import org.apache.hudi.common.model.IOType;
import org.apache.hudi.common.table.marker.MarkerOperation;
import org.apache.hudi.common.table.timeline.HoodieActiveTimeline;
import org.apache.hudi.common.util.HoodieTimer;
import org.apache.hudi.common.util.Option;
import org.apache.hudi.common.util.StringUtils;
import org.apache.hudi.config.HoodieWriteConfig;
import org.apache.hudi.exception.HoodieEarlyConflictDetectionException;
import org.apache.hudi.exception.HoodieRemoteException;
import org.apache.hudi.storage.StoragePath;
import org.apache.hudi.table.HoodieTable;
import org.apache.hudi.table.marker.WriteMarkers;
import org.apache.hudi.util.HttpRequestClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TimelineServerBasedWriteMarkers
extends WriteMarkers {
    private static final Logger LOG = LoggerFactory.getLogger(TimelineServerBasedWriteMarkers.class);
    private static final TypeReference<Boolean> BOOLEAN_TYPE_REFERENCE = new TypeReference<Boolean>(){};
    private static final TypeReference<Set<String>> SET_TYPE_REFERENCE = new TypeReference<Set<String>>(){};
    private final HttpRequestClient httpRequestClient;

    public TimelineServerBasedWriteMarkers(HoodieTable table, String instantTime) {
        this(table.getMetaClient().getBasePath().toString(), table.getMetaClient().getMarkerFolderPath(instantTime), instantTime, table.getConfig().getViewStorageConfig().getRemoteViewServerHost(), table.getConfig().getViewStorageConfig().getRemoteViewServerPort(), table.getConfig().getViewStorageConfig().getRemoteTimelineClientTimeoutSecs());
    }

    TimelineServerBasedWriteMarkers(String basePath, String markerFolderPath, String instantTime, String timelineServerHost, int timelineServerPort, int timeoutSecs) {
        super(basePath, markerFolderPath, instantTime);
        this.httpRequestClient = new HttpRequestClient(timelineServerHost, timelineServerPort, timeoutSecs, 0);
    }

    @Override
    public boolean deleteMarkerDir(HoodieEngineContext context, int parallelism) {
        Map<String, String> paramsMap = Collections.singletonMap("markerdirpath", this.markerDirPath.toString());
        try {
            return this.httpRequestClient.executeRequest(MarkerOperation.DELETE_MARKER_DIR_URL, paramsMap, BOOLEAN_TYPE_REFERENCE, HttpRequestClient.RequestMethod.POST);
        }
        catch (IOException e) {
            throw new HoodieRemoteException("Failed to delete marker directory " + this.markerDirPath.toString(), e);
        }
    }

    @Override
    public boolean doesMarkerDirExist() {
        Map<String, String> paramsMap = Collections.singletonMap("markerdirpath", this.markerDirPath.toString());
        try {
            return this.httpRequestClient.executeRequest(MarkerOperation.MARKERS_DIR_EXISTS_URL, paramsMap, BOOLEAN_TYPE_REFERENCE, HttpRequestClient.RequestMethod.GET);
        }
        catch (IOException e) {
            throw new HoodieRemoteException("Failed to check marker directory " + this.markerDirPath.toString(), e);
        }
    }

    @Override
    public Set<String> createdAndMergedDataPaths(HoodieEngineContext context, int parallelism) throws IOException {
        Map<String, String> paramsMap = Collections.singletonMap("markerdirpath", this.markerDirPath.toString());
        try {
            Set<String> markerPaths = this.httpRequestClient.executeRequest(MarkerOperation.CREATE_AND_MERGE_MARKERS_URL, paramsMap, SET_TYPE_REFERENCE, HttpRequestClient.RequestMethod.GET);
            return markerPaths.stream().map(WriteMarkers::stripMarkerSuffix).collect(Collectors.toSet());
        }
        catch (IOException e) {
            throw new HoodieRemoteException("Failed to get CREATE and MERGE data file paths in " + this.markerDirPath.toString(), e);
        }
    }

    @Override
    public Set<String> allMarkerFilePaths() {
        Map<String, String> paramsMap = Collections.singletonMap("markerdirpath", this.markerDirPath.toString());
        try {
            return this.httpRequestClient.executeRequest(MarkerOperation.ALL_MARKERS_URL, paramsMap, SET_TYPE_REFERENCE, HttpRequestClient.RequestMethod.GET);
        }
        catch (IOException e) {
            throw new HoodieRemoteException("Failed to get all markers in " + this.markerDirPath.toString(), e);
        }
    }

    @Override
    protected Option<StoragePath> create(String partitionPath, String fileName, IOType type, boolean checkIfExists) {
        HoodieTimer timer = HoodieTimer.start();
        String markerFileName = TimelineServerBasedWriteMarkers.getMarkerFileName(fileName, type);
        Map<String, String> paramsMap = this.getConfigMap(partitionPath, markerFileName, false);
        boolean success = this.executeCreateMarkerRequest(paramsMap, partitionPath, markerFileName);
        LOG.info("[timeline-server-based] Created marker file " + partitionPath + "/" + markerFileName + " in " + timer.endTimer() + " ms");
        if (success) {
            return Option.of(new StoragePath(FSUtils.constructAbsolutePath(this.markerDirPath, partitionPath), markerFileName));
        }
        return Option.empty();
    }

    @Override
    public Option<StoragePath> createWithEarlyConflictDetection(String partitionPath, String fileName, IOType type, boolean checkIfExists, HoodieWriteConfig config, String fileId, HoodieActiveTimeline activeTimeline) {
        HoodieTimer timer = new HoodieTimer().startTimer();
        String markerFileName = TimelineServerBasedWriteMarkers.getMarkerFileName(fileName, type);
        Map<String, String> paramsMap = this.getConfigMap(partitionPath, markerFileName, true);
        boolean success = this.executeCreateMarkerRequest(paramsMap, partitionPath, markerFileName);
        LOG.info("[timeline-server-based] Created marker file with early conflict detection " + partitionPath + "/" + markerFileName + " in " + timer.endTimer() + " ms");
        if (success) {
            return Option.of(new StoragePath(FSUtils.constructAbsolutePath(this.markerDirPath, partitionPath), markerFileName));
        }
        throw new HoodieEarlyConflictDetectionException(new ConcurrentModificationException("Early conflict detected but cannot resolve conflicts for overlapping writes"));
    }

    private boolean executeCreateMarkerRequest(Map<String, String> paramsMap, String partitionPath, String markerFileName) {
        boolean success;
        try {
            success = this.httpRequestClient.executeRequest(MarkerOperation.CREATE_MARKER_URL, paramsMap, BOOLEAN_TYPE_REFERENCE, HttpRequestClient.RequestMethod.POST);
        }
        catch (IOException e) {
            throw new HoodieRemoteException("Failed to create marker file " + partitionPath + "/" + markerFileName, e);
        }
        return success;
    }

    private Map<String, String> getConfigMap(String partitionPath, String markerFileName, boolean initEarlyConflictDetectionConfigs) {
        HashMap<String, String> paramsMap = new HashMap<String, String>();
        paramsMap.put("markerdirpath", this.markerDirPath.toString());
        if (StringUtils.isNullOrEmpty(partitionPath)) {
            paramsMap.put("markername", markerFileName);
        } else {
            paramsMap.put("markername", partitionPath + "/" + markerFileName);
        }
        if (initEarlyConflictDetectionConfigs) {
            paramsMap.put("basepath", this.basePath);
        }
        return paramsMap;
    }
}

