/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.table.action.savepoint;

import org.apache.hudi.common.table.timeline.HoodieInstant;
import org.apache.hudi.common.util.Option;
import org.apache.hudi.common.util.ValidationUtils;
import org.apache.hudi.exception.HoodieRollbackException;
import org.apache.hudi.table.HoodieTable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SavepointHelpers {
    private static final Logger LOG = LoggerFactory.getLogger(SavepointHelpers.class);

    public static void deleteSavepoint(HoodieTable table, String savepointTime) {
        HoodieInstant savePoint = table.getMetaClient().createNewInstant(HoodieInstant.State.COMPLETED, "savepoint", savepointTime);
        boolean isSavepointPresent = table.getCompletedSavepointTimeline().containsInstant(savePoint);
        if (!isSavepointPresent) {
            LOG.warn("No savepoint present " + savepointTime);
            return;
        }
        table.getActiveTimeline().revertToInflight(savePoint);
        table.getActiveTimeline().deleteInflight(table.getMetaClient().createNewInstant(HoodieInstant.State.INFLIGHT, "savepoint", savepointTime));
        LOG.info("Savepoint " + savepointTime + " deleted");
    }

    public static void validateSavepointRestore(HoodieTable table, String savepointTime) {
        table.getMetaClient().reloadActiveTimeline();
        Option<HoodieInstant> lastInstant = table.getActiveTimeline().getWriteTimeline().filterCompletedAndCompactionInstants().lastInstant();
        ValidationUtils.checkArgument(lastInstant.isPresent());
        ValidationUtils.checkArgument(lastInstant.get().requestedTime().equals(savepointTime), savepointTime + " is not the last commit after restoring to savepoint, last commit was " + lastInstant.get().requestedTime());
    }

    public static void validateSavepointPresence(HoodieTable table, String savepointTime) {
        HoodieInstant savePoint = table.getMetaClient().createNewInstant(HoodieInstant.State.COMPLETED, "savepoint", savepointTime);
        boolean isSavepointPresent = table.getCompletedSavepointTimeline().containsInstant(savePoint);
        if (!isSavepointPresent) {
            throw new HoodieRollbackException("No savepoint for instantTime " + savepointTime);
        }
    }
}

