/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.table.action.index;

import java.util.List;
import java.util.Set;
import org.apache.hudi.avro.model.HoodieIndexPartitionInfo;
import org.apache.hudi.client.heartbeat.HoodieHeartbeatClient;
import org.apache.hudi.client.transaction.TransactionManager;
import org.apache.hudi.common.engine.HoodieEngineContext;
import org.apache.hudi.common.table.HoodieTableMetaClient;
import org.apache.hudi.common.table.timeline.HoodieInstant;
import org.apache.hudi.metadata.HoodieTableMetadataWriter;
import org.apache.hudi.metadata.MetadataPartitionType;
import org.apache.hudi.table.HoodieTable;
import org.apache.hudi.table.action.index.IndexingCatchupTask;
import org.apache.hudi.table.action.index.RecordBasedIndexingCatchupTask;
import org.apache.hudi.table.action.index.WriteStatBasedIndexingCatchupTask;

public class IndexingCatchupTaskFactory {
    public static IndexingCatchupTask createCatchupTask(List<HoodieIndexPartitionInfo> indexPartitionInfos, HoodieTableMetadataWriter metadataWriter, List<HoodieInstant> instantsToIndex, Set<String> metadataCompletedInstants, HoodieTable table, HoodieTableMetaClient metadataMetaClient, String currentCaughtupInstant, TransactionManager transactionManager, HoodieEngineContext engineContext, HoodieHeartbeatClient heartbeatClient) {
        HoodieTableMetaClient metaClient = table.getMetaClient();
        boolean hasRecordLevelIndexing = indexPartitionInfos.stream().anyMatch(partitionInfo -> partitionInfo.getMetadataPartitionPath().equals(MetadataPartitionType.RECORD_INDEX.getPartitionPath()));
        if (hasRecordLevelIndexing) {
            return new RecordBasedIndexingCatchupTask(metadataWriter, instantsToIndex, metadataCompletedInstants, metaClient, metadataMetaClient, currentCaughtupInstant, transactionManager, engineContext, table, heartbeatClient);
        }
        return new WriteStatBasedIndexingCatchupTask(metadataWriter, instantsToIndex, metadataCompletedInstants, metaClient, metadataMetaClient, currentCaughtupInstant, transactionManager, engineContext, table, heartbeatClient);
    }
}

