/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.org.apache.hadoop.hbase.util;

import java.io.IOException;
import org.apache.hudi.org.apache.hadoop.hbase.Cell;
import org.apache.hudi.org.apache.hadoop.hbase.CellComparator;
import org.apache.hudi.org.apache.hadoop.hbase.CellUtil;
import org.apache.hudi.org.apache.hadoop.hbase.io.hfile.HFile;
import org.apache.hudi.org.apache.hadoop.hbase.regionserver.HStoreFile;
import org.apache.hudi.org.apache.hadoop.hbase.util.BloomContext;
import org.apache.hudi.org.apache.hadoop.hbase.util.BloomFilterWriter;
import org.apache.yetus.audience.InterfaceAudience;

@InterfaceAudience.Private
public class RowBloomContext
extends BloomContext {
    public RowBloomContext(BloomFilterWriter bloomFilterWriter, CellComparator comparator) {
        super(bloomFilterWriter, comparator);
    }

    @Override
    public void addLastBloomKey(HFile.Writer writer) throws IOException {
        if (this.getLastCell() != null) {
            byte[] key = CellUtil.copyRow(this.getLastCell());
            writer.appendFileInfo(HStoreFile.LAST_BLOOM_KEY, key);
        }
    }

    @Override
    protected boolean isNewKey(Cell cell) {
        if (this.getLastCell() != null) {
            return !CellUtil.matchingRows(cell, this.getLastCell());
        }
        return true;
    }
}

