/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.org.apache.hadoop.hbase.security.visibility;

import java.io.IOException;
import java.util.Optional;
import org.apache.hadoop.conf.Configuration;
import org.apache.hudi.org.apache.hadoop.hbase.CoprocessorEnvironment;
import org.apache.hudi.org.apache.hadoop.hbase.coprocessor.ObserverContext;
import org.apache.hudi.org.apache.hadoop.hbase.coprocessor.RegionServerCoprocessor;
import org.apache.hudi.org.apache.hadoop.hbase.coprocessor.RegionServerCoprocessorEnvironment;
import org.apache.hudi.org.apache.hadoop.hbase.coprocessor.RegionServerObserver;
import org.apache.hudi.org.apache.hadoop.hbase.replication.ReplicationEndpoint;
import org.apache.hudi.org.apache.hadoop.hbase.security.visibility.VisibilityLabelService;
import org.apache.hudi.org.apache.hadoop.hbase.security.visibility.VisibilityLabelServiceManager;
import org.apache.hudi.org.apache.hadoop.hbase.security.visibility.VisibilityReplicationEndpoint;
import org.apache.yetus.audience.InterfaceAudience;

@InterfaceAudience.Private
public class VisibilityReplication
implements RegionServerCoprocessor,
RegionServerObserver {
    private Configuration conf;
    private VisibilityLabelService visibilityLabelService;

    @Override
    public void start(CoprocessorEnvironment env) throws IOException {
        this.conf = env.getConfiguration();
        this.visibilityLabelService = VisibilityLabelServiceManager.getInstance().getVisibilityLabelService(this.conf);
    }

    @Override
    public void stop(CoprocessorEnvironment env) throws IOException {
    }

    @Override
    public Optional<RegionServerObserver> getRegionServerObserver() {
        return Optional.of(this);
    }

    @Override
    public ReplicationEndpoint postCreateReplicationEndPoint(ObserverContext<RegionServerCoprocessorEnvironment> ctx, ReplicationEndpoint endpoint) {
        return new VisibilityReplicationEndpoint(endpoint, this.visibilityLabelService);
    }
}

