/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.org.apache.hadoop.hbase.regionserver.compactions;

import java.io.IOException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hudi.org.apache.hadoop.hbase.regionserver.AbstractMultiFileWriter;
import org.apache.hudi.org.apache.hadoop.hbase.regionserver.HStore;
import org.apache.hudi.org.apache.hadoop.hbase.regionserver.InternalScanner;
import org.apache.hudi.org.apache.hadoop.hbase.regionserver.StoreFileWriter;
import org.apache.hudi.org.apache.hadoop.hbase.regionserver.StoreScanner;
import org.apache.hudi.org.apache.hadoop.hbase.regionserver.compactions.Compactor;
import org.apache.yetus.audience.InterfaceAudience;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Private
public abstract class AbstractMultiOutputCompactor<T extends AbstractMultiFileWriter>
extends Compactor<T> {
    private static final Logger LOG = LoggerFactory.getLogger(AbstractMultiOutputCompactor.class);

    public AbstractMultiOutputCompactor(Configuration conf, HStore store) {
        super(conf, store);
    }

    protected void initMultiWriter(AbstractMultiFileWriter writer, InternalScanner scanner, final Compactor.FileDetails fd, final boolean shouldDropBehind) {
        AbstractMultiFileWriter.WriterFactory writerFactory = new AbstractMultiFileWriter.WriterFactory(){

            @Override
            public StoreFileWriter createWriter() throws IOException {
                return AbstractMultiOutputCompactor.this.createTmpWriter(fd, shouldDropBehind);
            }

            @Override
            public StoreFileWriter createWriterWithStoragePolicy(String fileStoragePolicy) throws IOException {
                return AbstractMultiOutputCompactor.this.createTmpWriter(fd, shouldDropBehind, fileStoragePolicy);
            }
        };
        StoreScanner storeScanner = scanner instanceof StoreScanner ? (StoreScanner)scanner : null;
        writer.init(storeScanner, writerFactory);
    }

    @Override
    protected void abortWriter(T writer) throws IOException {
        FileSystem fs = this.store.getFileSystem();
        for (Path leftoverFile : ((AbstractMultiFileWriter)writer).abortWriters()) {
            try {
                fs.delete(leftoverFile, false);
            }
            catch (IOException e) {
                LOG.warn("Failed to delete the leftover file " + leftoverFile + " after an unfinished compaction.", (Throwable)e);
            }
        }
    }
}

