/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.org.apache.hadoop.hbase.quotas;

import org.apache.hadoop.conf.Configuration;
import org.apache.hudi.org.apache.hadoop.hbase.quotas.DefaultOperationQuota;
import org.apache.hudi.org.apache.hadoop.hbase.quotas.QuotaLimiter;
import org.apache.hudi.org.apache.hadoop.hbase.quotas.RpcThrottlingException;
import org.apache.yetus.audience.InterfaceAudience;
import org.apache.yetus.audience.InterfaceStability;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Private
@InterfaceStability.Evolving
public class ExceedOperationQuota
extends DefaultOperationQuota {
    private static final Logger LOG = LoggerFactory.getLogger(ExceedOperationQuota.class);
    private QuotaLimiter regionServerLimiter;

    public ExceedOperationQuota(Configuration conf, QuotaLimiter regionServerLimiter, QuotaLimiter ... limiters) {
        super(conf, limiters);
        this.regionServerLimiter = regionServerLimiter;
    }

    @Override
    public void checkQuota(int numWrites, int numReads, int numScans) throws RpcThrottlingException {
        if (this.regionServerLimiter.isBypass()) {
            LOG.warn("Exceed throttle quota is enabled but no region server quotas found");
            super.checkQuota(numWrites, numReads, numScans);
        } else {
            boolean exceed;
            block6: {
                this.updateEstimateConsumeQuota(numWrites, numReads, numScans);
                this.regionServerLimiter.checkQuota(numWrites, this.writeConsumed, numReads + numScans, this.readConsumed, this.writeCapacityUnitConsumed, this.readCapacityUnitConsumed);
                exceed = false;
                try {
                    super.checkQuota(numWrites, numReads, numScans);
                }
                catch (RpcThrottlingException e) {
                    exceed = true;
                    if (!LOG.isDebugEnabled()) break block6;
                    LOG.debug("Read/Write requests num exceeds quota: writes:{} reads:{} scan:{}, try use region server quota", new Object[]{numWrites, numReads, numScans});
                }
            }
            this.readAvailable = Math.max(this.readAvailable, this.regionServerLimiter.getReadAvailable());
            this.regionServerLimiter.grabQuota(numWrites, this.writeConsumed, numReads + numScans, this.readConsumed, this.writeCapacityUnitConsumed, this.writeCapacityUnitConsumed);
            if (exceed) {
                for (QuotaLimiter limiter : this.limiters) {
                    limiter.grabQuota(numWrites, this.writeConsumed, numReads + numScans, this.readConsumed, this.writeCapacityUnitConsumed, this.writeCapacityUnitConsumed);
                }
            }
        }
    }

    @Override
    public void close() {
        super.close();
        if (this.writeDiff != 0L) {
            this.regionServerLimiter.consumeWrite(this.writeDiff, this.writeCapacityUnitDiff);
        }
        if (this.readDiff != 0L) {
            this.regionServerLimiter.consumeRead(this.readDiff, this.readCapacityUnitDiff);
        }
    }
}

