/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.org.apache.hadoop.hbase.master.snapshot;

import java.io.IOException;
import java.util.HashSet;
import java.util.List;
import org.apache.hudi.org.apache.hadoop.hbase.ServerName;
import org.apache.hudi.org.apache.hadoop.hbase.client.RegionInfo;
import org.apache.hudi.org.apache.hadoop.hbase.client.RegionReplicaUtil;
import org.apache.hudi.org.apache.hadoop.hbase.errorhandling.ForeignException;
import org.apache.hudi.org.apache.hadoop.hbase.master.MasterServices;
import org.apache.hudi.org.apache.hadoop.hbase.master.snapshot.SnapshotManager;
import org.apache.hudi.org.apache.hadoop.hbase.master.snapshot.TakeSnapshotHandler;
import org.apache.hudi.org.apache.hadoop.hbase.mob.MobUtils;
import org.apache.hudi.org.apache.hadoop.hbase.procedure.Procedure;
import org.apache.hudi.org.apache.hadoop.hbase.procedure.ProcedureCoordinator;
import org.apache.hudi.org.apache.hadoop.hbase.shaded.protobuf.generated.SnapshotProtos;
import org.apache.hudi.org.apache.hadoop.hbase.snapshot.HBaseSnapshotException;
import org.apache.hudi.org.apache.hadoop.hbase.util.Pair;
import org.apache.hudi.org.apache.hbase.thirdparty.com.google.common.collect.Lists;
import org.apache.yetus.audience.InterfaceAudience;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Private
public class EnabledTableSnapshotHandler
extends TakeSnapshotHandler {
    private static final Logger LOG = LoggerFactory.getLogger(EnabledTableSnapshotHandler.class);
    private final ProcedureCoordinator coordinator;

    public EnabledTableSnapshotHandler(SnapshotProtos.SnapshotDescription snapshot, MasterServices master, SnapshotManager manager) throws IOException {
        super(snapshot, master, manager);
        this.coordinator = manager.getCoordinator();
    }

    @Override
    public EnabledTableSnapshotHandler prepare() throws Exception {
        return (EnabledTableSnapshotHandler)super.prepare();
    }

    @Override
    protected void snapshotRegions(List<Pair<RegionInfo, ServerName>> regions) throws IOException {
        HashSet<String> regionServers = new HashSet<String>(regions.size());
        for (Pair<RegionInfo, ServerName> region : regions) {
            RegionInfo regionInfo;
            if (region == null || region.getFirst() == null || region.getSecond() == null || (regionInfo = region.getFirst()).isOffline() && (regionInfo.isSplit() || regionInfo.isSplitParent())) continue;
            regionServers.add(region.getSecond().toString());
        }
        Procedure proc = this.coordinator.startProcedure(this.monitor, this.snapshot.getName(), this.snapshot.toByteArray(), Lists.newArrayList(regionServers));
        if (proc == null) {
            String msg = "Failed to submit distributed procedure for snapshot '" + this.snapshot.getName() + "'";
            LOG.error(msg);
            throw new HBaseSnapshotException(msg);
        }
        try {
            proc.waitForCompleted();
            LOG.info("Done waiting - online snapshot for " + this.snapshot.getName());
            for (Pair pair : regions) {
                RegionInfo regionInfo = (RegionInfo)pair.getFirst();
                if (!regionInfo.isOffline() || !regionInfo.isSplit() && !regionInfo.isSplitParent() || !RegionReplicaUtil.isDefaultReplica(regionInfo)) continue;
                LOG.info("Take disabled snapshot of offline region=" + regionInfo);
                this.snapshotDisabledRegion(regionInfo);
            }
            boolean mobEnabled = MobUtils.hasMobColumns(this.htd);
            if (mobEnabled) {
                LOG.info("Taking snapshot for mob files in table " + this.htd.getTableName());
                RegionInfo regionInfo = MobUtils.getMobRegionInfo(this.htd.getTableName());
                this.snapshotMobRegion(regionInfo);
            }
        }
        catch (InterruptedException e) {
            ForeignException foreignException = new ForeignException("Interrupted while waiting for snapshot to finish", e);
            this.monitor.receive(foreignException);
            Thread.currentThread().interrupt();
        }
        catch (ForeignException e) {
            this.monitor.receive(e);
        }
    }

    private void snapshotMobRegion(RegionInfo regionInfo) throws IOException {
        this.snapshotManifest.addMobRegion(regionInfo);
        this.monitor.rethrowException();
        this.status.setStatus("Completed referencing HFiles for the mob region of table: " + this.snapshotTable);
    }

    @Override
    protected boolean downgradeToSharedTableLock() {
        return true;
    }
}

