/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.org.apache.hadoop.hbase.master.janitor;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.apache.hudi.org.apache.hadoop.hbase.ServerName;
import org.apache.hudi.org.apache.hadoop.hbase.client.RegionInfo;
import org.apache.hudi.org.apache.hadoop.hbase.client.Result;
import org.apache.hudi.org.apache.hadoop.hbase.master.janitor.CatalogJanitor;
import org.apache.hudi.org.apache.hadoop.hbase.util.Bytes;
import org.apache.hudi.org.apache.hadoop.hbase.util.EnvironmentEdgeManager;
import org.apache.hudi.org.apache.hadoop.hbase.util.Pair;
import org.apache.yetus.audience.InterfaceAudience;

@InterfaceAudience.Private
public class CatalogJanitorReport {
    private final long now = EnvironmentEdgeManager.currentTime();
    final Map<RegionInfo, Result> splitParents = new TreeMap<RegionInfo, Result>(new CatalogJanitor.SplitParentFirstComparator());
    final Map<RegionInfo, Result> mergedRegions = new TreeMap<RegionInfo, Result>(RegionInfo.COMPARATOR);
    int count = 0;
    final List<Pair<RegionInfo, RegionInfo>> holes = new ArrayList<Pair<RegionInfo, RegionInfo>>();
    final List<Pair<RegionInfo, RegionInfo>> overlaps = new ArrayList<Pair<RegionInfo, RegionInfo>>();
    final List<Pair<RegionInfo, ServerName>> unknownServers = new ArrayList<Pair<RegionInfo, ServerName>>();
    final List<byte[]> emptyRegionInfo = new ArrayList<byte[]>();

    public long getCreateTime() {
        return this.now;
    }

    public List<Pair<RegionInfo, RegionInfo>> getHoles() {
        return this.holes;
    }

    public List<Pair<RegionInfo, RegionInfo>> getOverlaps() {
        return this.overlaps;
    }

    public Map<RegionInfo, Result> getMergedRegions() {
        return this.mergedRegions;
    }

    public List<Pair<RegionInfo, ServerName>> getUnknownServers() {
        return this.unknownServers;
    }

    public List<byte[]> getEmptyRegionInfo() {
        return this.emptyRegionInfo;
    }

    public boolean isEmpty() {
        return this.holes.isEmpty() && this.overlaps.isEmpty() && this.unknownServers.isEmpty() && this.emptyRegionInfo.isEmpty();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        for (Pair<RegionInfo, RegionInfo> pair : this.holes) {
            if (sb.length() > 0) {
                sb.append(", ");
            }
            sb.append("hole=").append(pair.getFirst().getRegionNameAsString()).append("/").append(pair.getSecond().getRegionNameAsString());
        }
        for (Pair<RegionInfo, RegionInfo> pair : this.overlaps) {
            if (sb.length() > 0) {
                sb.append(", ");
            }
            sb.append("overlap=").append(pair.getFirst().getRegionNameAsString()).append("/").append(pair.getSecond().getRegionNameAsString());
        }
        for (byte[] byArray : this.emptyRegionInfo) {
            if (sb.length() > 0) {
                sb.append(", ");
            }
            sb.append("empty=").append(Bytes.toStringBinary(byArray));
        }
        for (Pair<RegionInfo, Comparable<RegionInfo>> pair : this.unknownServers) {
            if (sb.length() > 0) {
                sb.append(", ");
            }
            sb.append("unknown_server=").append(pair.getSecond()).append("/").append(pair.getFirst().getRegionNameAsString());
        }
        return sb.toString();
    }
}

