/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.org.apache.hadoop.hbase.master;

import java.io.Serializable;
import java.util.Comparator;
import org.apache.hudi.org.apache.hadoop.hbase.ServerName;
import org.apache.hudi.org.apache.hadoop.hbase.client.RegionInfo;
import org.apache.yetus.audience.InterfaceAudience;
import org.apache.yetus.audience.InterfaceStability;

@InterfaceAudience.LimitedPrivate(value={"Coprocessors"})
@InterfaceStability.Evolving
public class RegionPlan
implements Comparable<RegionPlan> {
    private final RegionInfo hri;
    private final ServerName source;
    private ServerName dest;

    public RegionPlan(RegionInfo hri, ServerName source, ServerName dest) {
        this.hri = hri;
        this.source = source;
        this.dest = dest;
    }

    public void setDestination(ServerName dest) {
        this.dest = dest;
    }

    public ServerName getSource() {
        return this.source;
    }

    public ServerName getDestination() {
        return this.dest;
    }

    public String getRegionName() {
        return this.hri.getEncodedName();
    }

    public RegionInfo getRegionInfo() {
        return this.hri;
    }

    @Override
    public int compareTo(RegionPlan other) {
        return RegionPlan.compareTo(this, other);
    }

    private static int compareTo(RegionPlan left, RegionPlan right) {
        int result = RegionPlan.compareServerName(left.source, right.source);
        if (result != 0) {
            return result;
        }
        if (left.hri == null) {
            if (right.hri != null) {
                return -1;
            }
        } else {
            if (right.hri == null) {
                return 1;
            }
            result = RegionInfo.COMPARATOR.compare(left.hri, right.hri);
        }
        if (result != 0) {
            return result;
        }
        return RegionPlan.compareServerName(left.dest, right.dest);
    }

    private static int compareServerName(ServerName left, ServerName right) {
        if (left == null) {
            return right == null ? 0 : -1;
        }
        if (right == null) {
            return 1;
        }
        return left.compareTo(right);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.dest == null ? 0 : this.dest.hashCode());
        result = 31 * result + (this.hri == null ? 0 : this.hri.hashCode());
        result = 31 * result + (this.source == null ? 0 : this.source.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        RegionPlan other = (RegionPlan)obj;
        if (this.dest == null ? other.dest != null : !this.dest.equals(other.dest)) {
            return false;
        }
        if (this.hri == null ? other.hri != null : !this.hri.equals(other.hri)) {
            return false;
        }
        return !(this.source == null ? other.source != null : !this.source.equals(other.source));
    }

    public String toString() {
        return "hri=" + this.hri.getEncodedName() + ", source=" + (this.source == null ? "" : this.source.toString()) + ", destination=" + (this.dest == null ? "" : this.dest.toString());
    }

    public static class RegionPlanComparator
    implements Comparator<RegionPlan>,
    Serializable {
        private static final long serialVersionUID = 4213207330485734853L;

        @Override
        public int compare(RegionPlan l, RegionPlan r) {
            return RegionPlan.compareTo(l, r);
        }
    }
}

