/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.org.apache.hadoop.hbase.coprocessor;

import java.util.Optional;
import org.apache.hudi.org.apache.hadoop.hbase.CoprocessorEnvironment;
import org.apache.hudi.org.apache.hadoop.hbase.coprocessor.ObserverContext;
import org.apache.hudi.org.apache.hadoop.hbase.ipc.RpcServer;
import org.apache.hudi.org.apache.hadoop.hbase.security.User;
import org.apache.yetus.audience.InterfaceAudience;

@InterfaceAudience.Private
public class ObserverContextImpl<E extends CoprocessorEnvironment>
implements ObserverContext<E> {
    private E env;
    private boolean bypass;
    private final boolean bypassable;
    private final User caller;

    public ObserverContextImpl(User caller) {
        this(caller, false);
    }

    public ObserverContextImpl(User caller, boolean bypassable) {
        this.caller = caller;
        this.bypassable = bypassable;
    }

    @Override
    public E getEnvironment() {
        return this.env;
    }

    public void prepare(E env) {
        this.env = env;
    }

    public boolean isBypassable() {
        return this.bypassable;
    }

    @Override
    public void bypass() {
        if (!this.bypassable) {
            throw new UnsupportedOperationException("This method does not support 'bypass'.");
        }
        this.bypass = true;
    }

    public boolean shouldBypass() {
        if (!this.isBypassable()) {
            return false;
        }
        if (this.bypass) {
            this.bypass = false;
            return true;
        }
        return false;
    }

    @Override
    public Optional<User> getCaller() {
        return Optional.ofNullable(this.caller);
    }

    @Deprecated
    public static <E extends CoprocessorEnvironment> ObserverContext<E> createAndPrepare(E env) {
        ObserverContextImpl<E> ctx = new ObserverContextImpl<E>(RpcServer.getRequestUser().orElse(null));
        ctx.prepare(env);
        return ctx;
    }
}

