/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.org.apache.hadoop.hbase.client;

import org.apache.hadoop.conf.Configuration;
import org.apache.yetus.audience.InterfaceAudience;

@InterfaceAudience.Private
public class ConnectionConfiguration {
    public static final String WRITE_BUFFER_SIZE_KEY = "hbase.client.write.buffer";
    public static final long WRITE_BUFFER_SIZE_DEFAULT = 0x200000L;
    public static final String WRITE_BUFFER_PERIODIC_FLUSH_TIMEOUT_MS = "hbase.client.write.buffer.periodicflush.timeout.ms";
    public static final String WRITE_BUFFER_PERIODIC_FLUSH_TIMERTICK_MS = "hbase.client.write.buffer.periodicflush.timertick.ms";
    public static final long WRITE_BUFFER_PERIODIC_FLUSH_TIMEOUT_MS_DEFAULT = 0L;
    public static final long WRITE_BUFFER_PERIODIC_FLUSH_TIMERTICK_MS_DEFAULT = 1000L;
    public static final String MAX_KEYVALUE_SIZE_KEY = "hbase.client.keyvalue.maxsize";
    public static final int MAX_KEYVALUE_SIZE_DEFAULT = 0xA00000;
    public static final String PRIMARY_CALL_TIMEOUT_MICROSECOND = "hbase.client.primaryCallTimeout.get";
    public static final int PRIMARY_CALL_TIMEOUT_MICROSECOND_DEFAULT = 10000;
    public static final String PRIMARY_SCAN_TIMEOUT_MICROSECOND = "hbase.client.replicaCallTimeout.scan";
    public static final int PRIMARY_SCAN_TIMEOUT_MICROSECOND_DEFAULT = 1000000;
    private final long writeBufferSize;
    private final long writeBufferPeriodicFlushTimeoutMs;
    private final long writeBufferPeriodicFlushTimerTickMs;
    private final int metaOperationTimeout;
    private final int operationTimeout;
    private final int scannerCaching;
    private final long scannerMaxResultSize;
    private final int primaryCallTimeoutMicroSecond;
    private final int replicaCallTimeoutMicroSecondScan;
    private final int metaReplicaCallTimeoutMicroSecondScan;
    private final int retries;
    private final int maxKeyValueSize;
    private final int rpcTimeout;
    private final int readRpcTimeout;
    private final int writeRpcTimeout;
    private final boolean clientScannerAsyncPrefetch;

    ConnectionConfiguration(Configuration conf) {
        this.writeBufferSize = conf.getLong(WRITE_BUFFER_SIZE_KEY, 0x200000L);
        this.writeBufferPeriodicFlushTimeoutMs = conf.getLong(WRITE_BUFFER_PERIODIC_FLUSH_TIMEOUT_MS, 0L);
        this.writeBufferPeriodicFlushTimerTickMs = conf.getLong(WRITE_BUFFER_PERIODIC_FLUSH_TIMERTICK_MS, 1000L);
        this.metaOperationTimeout = conf.getInt("hbase.client.meta.operation.timeout", 1200000);
        this.operationTimeout = conf.getInt("hbase.client.operation.timeout", 1200000);
        this.scannerCaching = conf.getInt("hbase.client.scanner.caching", Integer.MAX_VALUE);
        this.scannerMaxResultSize = conf.getLong("hbase.client.scanner.max.result.size", 0x200000L);
        this.primaryCallTimeoutMicroSecond = conf.getInt(PRIMARY_CALL_TIMEOUT_MICROSECOND, 10000);
        this.replicaCallTimeoutMicroSecondScan = conf.getInt(PRIMARY_SCAN_TIMEOUT_MICROSECOND, 1000000);
        this.metaReplicaCallTimeoutMicroSecondScan = conf.getInt("hbase.client.meta.replica.scan.timeout", 1000000);
        this.retries = conf.getInt("hbase.client.retries.number", 15);
        this.clientScannerAsyncPrefetch = conf.getBoolean("hbase.client.scanner.async.prefetch", false);
        this.maxKeyValueSize = conf.getInt(MAX_KEYVALUE_SIZE_KEY, 0xA00000);
        this.rpcTimeout = conf.getInt("hbase.rpc.timeout", 60000);
        this.readRpcTimeout = conf.getInt("hbase.rpc.read.timeout", conf.getInt("hbase.rpc.timeout", 60000));
        this.writeRpcTimeout = conf.getInt("hbase.rpc.write.timeout", conf.getInt("hbase.rpc.timeout", 60000));
    }

    protected ConnectionConfiguration() {
        this.writeBufferSize = 0x200000L;
        this.writeBufferPeriodicFlushTimeoutMs = 0L;
        this.writeBufferPeriodicFlushTimerTickMs = 1000L;
        this.metaOperationTimeout = 1200000;
        this.operationTimeout = 1200000;
        this.scannerCaching = Integer.MAX_VALUE;
        this.scannerMaxResultSize = 0x200000L;
        this.primaryCallTimeoutMicroSecond = 10000;
        this.replicaCallTimeoutMicroSecondScan = 1000000;
        this.metaReplicaCallTimeoutMicroSecondScan = 1000000;
        this.retries = 15;
        this.clientScannerAsyncPrefetch = false;
        this.maxKeyValueSize = 0xA00000;
        this.readRpcTimeout = 60000;
        this.writeRpcTimeout = 60000;
        this.rpcTimeout = 60000;
    }

    public int getReadRpcTimeout() {
        return this.readRpcTimeout;
    }

    public int getWriteRpcTimeout() {
        return this.writeRpcTimeout;
    }

    public long getWriteBufferSize() {
        return this.writeBufferSize;
    }

    public long getWriteBufferPeriodicFlushTimeoutMs() {
        return this.writeBufferPeriodicFlushTimeoutMs;
    }

    public long getWriteBufferPeriodicFlushTimerTickMs() {
        return this.writeBufferPeriodicFlushTimerTickMs;
    }

    public int getMetaOperationTimeout() {
        return this.metaOperationTimeout;
    }

    public int getOperationTimeout() {
        return this.operationTimeout;
    }

    public int getScannerCaching() {
        return this.scannerCaching;
    }

    public int getPrimaryCallTimeoutMicroSecond() {
        return this.primaryCallTimeoutMicroSecond;
    }

    public int getReplicaCallTimeoutMicroSecondScan() {
        return this.replicaCallTimeoutMicroSecondScan;
    }

    public int getMetaReplicaCallTimeoutMicroSecondScan() {
        return this.metaReplicaCallTimeoutMicroSecondScan;
    }

    public int getRetriesNumber() {
        return this.retries;
    }

    public int getMaxKeyValueSize() {
        return this.maxKeyValueSize;
    }

    public long getScannerMaxResultSize() {
        return this.scannerMaxResultSize;
    }

    public boolean isClientScannerAsyncPrefetch() {
        return this.clientScannerAsyncPrefetch;
    }

    public int getRpcTimeout() {
        return this.rpcTimeout;
    }
}

