/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.metadata;

import java.util.Properties;
import org.apache.hudi.avro.model.HoodieMetadataRecord;
import org.apache.hudi.client.FailOnFirstErrorWriteStatus;
import org.apache.hudi.common.config.HoodieMetadataConfig;
import org.apache.hudi.common.config.HoodieStorageConfig;
import org.apache.hudi.common.config.RecordMergeMode;
import org.apache.hudi.common.fs.ConsistencyGuardConfig;
import org.apache.hudi.common.model.HoodieAvroRecordMerger;
import org.apache.hudi.common.model.HoodieCleaningPolicy;
import org.apache.hudi.common.model.HoodieFailedWritesCleaningPolicy;
import org.apache.hudi.common.model.WriteConcurrencyMode;
import org.apache.hudi.common.table.HoodieTableConfig;
import org.apache.hudi.common.table.marker.MarkerType;
import org.apache.hudi.common.util.StringUtils;
import org.apache.hudi.common.util.ValidationUtils;
import org.apache.hudi.common.util.VisibleForTesting;
import org.apache.hudi.config.HoodieArchivalConfig;
import org.apache.hudi.config.HoodieCleanConfig;
import org.apache.hudi.config.HoodieCompactionConfig;
import org.apache.hudi.config.HoodiePayloadConfig;
import org.apache.hudi.config.HoodieWriteConfig;
import org.apache.hudi.config.metrics.HoodieMetricsConfig;
import org.apache.hudi.config.metrics.HoodieMetricsDatadogConfig;
import org.apache.hudi.config.metrics.HoodieMetricsGraphiteConfig;
import org.apache.hudi.config.metrics.HoodieMetricsJmxConfig;
import org.apache.hudi.config.metrics.HoodieMetricsM3Config;
import org.apache.hudi.config.metrics.HoodieMetricsPrometheusConfig;
import org.apache.hudi.exception.HoodieMetadataException;
import org.apache.hudi.metadata.HoodieMetadataPayload;
import org.apache.hudi.metadata.HoodieTableMetadata;
import org.apache.hudi.metadata.HoodieTableMetadataKeyGenerator;
import org.apache.hudi.table.action.compact.strategy.UnBoundedCompactionStrategy;

public class HoodieMetadataWriteUtils {
    public static final String RECORD_KEY_FIELD_NAME = "key";
    private static final int MDT_DEFAULT_PARALLELISM = 512;
    private static final long MDT_MAX_HFILE_SIZE_BYTES = 0x280000000L;

    @VisibleForTesting
    public static HoodieWriteConfig createMetadataWriteConfig(HoodieWriteConfig writeConfig, HoodieFailedWritesCleaningPolicy failedWritesCleaningPolicy) {
        HoodieWriteConfig metadataWriteConfig;
        String tableName = writeConfig.getTableName() + "_metadata";
        long maxLogFileSizeBytes = writeConfig.getMetadataConfig().getMaxLogFileSize();
        HoodieCleaningPolicy dataTableCleaningPolicy = writeConfig.getCleanerPolicy();
        HoodieCleanConfig.Builder cleanConfigBuilder = HoodieCleanConfig.newBuilder().withAsyncClean(false).withAutoClean(false).withCleanerParallelism(512).withFailedWritesCleaningPolicy(failedWritesCleaningPolicy).withCleanerPolicy(dataTableCleaningPolicy);
        if (HoodieCleaningPolicy.KEEP_LATEST_COMMITS.equals((Object)dataTableCleaningPolicy)) {
            int retainCommits = (int)Math.max(20.0, (double)writeConfig.getCleanerCommitsRetained() * 1.2);
            cleanConfigBuilder.retainCommits(retainCommits);
        } else if (HoodieCleaningPolicy.KEEP_LATEST_FILE_VERSIONS.equals((Object)dataTableCleaningPolicy)) {
            int retainFileVersions = (int)Math.ceil((double)writeConfig.getCleanerFileVersionsRetained() * 1.2);
            cleanConfigBuilder.retainFileVersions(retainFileVersions);
        } else if (HoodieCleaningPolicy.KEEP_LATEST_BY_HOURS.equals((Object)dataTableCleaningPolicy)) {
            int numHoursRetained = (int)Math.ceil((double)writeConfig.getCleanerHoursRetained() * 1.2);
            cleanConfigBuilder.cleanerNumHoursRetained(numHoursRetained);
        }
        HoodieWriteConfig.Builder builder = HoodieWriteConfig.newBuilder().withEngineType(writeConfig.getEngineType()).withWriteTableVersion(writeConfig.getWriteVersion().versionCode()).withMergeAllowDuplicateOnInserts(false).withConsistencyGuardConfig(ConsistencyGuardConfig.newBuilder().withConsistencyCheckEnabled(writeConfig.getConsistencyGuardConfig().isConsistencyCheckEnabled()).withInitialConsistencyCheckIntervalMs(writeConfig.getConsistencyGuardConfig().getInitialConsistencyCheckIntervalMs()).withMaxConsistencyCheckIntervalMs(writeConfig.getConsistencyGuardConfig().getMaxConsistencyCheckIntervalMs()).withMaxConsistencyChecks(writeConfig.getConsistencyGuardConfig().getMaxConsistencyChecks()).build()).withWriteConcurrencyMode(WriteConcurrencyMode.SINGLE_WRITER).withMetadataConfig(HoodieMetadataConfig.newBuilder().enable(false).withFileListingParallelism(writeConfig.getFileListingParallelism()).build()).withAutoCommit(true).withAvroSchemaValidate(false).withEmbeddedTimelineServerEnabled(false).withMarkersType(MarkerType.DIRECT.name()).withRollbackUsingMarkers(false).withPath(HoodieTableMetadata.getMetadataTableBasePath(writeConfig.getBasePath())).withSchema(HoodieMetadataRecord.getClassSchema().toString()).forTable(tableName).withCleanConfig(cleanConfigBuilder.build()).withArchivalConfig(HoodieArchivalConfig.newBuilder().archiveCommitsWith(writeConfig.getMinCommitsToKeep() + 1, writeConfig.getMaxCommitsToKeep() + 1).withAutoArchive(false).build()).withCompactionConfig(HoodieCompactionConfig.newBuilder().withInlineCompaction(false).withMaxNumDeltaCommitsBeforeCompaction(writeConfig.getMetadataCompactDeltaCommitMax()).withEnableOptimizedLogBlocksScan(String.valueOf(writeConfig.enableOptimizedLogBlocksScan())).withCompactionStrategy(new UnBoundedCompactionStrategy()).withLogCompactionEnabled(writeConfig.isLogCompactionEnabledOnMetadata()).withLogCompactionBlocksThreshold(writeConfig.getMetadataLogCompactBlocksThreshold()).build()).withStorageConfig(HoodieStorageConfig.newBuilder().hfileMaxFileSize(0x280000000L).logFileMaxSize(maxLogFileSizeBytes).logFileDataBlockMaxSize(maxLogFileSizeBytes).build()).withRollbackParallelism(512).withFinalizeWriteParallelism(512).withKeyGenerator(HoodieTableMetadataKeyGenerator.class.getCanonicalName()).withPopulateMetaFields(false).withWriteStatusClass(FailOnFirstErrorWriteStatus.class).withReleaseResourceEnabled(writeConfig.areReleaseResourceEnabled()).withRecordMergeMode(RecordMergeMode.CUSTOM).withRecordMergeStrategyId("00000000-0000-0000-0000-000000000000").withPayloadConfig(HoodiePayloadConfig.newBuilder().withPayloadClass(HoodieMetadataPayload.class.getCanonicalName()).build()).withRecordMergeImplClasses(HoodieAvroRecordMerger.class.getCanonicalName()).withWriteRecordPositionsEnabled(false);
        Properties properties = new Properties();
        properties.put(HoodieTableConfig.RECORDKEY_FIELDS.key(), RECORD_KEY_FIELD_NAME);
        properties.put("hoodie.datasource.write.recordkey.field", RECORD_KEY_FIELD_NAME);
        if (StringUtils.nonEmpty(writeConfig.getMetricReporterMetricsNamePrefix())) {
            properties.put(HoodieMetricsConfig.METRICS_REPORTER_PREFIX.key(), writeConfig.getMetricReporterMetricsNamePrefix() + "_metadata");
        }
        builder.withProperties(properties);
        if (writeConfig.isMetricsOn()) {
            Properties commonProperties = new Properties();
            commonProperties.put(HoodieWriteConfig.TBL_NAME.key(), tableName);
            builder.withMetricsConfig(HoodieMetricsConfig.newBuilder().fromProperties(commonProperties).withReporterType(writeConfig.getMetricsReporterType().toString()).withExecutorMetrics(writeConfig.isExecutorMetricsEnabled()).on(true).build());
            switch (writeConfig.getMetricsReporterType()) {
                case GRAPHITE: {
                    builder.withMetricsGraphiteConfig(HoodieMetricsGraphiteConfig.newBuilder().onGraphitePort(writeConfig.getGraphiteServerPort()).toGraphiteHost(writeConfig.getGraphiteServerHost()).usePrefix(writeConfig.getGraphiteMetricPrefix()).build());
                    break;
                }
                case JMX: {
                    builder.withMetricsJmxConfig(HoodieMetricsJmxConfig.newBuilder().onJmxPort(writeConfig.getJmxPort()).toJmxHost(writeConfig.getJmxHost()).build());
                    break;
                }
                case PROMETHEUS_PUSHGATEWAY: {
                    HoodieMetricsPrometheusConfig pushGatewayConfig = HoodieMetricsPrometheusConfig.newBuilder().withPushgatewayJobname(writeConfig.getPushGatewayJobName()).withPushgatewayRandomJobnameSuffix(writeConfig.getPushGatewayRandomJobNameSuffix()).withPushgatewayLabels(writeConfig.getPushGatewayLabels()).withPushgatewayReportPeriodInSeconds(String.valueOf(writeConfig.getPushGatewayReportPeriodSeconds())).withPushgatewayHostName(writeConfig.getPushGatewayHost()).withPushgatewayPortNum(writeConfig.getPushGatewayPort()).build();
                    builder.withProperties(pushGatewayConfig.getProps());
                    break;
                }
                case M3: {
                    HoodieMetricsM3Config m3Config = HoodieMetricsM3Config.newBuilder().onM3Port(writeConfig.getM3ServerPort()).toM3Host(writeConfig.getM3ServerHost()).useM3Tags(writeConfig.getM3Tags()).useM3Service(writeConfig.getM3Service()).useM3Env(writeConfig.getM3Env()).build();
                    builder.withProperties(m3Config.getProps());
                    break;
                }
                case DATADOG: {
                    HoodieMetricsDatadogConfig.Builder datadogConfig = HoodieMetricsDatadogConfig.newBuilder().withDatadogApiKey(writeConfig.getDatadogApiKey()).withDatadogApiKeySkipValidation(writeConfig.getDatadogApiKeySkipValidation()).withDatadogPrefix(writeConfig.getDatadogMetricPrefix()).withDatadogReportPeriodSeconds(writeConfig.getDatadogReportPeriodSeconds()).withDatadogTags(String.join((CharSequence)",", writeConfig.getDatadogMetricTags())).withDatadogApiTimeoutSeconds(writeConfig.getDatadogApiTimeoutSeconds());
                    if (writeConfig.getDatadogMetricHost() != null) {
                        datadogConfig = datadogConfig.withDatadogHost(writeConfig.getDatadogMetricHost());
                    }
                    if (writeConfig.getDatadogApiSite() != null) {
                        datadogConfig = datadogConfig.withDatadogApiSite(writeConfig.getDatadogApiSite().name());
                    }
                    builder.withProperties(datadogConfig.build().getProps());
                    break;
                }
                case PROMETHEUS: {
                    HoodieMetricsPrometheusConfig prometheusConfig = HoodieMetricsPrometheusConfig.newBuilder().withPushgatewayLabels(writeConfig.getPushGatewayLabels()).withPrometheusPortNum(writeConfig.getPrometheusPort()).build();
                    builder.withProperties(prometheusConfig.getProps());
                    break;
                }
                case CONSOLE: 
                case INMEMORY: 
                case CLOUDWATCH: {
                    break;
                }
                default: {
                    throw new HoodieMetadataException("Unsupported Metrics Reporter type " + (Object)((Object)writeConfig.getMetricsReporterType()));
                }
            }
        }
        ValidationUtils.checkArgument(!(metadataWriteConfig = builder.build()).isAutoClean(), "Cleaning is controlled internally for Metadata table.");
        ValidationUtils.checkArgument(!metadataWriteConfig.inlineCompactionEnabled(), "Compaction is controlled internally for metadata table.");
        ValidationUtils.checkArgument((boolean)metadataWriteConfig.shouldAutoCommit(), "Auto commit is required for Metadata Table");
        ValidationUtils.checkArgument(metadataWriteConfig.getWriteStatusClassName().equals(FailOnFirstErrorWriteStatus.class.getName()), "MDT should use " + FailOnFirstErrorWriteStatus.class.getName());
        ValidationUtils.checkArgument(!metadataWriteConfig.isMetadataTableEnabled(), "File listing cannot be used for Metadata Table");
        return metadataWriteConfig;
    }
}

