/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.io;

import java.util.Iterator;
import java.util.Map;
import org.apache.hudi.common.engine.TaskContextSupplier;
import org.apache.hudi.common.model.HoodieBaseFile;
import org.apache.hudi.common.model.HoodieRecord;
import org.apache.hudi.common.model.WriteOperationType;
import org.apache.hudi.common.util.Option;
import org.apache.hudi.config.HoodieWriteConfig;
import org.apache.hudi.io.HoodieConcatHandle;
import org.apache.hudi.io.HoodieMergeHandle;
import org.apache.hudi.io.HoodieMergeHandleWithChangeLog;
import org.apache.hudi.io.HoodieSortedMergeHandle;
import org.apache.hudi.io.HoodieSortedMergeHandleWithChangeLog;
import org.apache.hudi.keygen.BaseKeyGenerator;
import org.apache.hudi.table.HoodieTable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HoodieMergeHandleFactory {
    private static final Logger LOG = LoggerFactory.getLogger(HoodieMergeHandleFactory.class);

    public static <T, I, K, O> HoodieMergeHandle<T, I, K, O> create(WriteOperationType operationType, HoodieWriteConfig writeConfig, String instantTime, HoodieTable<T, I, K, O> table, Iterator<HoodieRecord<T>> recordItr, String partitionPath, String fileId, TaskContextSupplier taskContextSupplier, Option<BaseKeyGenerator> keyGeneratorOpt) {
        LOG.info("Create update handle for fileId {} and partition path {} at commit {}", new Object[]{fileId, partitionPath, instantTime});
        if (table.requireSortedRecords()) {
            if (table.getMetaClient().getTableConfig().isCDCEnabled()) {
                return new HoodieSortedMergeHandleWithChangeLog<T, I, K, O>(writeConfig, instantTime, table, recordItr, partitionPath, fileId, taskContextSupplier, keyGeneratorOpt);
            }
            return new HoodieSortedMergeHandle<T, I, K, O>(writeConfig, instantTime, table, recordItr, partitionPath, fileId, taskContextSupplier, keyGeneratorOpt);
        }
        if (!WriteOperationType.isChangingRecords(operationType) && writeConfig.allowDuplicateInserts()) {
            return new HoodieConcatHandle<T, I, K, O>(writeConfig, instantTime, table, recordItr, partitionPath, fileId, taskContextSupplier, keyGeneratorOpt);
        }
        if (table.getMetaClient().getTableConfig().isCDCEnabled()) {
            return new HoodieMergeHandleWithChangeLog<T, I, K, O>(writeConfig, instantTime, table, recordItr, partitionPath, fileId, taskContextSupplier, keyGeneratorOpt);
        }
        return new HoodieMergeHandle<T, I, K, O>(writeConfig, instantTime, table, recordItr, partitionPath, fileId, taskContextSupplier, keyGeneratorOpt);
    }

    public static <T, I, K, O> HoodieMergeHandle<T, I, K, O> create(HoodieWriteConfig writeConfig, String instantTime, HoodieTable<T, I, K, O> table, Map<String, HoodieRecord<T>> keyToNewRecords, String partitionPath, String fileId, HoodieBaseFile dataFileToBeMerged, TaskContextSupplier taskContextSupplier, Option<BaseKeyGenerator> keyGeneratorOpt) {
        LOG.info("Get updateHandle for fileId {} and partitionPath {} at commit {}", new Object[]{fileId, partitionPath, instantTime});
        if (table.requireSortedRecords()) {
            return new HoodieSortedMergeHandle<T, I, K, O>(writeConfig, instantTime, table, keyToNewRecords, partitionPath, fileId, dataFileToBeMerged, taskContextSupplier, keyGeneratorOpt);
        }
        if (table.getMetaClient().getTableConfig().isCDCEnabled() && writeConfig.isYieldingPureLogForMor()) {
            return new HoodieMergeHandleWithChangeLog<T, I, K, O>(writeConfig, instantTime, table, keyToNewRecords, partitionPath, fileId, dataFileToBeMerged, taskContextSupplier, keyGeneratorOpt);
        }
        return new HoodieMergeHandle<T, I, K, O>(writeConfig, instantTime, table, keyToNewRecords, partitionPath, fileId, dataFileToBeMerged, taskContextSupplier, keyGeneratorOpt);
    }
}

