/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.data;

import java.io.Serializable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.hudi.common.data.HoodieData;
import org.apache.hudi.common.data.HoodiePairData;
import org.apache.hudi.common.function.SerializableBiFunction;
import org.apache.hudi.common.function.SerializableFunction;
import org.apache.hudi.common.function.SerializablePairFunction;
import org.apache.hudi.common.util.Option;
import org.apache.hudi.common.util.collection.ImmutablePair;
import org.apache.hudi.common.util.collection.Pair;
import org.apache.hudi.data.HoodieJavaRDD;
import org.apache.spark.Partitioner;
import org.apache.spark.api.java.JavaPairRDD;
import org.apache.spark.api.java.JavaRDD;
import org.apache.spark.api.java.Optional;
import org.apache.spark.api.java.function.Function;
import org.apache.spark.api.java.function.PairFunction;
import org.apache.spark.sql.internal.SQLConf;
import org.apache.spark.storage.StorageLevel;
import scala.Tuple2;

public class HoodieJavaPairRDD<K, V>
implements HoodiePairData<K, V> {
    private final JavaPairRDD<K, V> pairRDDData;

    private HoodieJavaPairRDD(JavaPairRDD<K, V> pairRDDData) {
        this.pairRDDData = pairRDDData;
    }

    public static <K, V> HoodieJavaPairRDD<K, V> of(JavaPairRDD<K, V> pairRDDData) {
        return new HoodieJavaPairRDD<K, V>(pairRDDData);
    }

    public static <K, V> JavaPairRDD<K, V> getJavaPairRDD(HoodiePairData<K, V> hoodiePairData) {
        return ((HoodieJavaPairRDD)hoodiePairData).get();
    }

    public JavaPairRDD<K, V> get() {
        return this.pairRDDData;
    }

    @Override
    public void persist(String storageLevel) {
        this.pairRDDData.persist(StorageLevel.fromString((String)storageLevel));
    }

    @Override
    public void unpersist() {
        this.pairRDDData.unpersist();
    }

    @Override
    public HoodieData<K> keys() {
        return HoodieJavaRDD.of(this.pairRDDData.keys());
    }

    @Override
    public HoodieData<V> values() {
        return HoodieJavaRDD.of(this.pairRDDData.values());
    }

    @Override
    public long count() {
        return this.pairRDDData.count();
    }

    @Override
    public Map<K, Long> countByKey() {
        return this.pairRDDData.countByKey();
    }

    @Override
    public HoodiePairData<K, Iterable<V>> groupByKey() {
        return new HoodieJavaPairRDD<K, V>(this.pairRDDData.groupByKey());
    }

    @Override
    public HoodiePairData<K, V> reduceByKey(SerializableBiFunction<V, V, V> combiner, int parallelism) {
        return HoodieJavaPairRDD.of(this.pairRDDData.reduceByKey(combiner::apply, parallelism));
    }

    @Override
    public <O> HoodieData<O> map(SerializableFunction<Pair<K, V>, O> func) {
        return HoodieJavaRDD.of(this.pairRDDData.map((Function & Serializable)tuple -> func.apply(new ImmutablePair<Object, Object>(tuple._1, tuple._2))));
    }

    @Override
    public <W> HoodiePairData<K, W> mapValues(SerializableFunction<V, W> func) {
        return HoodieJavaPairRDD.of(this.pairRDDData.mapValues(func::apply));
    }

    @Override
    public <W> HoodiePairData<K, W> flatMapValues(SerializableFunction<V, Iterator<W>> func) {
        return HoodieJavaPairRDD.of(this.pairRDDData.flatMapValues(func::apply));
    }

    @Override
    public <L, W> HoodiePairData<L, W> mapToPair(SerializablePairFunction<Pair<K, V>, L, W> mapToPairFunc) {
        return HoodieJavaPairRDD.of(this.pairRDDData.mapToPair((PairFunction & Serializable)pair -> {
            Pair newPair = mapToPairFunc.call(new ImmutablePair<Object, Object>(pair._1, pair._2));
            return new Tuple2(newPair.getLeft(), newPair.getRight());
        }));
    }

    @Override
    public <W> HoodiePairData<K, Pair<V, Option<W>>> leftOuterJoin(HoodiePairData<K, W> other) {
        return HoodieJavaPairRDD.of(JavaPairRDD.fromJavaRDD((JavaRDD)this.pairRDDData.leftOuterJoin(HoodieJavaPairRDD.getJavaPairRDD(other)).map((Function & Serializable)tuple -> new Tuple2(tuple._1, new ImmutablePair<Object, Option<Object>>(((Tuple2)tuple._2)._1, Option.ofNullable(((Optional)((Tuple2)tuple._2)._2).orElse(null)))))));
    }

    @Override
    public HoodiePairData<K, V> union(HoodiePairData<K, V> other) {
        return HoodieJavaPairRDD.of(this.pairRDDData.union(HoodieJavaPairRDD.getJavaPairRDD(other)));
    }

    @Override
    public List<Pair<K, V>> collectAsList() {
        return this.pairRDDData.map((Function & Serializable)t -> Pair.of(t._1, t._2)).collect();
    }

    @Override
    public int deduceNumPartitions() {
        int partPartitions;
        Optional partitioner = this.pairRDDData.partitioner();
        if (partitioner.isPresent() && (partPartitions = ((Partitioner)partitioner.get()).numPartitions()) > 0) {
            return partPartitions;
        }
        if (SQLConf.get().contains(SQLConf.SHUFFLE_PARTITIONS().key())) {
            return Integer.parseInt(SQLConf.get().getConfString(SQLConf.SHUFFLE_PARTITIONS().key()));
        }
        if (this.pairRDDData.context().conf().contains("spark.default.parallelism")) {
            return this.pairRDDData.context().defaultParallelism();
        }
        return this.pairRDDData.getNumPartitions();
    }
}

