/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.common.util;

import java.io.IOException;
import java.io.RandomAccessFile;
import org.apache.avro.Schema;
import org.apache.avro.generic.GenericData;
import org.apache.avro.generic.GenericRecord;
import org.apache.hudi.avro.HoodieAvroUtils;
import org.apache.hudi.common.fs.SizeAwareDataOutputStream;
import org.apache.hudi.common.model.HoodieAvroRecord;
import org.apache.hudi.common.model.HoodieKey;
import org.apache.hudi.common.model.HoodieOperation;
import org.apache.hudi.common.model.HoodieRecord;
import org.apache.hudi.common.util.BinaryUtil;
import org.apache.hudi.common.util.HoodieRecordUtils;
import org.apache.hudi.common.util.Option;
import org.apache.hudi.common.util.SizeEstimator;
import org.apache.hudi.common.util.StringUtils;
import org.apache.hudi.common.util.collection.BitCaskDiskMap;
import org.apache.hudi.common.util.collection.Pair;
import org.apache.hudi.exception.HoodieCorruptedDataException;

public class SpillableMapUtils {
    public static byte[] readBytesFromDisk(RandomAccessFile file, long valuePosition, int valueLength) throws IOException {
        BitCaskDiskMap.FileEntry fileEntry = SpillableMapUtils.readInternal(file, valuePosition, valueLength);
        return fileEntry.getValue();
    }

    private static BitCaskDiskMap.FileEntry readInternal(RandomAccessFile file, long valuePosition, int valueLength) throws IOException {
        file.seek(valuePosition);
        long crc = file.readLong();
        long timestamp = file.readLong();
        int keySize = file.readInt();
        int valueSize = file.readInt();
        byte[] key = new byte[keySize];
        file.readFully(key, 0, keySize);
        byte[] value = new byte[valueSize];
        if (valueSize != valueLength) {
            throw new HoodieCorruptedDataException("unequal size of payload written to external file, data may be corrupted");
        }
        file.readFully(value, 0, valueSize);
        long crcOfReadValue = BinaryUtil.generateChecksum(value);
        if (crc != crcOfReadValue) {
            throw new HoodieCorruptedDataException("checksum of payload written to external disk does not match, data may be corrupted");
        }
        return new BitCaskDiskMap.FileEntry(crc, keySize, valueSize, key, value, timestamp);
    }

    public static long spillToDisk(SizeAwareDataOutputStream outputStream, BitCaskDiskMap.FileEntry fileEntry) throws IOException {
        return SpillableMapUtils.spill(outputStream, fileEntry);
    }

    private static long spill(SizeAwareDataOutputStream outputStream, BitCaskDiskMap.FileEntry fileEntry) throws IOException {
        outputStream.writeLong(fileEntry.getCrc());
        outputStream.writeLong(fileEntry.getTimestamp());
        outputStream.writeInt(fileEntry.getSizeOfKey());
        outputStream.writeInt(fileEntry.getSizeOfValue());
        outputStream.write(fileEntry.getKey());
        outputStream.write(fileEntry.getValue());
        return outputStream.getSize();
    }

    public static <R> long computePayloadSize(R value, SizeEstimator<R> valueSizeEstimator) throws IOException {
        return valueSizeEstimator.sizeEstimate(value);
    }

    public static <R> HoodieRecord<R> convertToHoodieRecordPayload(GenericRecord rec, String payloadClazz, String preCombineField, boolean withOperationField) {
        return SpillableMapUtils.convertToHoodieRecordPayload(rec, payloadClazz, preCombineField, Pair.of(HoodieRecord.RECORD_KEY_METADATA_FIELD, HoodieRecord.PARTITION_PATH_METADATA_FIELD), withOperationField, Option.empty(), Option.empty());
    }

    public static <R> HoodieRecord<R> convertToHoodieRecordPayload(GenericRecord record, String payloadClazz, String preCombineField, boolean withOperationField, Option<String> partitionName, Option<Schema> schemaWithoutMetaFields) {
        return SpillableMapUtils.convertToHoodieRecordPayload(record, payloadClazz, preCombineField, Pair.of(HoodieRecord.RECORD_KEY_METADATA_FIELD, HoodieRecord.PARTITION_PATH_METADATA_FIELD), withOperationField, partitionName, schemaWithoutMetaFields);
    }

    public static <R> HoodieRecord<R> convertToHoodieRecordPayload(GenericRecord record, String payloadClazz, String preCombineField, Pair<String, String> recordKeyPartitionPathFieldPair, boolean withOperationField, Option<String> partitionName, Option<Schema> schemaWithoutMetaFields) {
        HoodieOperation operation;
        String recKey = record.get(recordKeyPartitionPathFieldPair.getKey()).toString();
        String partitionPath = partitionName.isPresent() ? partitionName.get() : record.get(recordKeyPartitionPathFieldPair.getRight()).toString();
        Object preCombineVal = SpillableMapUtils.getPreCombineVal(record, preCombineField);
        HoodieOperation hoodieOperation = operation = withOperationField ? HoodieOperation.fromName(HoodieAvroUtils.getNullableValAsString(record, HoodieRecord.OPERATION_METADATA_FIELD)) : null;
        if (schemaWithoutMetaFields.isPresent()) {
            Schema schema = schemaWithoutMetaFields.get();
            GenericData.Record recordWithoutMetaFields = new GenericData.Record(schema);
            for (Schema.Field f : schema.getFields()) {
                recordWithoutMetaFields.put(f.name(), record.get(f.name()));
            }
            record = recordWithoutMetaFields;
        }
        HoodieAvroRecord hoodieRecord = new HoodieAvroRecord(new HoodieKey(recKey, partitionPath), HoodieRecordUtils.loadPayload(payloadClazz, new Object[]{record, preCombineVal}, GenericRecord.class, Comparable.class), operation);
        return hoodieRecord;
    }

    private static Object getPreCombineVal(GenericRecord rec, String preCombineField) {
        if (StringUtils.isNullOrEmpty(preCombineField)) {
            return 0;
        }
        Schema.Field field = rec.getSchema().getField(preCombineField);
        return field == null ? Integer.valueOf(0) : rec.get(field.pos());
    }

    public static <R> R generateEmptyPayload(String recKey, String partitionPath, Comparable orderingVal, String payloadClazz) {
        HoodieAvroRecord hoodieRecord = new HoodieAvroRecord(new HoodieKey(recKey, partitionPath), HoodieRecordUtils.loadPayload(payloadClazz, new Object[]{null, orderingVal}, GenericRecord.class, Comparable.class));
        return (R)hoodieRecord;
    }
}

