/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.common.table.view;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.Serializable;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.regex.Matcher;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.hudi.avro.model.HoodieCompactionOperation;
import org.apache.hudi.common.bootstrap.index.BootstrapIndex;
import org.apache.hudi.common.fs.FSUtils;
import org.apache.hudi.common.model.BootstrapBaseFileMapping;
import org.apache.hudi.common.model.BootstrapFileMapping;
import org.apache.hudi.common.model.CompactionOperation;
import org.apache.hudi.common.model.FileSlice;
import org.apache.hudi.common.model.HoodieBaseFile;
import org.apache.hudi.common.model.HoodieFileFormat;
import org.apache.hudi.common.model.HoodieFileGroup;
import org.apache.hudi.common.model.HoodieFileGroupId;
import org.apache.hudi.common.model.HoodieLogFile;
import org.apache.hudi.common.model.HoodieReplaceCommitMetadata;
import org.apache.hudi.common.table.HoodieTableMetaClient;
import org.apache.hudi.common.table.HoodieTableVersion;
import org.apache.hudi.common.table.timeline.CompletionTimeQueryView;
import org.apache.hudi.common.table.timeline.HoodieInstant;
import org.apache.hudi.common.table.timeline.HoodieTimeline;
import org.apache.hudi.common.table.timeline.InstantComparison;
import org.apache.hudi.common.table.view.SyncableFileSystemView;
import org.apache.hudi.common.util.ClusteringUtils;
import org.apache.hudi.common.util.CompactionUtils;
import org.apache.hudi.common.util.HoodieTimer;
import org.apache.hudi.common.util.Option;
import org.apache.hudi.common.util.ValidationUtils;
import org.apache.hudi.common.util.collection.Pair;
import org.apache.hudi.exception.HoodieException;
import org.apache.hudi.exception.HoodieIOException;
import org.apache.hudi.storage.StoragePath;
import org.apache.hudi.storage.StoragePathInfo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractTableFileSystemView
implements SyncableFileSystemView,
Serializable {
    private static final Logger LOG = LoggerFactory.getLogger(AbstractTableFileSystemView.class);
    protected HoodieTableMetaClient metaClient;
    protected CompletionTimeQueryView completionTimeQueryView;
    private HoodieTimeline visibleCommitsAndCompactionTimeline;
    private final ConcurrentHashMap<String, Boolean> addedPartitions = new ConcurrentHashMap(4096);
    private final ReentrantReadWriteLock globalLock = new ReentrantReadWriteLock();
    protected final ReentrantReadWriteLock.ReadLock readLock = this.globalLock.readLock();
    protected final ReentrantReadWriteLock.WriteLock writeLock = this.globalLock.writeLock();
    private BootstrapIndex bootstrapIndex;

    protected void init(HoodieTableMetaClient metaClient, HoodieTimeline visibleActiveTimeline) {
        this.metaClient = metaClient;
        this.completionTimeQueryView = metaClient.getTimelineLayout().getTimelineFactory().createCompletionTimeQueryView(metaClient);
        this.refreshTimeline(visibleActiveTimeline);
        this.resetFileGroupsReplaced(this.visibleCommitsAndCompactionTimeline);
        this.bootstrapIndex = BootstrapIndex.getBootstrapIndex(metaClient);
        this.resetPendingCompactionOperations(CompactionUtils.getAllPendingCompactionOperations(metaClient).values().stream().map(e -> Pair.of(e.getKey(), CompactionOperation.convertFromAvroRecordInstance((HoodieCompactionOperation)((Object)((Object)e.getValue()))))));
        this.resetPendingLogCompactionOperations(CompactionUtils.getAllPendingLogCompactionOperations(metaClient).values().stream().map(e -> Pair.of(e.getKey(), CompactionOperation.convertFromAvroRecordInstance((HoodieCompactionOperation)((Object)((Object)e.getValue()))))));
        this.resetBootstrapBaseFileMapping(Stream.empty());
        this.resetFileGroupsInPendingClustering(ClusteringUtils.getAllFileGroupsInPendingClusteringPlans(metaClient));
    }

    protected void refreshTimeline(HoodieTimeline visibleActiveTimeline) {
        this.visibleCommitsAndCompactionTimeline = visibleActiveTimeline.getWriteTimeline();
    }

    protected void refreshCompletionTimeQueryView() {
        this.completionTimeQueryView = this.metaClient.getTimelineLayout().getTimelineFactory().createCompletionTimeQueryView(this.metaClient);
    }

    public Option<String> getCompletionTime(String instantTime) {
        return this.completionTimeQueryView.getCompletionTime(instantTime, instantTime);
    }

    public List<HoodieFileGroup> addFilesToView(List<StoragePathInfo> statuses) {
        Map<String, List<StoragePathInfo>> statusesByPartitionPath = statuses.stream().collect(Collectors.groupingBy(fileStatus -> FSUtils.getRelativePartitionPath(this.metaClient.getBasePath(), fileStatus.getPath().getParent())));
        return statusesByPartitionPath.entrySet().stream().map(entry -> this.addFilesToView((String)entry.getKey(), (List)entry.getValue())).flatMap(Collection::stream).collect(Collectors.toList());
    }

    public List<HoodieFileGroup> addFilesToView(String partitionPath, List<StoragePathInfo> statuses) {
        HoodieTimer timer = HoodieTimer.start();
        List<HoodieFileGroup> fileGroups = this.buildFileGroups(partitionPath, statuses, this.visibleCommitsAndCompactionTimeline, true);
        long fgBuildTimeTakenMs = timer.endTimer();
        timer.startTimer();
        fileGroups.stream().collect(Collectors.groupingBy(HoodieFileGroup::getPartitionPath)).forEach((partition, value) -> {
            if (!this.isPartitionAvailableInStore((String)partition)) {
                if (this.bootstrapIndex.useIndex()) {
                    try (BootstrapIndex.IndexReader reader = this.bootstrapIndex.createReader();){
                        LOG.info("Bootstrap Index available for partition " + partition);
                        List<BootstrapFileMapping> sourceFileMappings = reader.getSourceFileMappingForPartition((String)partition);
                        this.addBootstrapBaseFileMapping(sourceFileMappings.stream().map(s -> new BootstrapBaseFileMapping(new HoodieFileGroupId(s.getPartitionPath(), s.getFileId()), s.getBootstrapFileStatus())));
                    }
                }
                this.storePartitionView((String)partition, (List<HoodieFileGroup>)value);
            }
        });
        long storePartitionsTs = timer.endTimer();
        LOG.debug("addFilesToView: NumFiles=" + statuses.size() + ", NumFileGroups=" + fileGroups.size() + ", FileGroupsCreationTime=" + fgBuildTimeTakenMs + ", StoreTimeTaken=" + storePartitionsTs);
        return fileGroups;
    }

    protected List<HoodieFileGroup> buildFileGroups(String partition, List<StoragePathInfo> statuses, HoodieTimeline timeline, boolean addPendingCompactionFileSlice) {
        return this.buildFileGroups(partition, this.convertFileStatusesToBaseFiles(statuses), this.convertFileStatusesToLogFiles(statuses), timeline, addPendingCompactionFileSlice);
    }

    protected List<HoodieFileGroup> buildFileGroups(String partition, Stream<HoodieBaseFile> baseFileStream, Stream<HoodieLogFile> logFileStream, HoodieTimeline timeline, boolean addPendingCompactionFileSlice) {
        Map<String, List<HoodieBaseFile>> baseFiles = baseFileStream.collect(Collectors.groupingBy(HoodieBaseFile::getFileId));
        Map<String, List<HoodieLogFile>> logFiles = logFileStream.collect(Collectors.groupingBy(HoodieLogFile::getFileId));
        HashSet<String> fileIdSet = new HashSet<String>(baseFiles.keySet());
        fileIdSet.addAll(logFiles.keySet());
        ArrayList<HoodieFileGroup> fileGroups = new ArrayList<HoodieFileGroup>(fileIdSet.size());
        fileIdSet.forEach(fileId -> {
            Option<Pair<String, CompactionOperation>> pendingCompaction;
            HoodieFileGroup group = new HoodieFileGroup(partition, (String)fileId, timeline);
            if (baseFiles.containsKey(fileId)) {
                ((List)baseFiles.get(fileId)).forEach(group::addBaseFile);
            }
            if (addPendingCompactionFileSlice && (pendingCompaction = this.getPendingCompactionOperationWithInstant(group.getFileGroupId())).isPresent()) {
                group.addNewFileSliceAtInstant(pendingCompaction.get().getKey());
            }
            if (logFiles.containsKey(fileId)) {
                ((List)logFiles.get(fileId)).stream().sorted(HoodieLogFile.getLogFileComparator()).forEach(logFile -> group.addLogFile(this.completionTimeQueryView, (HoodieLogFile)logFile));
            }
            fileGroups.add(group);
        });
        return fileGroups;
    }

    private boolean tableVersion8AndAbove() {
        HoodieTableVersion tableVersion = this.metaClient.getTableConfig().getTableVersion();
        return tableVersion.greaterThanOrEquals(HoodieTableVersion.EIGHT);
    }

    private void resetFileGroupsReplaced(HoodieTimeline timeline) {
        HoodieTimer hoodieTimer = HoodieTimer.start();
        HoodieTimeline replacedTimeline = timeline.getCompletedReplaceTimeline();
        Stream<Map<HoodieFileGroupId, HoodieInstant>> resultStream = replacedTimeline.getInstantsAsStream().flatMap(instant -> {
            try {
                HoodieReplaceCommitMetadata replaceMetadata = HoodieReplaceCommitMetadata.fromBytes(this.metaClient.getActiveTimeline().getInstantDetails((HoodieInstant)instant).get(), HoodieReplaceCommitMetadata.class);
                return replaceMetadata.getPartitionToReplaceFileIds().entrySet().stream().flatMap(entry -> ((List)entry.getValue()).stream().map(e -> new AbstractMap.SimpleEntry<HoodieFileGroupId, HoodieInstant>(new HoodieFileGroupId((String)entry.getKey(), (String)e), (HoodieInstant)instant)));
            }
            catch (HoodieIOException ex) {
                if (ex.getIOException() instanceof FileNotFoundException) {
                    LOG.warn(ex.getMessage());
                    return Stream.empty();
                }
                throw ex;
            }
            catch (IOException e) {
                throw new HoodieIOException("error reading commit metadata for " + instant, e);
            }
        });
        Map<HoodieFileGroupId, HoodieInstant> replacedFileGroups = resultStream.collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue, (instance1, instance2) -> InstantComparison.compareTimestamps(instance1.requestedTime(), InstantComparison.LESSER_THAN, instance2.requestedTime()) ? instance2 : instance1));
        this.resetReplacedFileGroups(replacedFileGroups);
        LOG.info("Took " + hoodieTimer.endTimer() + " ms to read  " + replacedTimeline.countInstants() + " instants, " + replacedFileGroups.size() + " replaced file groups");
    }

    @Override
    public void close() {
        try {
            this.writeLock.lock();
            this.metaClient = null;
            this.completionTimeQueryView = null;
            this.visibleCommitsAndCompactionTimeline = null;
            this.clear();
        }
        finally {
            this.writeLock.unlock();
        }
    }

    @Override
    public void reset() {
        try {
            this.writeLock.lock();
            this.clear();
            this.init(this.metaClient, this.getTimeline());
        }
        finally {
            this.writeLock.unlock();
        }
    }

    protected void clear() {
        this.addedPartitions.clear();
        this.resetViewState();
        this.bootstrapIndex = null;
    }

    protected abstract void resetViewState();

    private List<String> ensureAllPartitionsLoadedCorrectly() {
        ValidationUtils.checkArgument(!this.isClosed(), "View is already closed");
        try {
            List<String> formattedPartitionList = this.getAllPartitionPaths().stream().map(this::formatPartitionKey).collect(Collectors.toList());
            this.ensurePartitionsLoadedCorrectly(formattedPartitionList);
            return formattedPartitionList;
        }
        catch (IOException e) {
            throw new HoodieIOException("Failed to get all partition paths", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void ensurePartitionsLoadedCorrectly(List<String> partitionList) {
        ValidationUtils.checkArgument(!this.isClosed(), "View is already closed");
        HashSet partitionSet = new HashSet();
        ConcurrentHashMap<String, Boolean> concurrentHashMap = this.addedPartitions;
        synchronized (concurrentHashMap) {
            partitionList.forEach(partition -> {
                if (!this.addedPartitions.containsKey(partition) && !this.isPartitionAvailableInStore((String)partition)) {
                    partitionSet.add(partition);
                }
            });
            if (!partitionSet.isEmpty()) {
                long beginTs = System.currentTimeMillis();
                try {
                    LOG.debug("Building file system view for partitions: " + partitionSet);
                    List<Pair<String, StoragePath>> absolutePartitionPathList = partitionSet.stream().map(partition -> Pair.of(partition, FSUtils.constructAbsolutePath(this.metaClient.getBasePath(), partition))).collect(Collectors.toList());
                    long beginLsTs = System.currentTimeMillis();
                    Map<Pair<String, StoragePath>, List<StoragePathInfo>> pathInfoMap = this.listPartitions(absolutePartitionPathList);
                    long endLsTs = System.currentTimeMillis();
                    LOG.debug("Time taken to list partitions " + partitionSet + " =" + (endLsTs - beginLsTs));
                    pathInfoMap.forEach((partitionPair, statuses) -> {
                        String relativePartitionStr = (String)partitionPair.getLeft();
                        List<HoodieFileGroup> groups2 = this.addFilesToView(relativePartitionStr, (List<StoragePathInfo>)statuses);
                        if (groups2.isEmpty()) {
                            this.storePartitionView(relativePartitionStr, Collections.emptyList());
                        }
                        LOG.debug("#files found in partition (" + relativePartitionStr + ") =" + statuses.size());
                    });
                }
                catch (IOException e) {
                    throw new HoodieIOException("Failed to list base files in partitions " + partitionSet, e);
                }
                long endTs = System.currentTimeMillis();
                LOG.debug("Time to load partition " + partitionSet + " =" + (endTs - beginTs));
            }
            partitionSet.forEach(partition -> this.addedPartitions.computeIfAbsent((String)partition, partitionPathStr -> true));
        }
    }

    protected List<String> getAllPartitionPaths() throws IOException {
        throw new HoodieException("Getting all partition paths with file system listing sequentially can be very slow. This should not be invoked.");
    }

    protected Map<Pair<String, StoragePath>, List<StoragePathInfo>> listPartitions(List<Pair<String, StoragePath>> partitionPathList) throws IOException {
        HashMap<Pair<String, StoragePath>, List<StoragePathInfo>> pathInfoMap = new HashMap<Pair<String, StoragePath>, List<StoragePathInfo>>();
        for (Pair<String, StoragePath> partitionPair : partitionPathList) {
            StoragePath absolutePartitionPath = partitionPair.getRight();
            try {
                pathInfoMap.put(partitionPair, this.metaClient.getStorage().listDirectEntries(absolutePartitionPath));
            }
            catch (IOException e) {
                if (!this.metaClient.getStorage().exists(absolutePartitionPath)) {
                    pathInfoMap.put(partitionPair, Collections.emptyList());
                    continue;
                }
                pathInfoMap.put(partitionPair, this.metaClient.getStorage().listDirectEntries(absolutePartitionPath));
            }
        }
        return pathInfoMap;
    }

    private List<StoragePathInfo> getAllFilesInPartition(String relativePartitionPath) throws IOException {
        StoragePath partitionPath = FSUtils.constructAbsolutePath(this.metaClient.getBasePath(), relativePartitionPath);
        long beginLsTs = System.currentTimeMillis();
        List<StoragePathInfo> pathInfoList = this.listPartition(partitionPath);
        long endLsTs = System.currentTimeMillis();
        LOG.debug("#files found in partition (" + relativePartitionPath + ") =" + pathInfoList.size() + ", Time taken =" + (endLsTs - beginLsTs));
        return pathInfoList;
    }

    protected void ensurePartitionLoadedCorrectly(String partition) {
        ValidationUtils.checkArgument(!this.isClosed(), "View is already closed");
        this.addedPartitions.computeIfAbsent(partition, this::lambda$ensurePartitionLoadedCorrectly$17);
    }

    protected List<StoragePathInfo> listPartition(StoragePath partitionPath) throws IOException {
        try {
            return this.metaClient.getStorage().listDirectEntries(partitionPath);
        }
        catch (IOException e) {
            if (!this.metaClient.getStorage().exists(partitionPath)) {
                return Collections.emptyList();
            }
            return this.metaClient.getStorage().listDirectEntries(partitionPath);
        }
    }

    private Stream<HoodieBaseFile> convertFileStatusesToBaseFiles(List<StoragePathInfo> pathInfoList) {
        Predicate<StoragePathInfo> roFilePredicate = pathInfo -> {
            String pathName = pathInfo.getPath().getName();
            if (pathName.startsWith(".hoodie_partition_metadata")) {
                return false;
            }
            if (this.metaClient.getTableConfig().isMultipleBaseFileFormatsEnabled()) {
                return pathName.contains(HoodieFileFormat.PARQUET.getFileExtension()) || pathName.contains(HoodieFileFormat.ORC.getFileExtension());
            }
            return pathName.contains(this.metaClient.getTableConfig().getBaseFileFormat().getFileExtension());
        };
        return pathInfoList.stream().filter(roFilePredicate).map(HoodieBaseFile::new);
    }

    private Stream<HoodieLogFile> convertFileStatusesToLogFiles(List<StoragePathInfo> pathInfoList) {
        Predicate<StoragePathInfo> rtFilePredicate = pathInfo -> {
            String fileName = pathInfo.getPath().getName();
            Matcher matcher = FSUtils.LOG_FILE_PATTERN.matcher(fileName);
            return matcher.find() && fileName.contains(this.metaClient.getTableConfig().getLogFileFormat().getFileExtension());
        };
        return pathInfoList.stream().filter(rtFilePredicate).map(HoodieLogFile::new);
    }

    protected boolean isBaseFileDueToPendingCompaction(String partitionPath, HoodieBaseFile baseFile) {
        Option<Pair<String, CompactionOperation>> compactionWithInstantTime = this.getPendingCompactionOperationWithInstant(new HoodieFileGroupId(partitionPath, baseFile.getFileId()));
        return compactionWithInstantTime.isPresent() && null != compactionWithInstantTime.get().getKey() && baseFile.getCommitTime().equals(compactionWithInstantTime.get().getKey());
    }

    protected boolean isBaseFileDueToPendingClustering(HoodieBaseFile baseFile) {
        return this.metaClient.getActiveTimeline().isPendingClusteringInstant(baseFile.getCommitTime());
    }

    private boolean isFileSliceAfterPendingCompaction(FileSlice fileSlice) {
        Option<Pair<String, CompactionOperation>> compactionWithInstantTime = this.getPendingCompactionOperationWithInstant(fileSlice.getFileGroupId());
        return compactionWithInstantTime.isPresent() && fileSlice.getBaseInstantTime().equals(compactionWithInstantTime.get().getKey());
    }

    protected Stream<FileSlice> filterBaseFileAfterPendingCompaction(FileSlice fileSlice, boolean includeEmptyFileSlice) {
        if (this.isFileSliceAfterPendingCompaction(fileSlice)) {
            LOG.debug("File Slice (" + fileSlice + ") is in pending compaction");
            FileSlice transformed = new FileSlice(fileSlice.getPartitionPath(), fileSlice.getBaseInstantTime(), fileSlice.getFileId());
            fileSlice.getLogFiles().forEach(transformed::addLogFile);
            if (transformed.isEmpty() && !includeEmptyFileSlice) {
                return Stream.of(new FileSlice[0]);
            }
            return Stream.of(transformed);
        }
        return Stream.of(fileSlice);
    }

    private Stream<FileSlice> filterUncommittedFiles(FileSlice fileSlice, boolean includeEmptyFileSlice) {
        Option<HoodieBaseFile> committedBaseFile = fileSlice.getBaseFile().isPresent() && this.completionTimeQueryView.isCompleted(fileSlice.getBaseInstantTime()) ? fileSlice.getBaseFile() : Option.empty();
        List<HoodieLogFile> committedLogFiles = fileSlice.getLogFiles().filter(logFile -> this.completionTimeQueryView.isCompleted(logFile.getDeltaCommitTime())).collect(Collectors.toList());
        if (fileSlice.getBaseFile().isPresent() && !committedBaseFile.isPresent() || (long)committedLogFiles.size() != fileSlice.getLogFiles().count()) {
            LOG.debug("File Slice ({}) has uncommitted files.", (Object)fileSlice);
            FileSlice transformed = new FileSlice(fileSlice.getPartitionPath(), fileSlice.getBaseInstantTime(), fileSlice.getFileId());
            committedBaseFile.ifPresent(transformed::setBaseFile);
            committedLogFiles.forEach(transformed::addLogFile);
            if (transformed.isEmpty() && !includeEmptyFileSlice) {
                return Stream.of(new FileSlice[0]);
            }
            return Stream.of(transformed);
        }
        return Stream.of(fileSlice);
    }

    private FileSlice filterUncommittedLogs(FileSlice fileSlice) {
        List<HoodieLogFile> committedLogFiles = fileSlice.getLogFiles().filter(logFile -> this.completionTimeQueryView.isCompleted(logFile.getDeltaCommitTime())).collect(Collectors.toList());
        if ((long)committedLogFiles.size() != fileSlice.getLogFiles().count()) {
            LOG.debug("File Slice (" + fileSlice + ") has uncommitted log files.");
            FileSlice transformed = new FileSlice(fileSlice.getPartitionPath(), fileSlice.getBaseInstantTime(), fileSlice.getFileId());
            fileSlice.getBaseFile().ifPresent(transformed::setBaseFile);
            committedLogFiles.forEach(transformed::addLogFile);
            return transformed;
        }
        return fileSlice;
    }

    protected HoodieFileGroup addBootstrapBaseFileIfPresent(HoodieFileGroup fileGroup) {
        return this.addBootstrapBaseFileIfPresent(fileGroup, this::getBootstrapBaseFile);
    }

    protected HoodieFileGroup addBootstrapBaseFileIfPresent(HoodieFileGroup fileGroup, Function<HoodieFileGroupId, Option<BootstrapBaseFileMapping>> bootstrapBaseFileMappingFunc) {
        boolean hasBootstrapBaseFile = fileGroup.getAllFileSlices().anyMatch(fs -> fs.getBaseInstantTime().equals("00000000000001"));
        if (hasBootstrapBaseFile) {
            HoodieFileGroup newFileGroup = new HoodieFileGroup(fileGroup);
            newFileGroup.getAllFileSlices().filter(fs -> fs.getBaseInstantTime().equals("00000000000001")).forEach(fs -> fs.setBaseFile(this.addBootstrapBaseFileIfPresent(fs.getFileGroupId(), fs.getBaseFile().get(), bootstrapBaseFileMappingFunc)));
            return newFileGroup;
        }
        return fileGroup;
    }

    protected FileSlice addBootstrapBaseFileIfPresent(FileSlice fileSlice) {
        return this.addBootstrapBaseFileIfPresent(fileSlice, this::getBootstrapBaseFile);
    }

    protected FileSlice addBootstrapBaseFileIfPresent(FileSlice fileSlice, Function<HoodieFileGroupId, Option<BootstrapBaseFileMapping>> bootstrapBaseFileMappingFunc) {
        if (fileSlice.getBaseInstantTime().equals("00000000000001")) {
            FileSlice copy = new FileSlice(fileSlice);
            copy.getBaseFile().ifPresent(dataFile -> {
                Option<BootstrapBaseFileMapping> edf = this.getBootstrapBaseFile(copy.getFileGroupId());
                ((Option)bootstrapBaseFileMappingFunc.apply(copy.getFileGroupId())).ifPresent(e -> dataFile.setBootstrapBaseFile(e.getBootstrapBaseFile()));
            });
            return copy;
        }
        return fileSlice;
    }

    protected HoodieBaseFile addBootstrapBaseFileIfPresent(HoodieFileGroupId fileGroupId, HoodieBaseFile baseFile) {
        return this.addBootstrapBaseFileIfPresent(fileGroupId, baseFile, this::getBootstrapBaseFile);
    }

    protected HoodieBaseFile addBootstrapBaseFileIfPresent(HoodieFileGroupId fileGroupId, HoodieBaseFile baseFile, Function<HoodieFileGroupId, Option<BootstrapBaseFileMapping>> bootstrapBaseFileMappingFunc) {
        if (baseFile.getCommitTime().equals("00000000000001")) {
            HoodieBaseFile copy = new HoodieBaseFile(baseFile);
            bootstrapBaseFileMappingFunc.apply(fileGroupId).ifPresent(e -> copy.setBootstrapBaseFile(e.getBootstrapBaseFile()));
            return copy;
        }
        return baseFile;
    }

    @Override
    public final Stream<Pair<String, CompactionOperation>> getPendingCompactionOperations() {
        try {
            this.readLock.lock();
            Stream<Pair<String, CompactionOperation>> stream = this.fetchPendingCompactionOperations();
            return stream;
        }
        finally {
            this.readLock.unlock();
        }
    }

    public final List<StoragePath> getPartitionPaths() {
        try {
            this.readLock.lock();
            List<StoragePath> list = this.fetchAllStoredFileGroups().filter(fg -> !this.isFileGroupReplaced((HoodieFileGroup)fg)).map(HoodieFileGroup::getPartitionPath).distinct().map(name -> name.isEmpty() ? this.metaClient.getBasePath() : new StoragePath(this.metaClient.getBasePath(), (String)name)).collect(Collectors.toList());
            return list;
        }
        finally {
            this.readLock.unlock();
        }
    }

    public final List<String> getPartitionNames() {
        try {
            this.readLock.lock();
            List<String> list = this.fetchAllStoredFileGroups().filter(fg -> !this.isFileGroupReplaced((HoodieFileGroup)fg)).map(HoodieFileGroup::getPartitionPath).distinct().collect(Collectors.toList());
            return list;
        }
        finally {
            this.readLock.unlock();
        }
    }

    @Override
    public final Stream<Pair<String, CompactionOperation>> getPendingLogCompactionOperations() {
        try {
            this.readLock.lock();
            Stream<Pair<String, CompactionOperation>> stream = this.fetchPendingLogCompactionOperations();
            return stream;
        }
        finally {
            this.readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final Stream<HoodieBaseFile> getLatestBaseFiles(String partitionStr) {
        try {
            this.readLock.lock();
            String partitionPath = this.formatPartitionKey(partitionStr);
            this.ensurePartitionLoadedCorrectly(partitionPath);
            Stream<HoodieBaseFile> stream = this.fetchLatestBaseFiles(partitionPath).filter(df -> !this.isFileGroupReplaced(partitionPath, df.getFileId())).map(df -> this.addBootstrapBaseFileIfPresent(new HoodieFileGroupId(partitionPath, df.getFileId()), (HoodieBaseFile)df));
            return stream;
        }
        finally {
            this.readLock.unlock();
        }
    }

    @Override
    public final Stream<HoodieBaseFile> getLatestBaseFiles() {
        try {
            this.readLock.lock();
            Stream<HoodieBaseFile> stream = this.fetchLatestBaseFiles();
            return stream;
        }
        finally {
            this.readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final Stream<HoodieBaseFile> getLatestBaseFilesBeforeOrOn(String partitionStr, String maxCommitTime) {
        try {
            this.readLock.lock();
            String partitionPath = this.formatPartitionKey(partitionStr);
            this.ensurePartitionLoadedCorrectly(partitionPath);
            Stream<HoodieBaseFile> stream = this.getLatestBaseFilesBeforeOrOnFromCache(partitionPath, maxCommitTime);
            return stream;
        }
        finally {
            this.readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final Map<String, Stream<HoodieBaseFile>> getAllLatestBaseFilesBeforeOrOn(String maxCommitTime) {
        try {
            this.readLock.lock();
            List<String> formattedPartitionList = this.ensureAllPartitionsLoadedCorrectly();
            Map<String, Stream<HoodieBaseFile>> map = formattedPartitionList.stream().collect(Collectors.toMap(Function.identity(), partitionPath -> this.getLatestBaseFilesBeforeOrOnFromCache((String)partitionPath, maxCommitTime)));
            return map;
        }
        finally {
            this.readLock.unlock();
        }
    }

    private Stream<HoodieBaseFile> getLatestBaseFilesBeforeOrOnFromCache(String partitionPath, String maxCommitTime) {
        return this.fetchAllStoredFileGroups(partitionPath).filter(fileGroup -> !this.isFileGroupReplacedBeforeOrOn(fileGroup.getFileGroupId(), maxCommitTime)).map(fileGroup -> Option.fromJavaOptional(fileGroup.getAllBaseFiles().filter(baseFile -> InstantComparison.compareTimestamps(baseFile.getCommitTime(), InstantComparison.LESSER_THAN_OR_EQUALS, maxCommitTime)).filter(df -> !this.isBaseFileDueToPendingCompaction(partitionPath, (HoodieBaseFile)df) && !this.isBaseFileDueToPendingClustering((HoodieBaseFile)df)).findFirst())).filter(Option::isPresent).map(Option::get).map(df -> this.addBootstrapBaseFileIfPresent(new HoodieFileGroupId(partitionPath, df.getFileId()), (HoodieBaseFile)df));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final Option<HoodieBaseFile> getBaseFileOn(String partitionStr, String instantTime, String fileId) {
        try {
            this.readLock.lock();
            String partitionPath = this.formatPartitionKey(partitionStr);
            this.ensurePartitionLoadedCorrectly(partitionPath);
            if (this.isFileGroupReplacedBeforeOrOn(new HoodieFileGroupId(partitionPath, fileId), instantTime)) {
                Option<HoodieBaseFile> option = Option.empty();
                return option;
            }
            Option<HoodieBaseFile> option = this.fetchHoodieFileGroup(partitionPath, fileId).map(fileGroup -> fileGroup.getAllBaseFiles().filter(baseFile -> InstantComparison.compareTimestamps(baseFile.getCommitTime(), InstantComparison.EQUALS, instantTime)).filter(df -> !this.isBaseFileDueToPendingCompaction(partitionPath, (HoodieBaseFile)df) && !this.isBaseFileDueToPendingClustering((HoodieBaseFile)df)).findFirst().orElse(null)).map(df -> this.addBootstrapBaseFileIfPresent(new HoodieFileGroupId(partitionPath, fileId), (HoodieBaseFile)df));
            return option;
        }
        finally {
            this.readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final Option<HoodieBaseFile> getLatestBaseFile(String partitionStr, String fileId) {
        try {
            this.readLock.lock();
            String partitionPath = this.formatPartitionKey(partitionStr);
            this.ensurePartitionLoadedCorrectly(partitionPath);
            if (this.isFileGroupReplaced(partitionPath, fileId)) {
                Option<HoodieBaseFile> option = Option.empty();
                return option;
            }
            Option<HoodieBaseFile> option = this.fetchLatestBaseFile(partitionPath, fileId).map(df -> this.addBootstrapBaseFileIfPresent(new HoodieFileGroupId(partitionPath, fileId), (HoodieBaseFile)df));
            return option;
        }
        finally {
            this.readLock.unlock();
        }
    }

    @Override
    public final Stream<HoodieBaseFile> getLatestBaseFilesInRange(List<String> commitsToReturn) {
        try {
            this.readLock.lock();
            Stream<HoodieBaseFile> stream = this.fetchAllStoredFileGroups().filter(fileGroup -> !this.isFileGroupReplacedBeforeAny(fileGroup.getFileGroupId(), commitsToReturn)).map(fileGroup -> Pair.of(fileGroup.getFileGroupId(), Option.fromJavaOptional(fileGroup.getAllBaseFiles().filter(baseFile -> commitsToReturn.contains(baseFile.getCommitTime()) && !this.isBaseFileDueToPendingCompaction(fileGroup.getPartitionPath(), (HoodieBaseFile)baseFile) && !this.isBaseFileDueToPendingClustering((HoodieBaseFile)baseFile)).findFirst()))).filter(p -> ((Option)p.getValue()).isPresent()).map(p -> this.addBootstrapBaseFileIfPresent((HoodieFileGroupId)p.getKey(), (HoodieBaseFile)((Option)p.getValue()).get()));
            return stream;
        }
        finally {
            this.readLock.unlock();
        }
    }

    @Override
    public void loadAllPartitions() {
        try {
            this.readLock.lock();
            this.ensureAllPartitionsLoadedCorrectly();
        }
        finally {
            this.readLock.unlock();
        }
    }

    @Override
    public void loadPartitions(List<String> partitionPaths) {
        try {
            this.readLock.lock();
            this.ensurePartitionsLoadedCorrectly(partitionPaths);
        }
        finally {
            this.readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final Stream<HoodieBaseFile> getAllBaseFiles(String partitionStr) {
        try {
            this.readLock.lock();
            String partitionPath = this.formatPartitionKey(partitionStr);
            this.ensurePartitionLoadedCorrectly(partitionPath);
            Stream<HoodieBaseFile> stream = this.fetchAllBaseFiles(partitionPath).filter(df -> !this.isFileGroupReplaced(partitionPath, df.getFileId())).filter(df -> this.visibleCommitsAndCompactionTimeline.containsOrBeforeTimelineStarts(df.getCommitTime())).filter(df -> !this.isBaseFileDueToPendingCompaction(partitionPath, (HoodieBaseFile)df) && !this.isBaseFileDueToPendingClustering((HoodieBaseFile)df)).map(df -> this.addBootstrapBaseFileIfPresent(new HoodieFileGroupId(partitionPath, df.getFileId()), (HoodieBaseFile)df));
            return stream;
        }
        finally {
            this.readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final Stream<FileSlice> getLatestFileSlices(String partitionStr) {
        try {
            this.readLock.lock();
            String partitionPath = this.formatPartitionKey(partitionStr);
            this.ensurePartitionLoadedCorrectly(partitionPath);
            Stream<FileSlice> stream = this.fetchLatestFileSlices(partitionPath).filter(slice -> !this.isFileGroupReplaced(slice.getFileGroupId())).flatMap(slice -> this.tableVersion8AndAbove() ? this.filterUncommittedFiles((FileSlice)slice, true) : this.filterBaseFileAfterPendingCompaction((FileSlice)slice, true)).map(this::addBootstrapBaseFileIfPresent);
            return stream;
        }
        finally {
            this.readLock.unlock();
        }
    }

    @Override
    public Stream<FileSlice> getLatestFileSlicesIncludingInflight(String partitionPath) {
        try {
            this.readLock.lock();
            this.ensurePartitionLoadedCorrectly(partitionPath);
            Stream<FileSlice> stream = this.fetchAllStoredFileGroups(partitionPath).map(HoodieFileGroup::getLatestFileSlicesIncludingInflight).filter(Option::isPresent).map(Option::get);
            return stream;
        }
        finally {
            this.readLock.unlock();
        }
    }

    @Override
    public final Stream<FileSlice> getLatestFileSlicesStateless(String partitionStr) {
        String partition = this.formatPartitionKey(partitionStr);
        if (this.isPartitionAvailableInStore(partition)) {
            return this.getLatestFileSlices(partition);
        }
        try {
            Map<HoodieFileGroupId, BootstrapBaseFileMapping> bootstrapBaseFileMappings;
            Stream<FileSlice> fileSliceStream = this.buildFileGroups(partition, this.getAllFilesInPartition(partition), this.visibleCommitsAndCompactionTimeline, true).stream().filter(fg -> !this.isFileGroupReplaced((HoodieFileGroup)fg)).map(HoodieFileGroup::getLatestFileSlice).filter(Option::isPresent).map(Option::get).flatMap(slice -> this.tableVersion8AndAbove() ? this.filterUncommittedFiles((FileSlice)slice, true) : this.filterBaseFileAfterPendingCompaction((FileSlice)slice, true));
            if (this.bootstrapIndex.useIndex() && !(bootstrapBaseFileMappings = this.getBootstrapBaseFileMappings(partition)).isEmpty()) {
                return fileSliceStream.map(fileSlice -> this.addBootstrapBaseFileIfPresent((FileSlice)fileSlice, (HoodieFileGroupId fileGroupId) -> Option.ofNullable(bootstrapBaseFileMappings.get(fileGroupId))));
            }
            return fileSliceStream;
        }
        catch (IOException e) {
            throw new HoodieIOException("Failed to fetch all files in partition " + partition, e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final Option<FileSlice> getLatestFileSlice(String partitionStr, String fileId) {
        try {
            this.readLock.lock();
            String partitionPath = this.formatPartitionKey(partitionStr);
            this.ensurePartitionLoadedCorrectly(partitionPath);
            if (this.isFileGroupReplaced(partitionPath, fileId)) {
                Option<FileSlice> option = Option.empty();
                return option;
            }
            Option<FileSlice> fs = this.fetchLatestFileSlice(partitionPath, fileId);
            if (!fs.isPresent()) {
                Option<FileSlice> option = Option.empty();
                return option;
            }
            Stream<FileSlice> fileSlices = this.tableVersion8AndAbove() ? this.filterUncommittedFiles(fs.get(), true) : this.filterBaseFileAfterPendingCompaction(fs.get(), true);
            Option<Object> option = Option.ofNullable(fileSlices.map(this::addBootstrapBaseFileIfPresent).findFirst().orElse(null));
            return option;
        }
        finally {
            this.readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final Stream<FileSlice> getLatestUnCompactedFileSlices(String partitionStr) {
        try {
            this.readLock.lock();
            String partitionPath = this.formatPartitionKey(partitionStr);
            this.ensurePartitionLoadedCorrectly(partitionPath);
            Stream<FileSlice> stream = this.fetchAllStoredFileGroups(partitionPath).filter(fg -> !this.isFileGroupReplaced(fg.getFileGroupId())).map(fileGroup -> {
                FileSlice fileSlice = fileGroup.getLatestFileSlice().get();
                Option<Pair<String, CompactionOperation>> compactionWithInstantPair = this.getPendingCompactionOperationWithInstant(fileSlice.getFileGroupId());
                if (compactionWithInstantPair.isPresent()) {
                    String compactionInstantTime = compactionWithInstantPair.get().getLeft();
                    return fileGroup.getLatestFileSliceBefore(compactionInstantTime);
                }
                return Option.of(fileSlice);
            }).map(Option::get).map(this::addBootstrapBaseFileIfPresent);
            return stream;
        }
        finally {
            this.readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final Stream<FileSlice> getLatestFileSlicesBeforeOrOn(String partitionStr, String maxCommitTime, boolean includeFileSlicesInPendingCompaction) {
        try {
            this.readLock.lock();
            String partitionPath = this.formatPartitionKey(partitionStr);
            this.ensurePartitionLoadedCorrectly(partitionPath);
            Stream<Stream> allFileSliceStream = this.fetchAllStoredFileGroups(partitionPath).filter(slice -> !this.isFileGroupReplacedBeforeOrOn(slice.getFileGroupId(), maxCommitTime)).map(fg -> fg.getAllFileSlicesBeforeOn(maxCommitTime));
            if (includeFileSlicesInPendingCompaction) {
                Stream<Option> fileSliceOpts = this.tableVersion8AndAbove() ? allFileSliceStream.map(this::getLatestFileSliceFilteringUncommittedFiles) : allFileSliceStream.map(sliceStream -> sliceStream.flatMap(slice -> this.filterBaseFileAfterPendingCompaction((FileSlice)slice, false))).map(sliceStream -> Option.fromJavaOptional(sliceStream.findFirst()));
                Stream<FileSlice> stream = fileSliceOpts.filter(Option::isPresent).map(Option::get).map(this::addBootstrapBaseFileIfPresent);
                return stream;
            }
            Predicate<FileSlice> sliceFilter = slice -> !this.isPendingCompactionScheduledForFileId(slice.getFileGroupId()) && !slice.isEmpty();
            Stream<FileSlice> stream = allFileSliceStream.map(sliceStream -> this.tableVersion8AndAbove() ? this.getLatestFileSliceFilteringUncommittedFiles(sliceStream.filter(sliceFilter)) : Option.fromJavaOptional(sliceStream.filter(sliceFilter).findFirst())).filter(Option::isPresent).map(Option::get).map(this::addBootstrapBaseFileIfPresent);
            return stream;
        }
        finally {
            this.readLock.unlock();
        }
    }

    private Option<FileSlice> getLatestFileSliceFilteringUncommittedFiles(Stream<FileSlice> fileSlices) {
        return Option.fromJavaOptional(fileSlices.flatMap(fileSlice -> this.filterUncommittedFiles((FileSlice)fileSlice, false)).findFirst());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final Map<String, Stream<FileSlice>> getAllLatestFileSlicesBeforeOrOn(String maxCommitTime) {
        try {
            this.readLock.lock();
            List<String> formattedPartitionList = this.ensureAllPartitionsLoadedCorrectly();
            Map<String, Stream<FileSlice>> map = formattedPartitionList.stream().collect(Collectors.toMap(Function.identity(), partitionPath -> this.fetchAllStoredFileGroups((String)partitionPath).filter(slice -> !this.isFileGroupReplacedBeforeOrOn(slice.getFileGroupId(), maxCommitTime)).map(fg -> fg.getAllFileSlicesBeforeOn(maxCommitTime)).map(sliceStream -> this.tableVersion8AndAbove() ? this.getLatestFileSliceFilteringUncommittedFiles((Stream<FileSlice>)sliceStream) : Option.fromJavaOptional(sliceStream.flatMap(slice -> this.filterBaseFileAfterPendingCompaction((FileSlice)slice, false)).findFirst())).filter(Option::isPresent).map(Option::get).map(this::addBootstrapBaseFileIfPresent)));
            return map;
        }
        finally {
            this.readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final Stream<FileSlice> getLatestMergedFileSlicesBeforeOrOn(String partitionStr, String maxInstantTime) {
        try {
            this.readLock.lock();
            String partition = this.formatPartitionKey(partitionStr);
            this.ensurePartitionLoadedCorrectly(partition);
            Stream<FileSlice> stream = this.fetchAllStoredFileGroups(partition).filter(fg -> !this.isFileGroupReplacedBeforeOrOn(fg.getFileGroupId(), maxInstantTime)).map(fileGroup -> {
                Option<FileSlice> fileSlice = fileGroup.getLatestFileSliceBeforeOrOn(maxInstantTime);
                if (fileSlice.isPresent()) {
                    fileSlice = Option.of(this.fetchMergedFileSlice((HoodieFileGroup)fileGroup, this.tableVersion8AndAbove() ? this.filterUncommittedLogs(fileSlice.get()) : fileSlice.get()));
                }
                return fileSlice;
            }).filter(Option::isPresent).map(Option::get).map(this::addBootstrapBaseFileIfPresent);
            return stream;
        }
        finally {
            this.readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final Stream<FileSlice> getAllLogsMergedFileSliceBeforeOrOn(String partitionStr, String maxInstantTime) {
        try {
            this.readLock.lock();
            String partition = this.formatPartitionKey(partitionStr);
            this.ensurePartitionLoadedCorrectly(partition);
            Stream<FileSlice> stream = this.fetchAllStoredFileGroups(partition).filter(fg -> !this.isFileGroupReplacedBeforeOrOn(fg.getFileGroupId(), maxInstantTime)).map(fileGroup -> this.fetchAllLogsMergedFileSlice((HoodieFileGroup)fileGroup, maxInstantTime)).filter(Option::isPresent).map(Option::get).map(slice -> this.tableVersion8AndAbove() ? this.filterUncommittedLogs((FileSlice)slice) : slice).map(this::addBootstrapBaseFileIfPresent);
            return stream;
        }
        finally {
            this.readLock.unlock();
        }
    }

    @Override
    public final Stream<FileSlice> getLatestFileSliceInRange(List<String> commitsToReturn) {
        try {
            this.readLock.lock();
            Stream<FileSlice> stream = this.fetchLatestFileSliceInRange(commitsToReturn).filter(slice -> !this.isFileGroupReplacedBeforeAny(slice.getFileGroupId(), commitsToReturn)).map(this::addBootstrapBaseFileIfPresent);
            return stream;
        }
        finally {
            this.readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final Stream<FileSlice> getAllFileSlices(String partitionStr) {
        try {
            this.readLock.lock();
            String partition = this.formatPartitionKey(partitionStr);
            this.ensurePartitionLoadedCorrectly(partition);
            Stream<FileSlice> stream = this.fetchAllFileSlices(partition).filter(slice -> !this.isFileGroupReplaced(slice.getFileGroupId())).map(this::addBootstrapBaseFileIfPresent);
            return stream;
        }
        finally {
            this.readLock.unlock();
        }
    }

    private String formatPartitionKey(String partitionStr) {
        return partitionStr.endsWith("/") ? partitionStr.substring(0, partitionStr.length() - 1) : partitionStr;
    }

    @Override
    public final Stream<HoodieFileGroup> getAllFileGroups(String partitionStr) {
        return this.getAllFileGroupsIncludingReplaced(partitionStr).filter(fg -> !this.isFileGroupReplaced((HoodieFileGroup)fg));
    }

    @Override
    public final Stream<HoodieFileGroup> getAllFileGroupsStateless(String partitionStr) {
        String partition = this.formatPartitionKey(partitionStr);
        if (this.isPartitionAvailableInStore(partition)) {
            return this.getAllFileGroups(partition);
        }
        try {
            Map<HoodieFileGroupId, BootstrapBaseFileMapping> bootstrapBaseFileMappings;
            Stream<HoodieFileGroup> fileGroupStream = this.buildFileGroups(partition, this.getAllFilesInPartition(partition), this.visibleCommitsAndCompactionTimeline, true).stream().filter(fg -> !this.isFileGroupReplaced((HoodieFileGroup)fg));
            if (this.bootstrapIndex.useIndex() && !(bootstrapBaseFileMappings = this.getBootstrapBaseFileMappings(partition)).isEmpty()) {
                return fileGroupStream.map(fileGroup -> this.addBootstrapBaseFileIfPresent((HoodieFileGroup)fileGroup, (HoodieFileGroupId fileGroupId) -> Option.ofNullable(bootstrapBaseFileMappings.get(fileGroupId))));
            }
            return fileGroupStream;
        }
        catch (IOException e) {
            throw new HoodieIOException("Failed to fetch all files in partition " + partition, e);
        }
    }

    private Map<HoodieFileGroupId, BootstrapBaseFileMapping> getBootstrapBaseFileMappings(String partition) {
        try (BootstrapIndex.IndexReader reader = this.bootstrapIndex.createReader();){
            LOG.info("Bootstrap Index available for partition " + partition);
            List<BootstrapFileMapping> sourceFileMappings = reader.getSourceFileMappingForPartition(partition);
            Map<HoodieFileGroupId, BootstrapBaseFileMapping> map = sourceFileMappings.stream().map(s -> new BootstrapBaseFileMapping(new HoodieFileGroupId(s.getPartitionPath(), s.getFileId()), s.getBootstrapFileStatus())).collect(Collectors.toMap(BootstrapBaseFileMapping::getFileGroupId, s -> s));
            return map;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Stream<HoodieFileGroup> getAllFileGroupsIncludingReplaced(String partitionStr) {
        try {
            this.readLock.lock();
            String partition = this.formatPartitionKey(partitionStr);
            this.ensurePartitionLoadedCorrectly(partition);
            Stream<HoodieFileGroup> stream = this.fetchAllStoredFileGroups(partition).map(this::addBootstrapBaseFileIfPresent);
            return stream;
        }
        finally {
            this.readLock.unlock();
        }
    }

    @Override
    public Stream<HoodieFileGroup> getReplacedFileGroupsBeforeOrOn(String maxCommitTime, String partitionPath) {
        String partition = this.formatPartitionKey(partitionPath);
        if (this.hasReplacedFilesInPartition(partition)) {
            return this.getAllFileGroupsIncludingReplaced(partition).filter(fg -> this.isFileGroupReplacedBeforeOrOn(fg.getFileGroupId(), maxCommitTime));
        }
        return Stream.empty();
    }

    @Override
    public Stream<HoodieFileGroup> getReplacedFileGroupsBefore(String maxCommitTime, String partitionPath) {
        String partition = this.formatPartitionKey(partitionPath);
        if (this.hasReplacedFilesInPartition(partition)) {
            return this.getAllFileGroupsIncludingReplaced(partition).filter(fg -> this.isFileGroupReplacedBefore(fg.getFileGroupId(), maxCommitTime));
        }
        return Stream.empty();
    }

    @Override
    public Stream<HoodieFileGroup> getReplacedFileGroupsAfterOrOn(String minCommitTime, String partitionPath) {
        String partition = this.formatPartitionKey(partitionPath);
        if (this.hasReplacedFilesInPartition(partition)) {
            return this.getAllFileGroupsIncludingReplaced(partition).filter(fg -> this.isFileGroupReplacedAfterOrOn(fg.getFileGroupId(), minCommitTime));
        }
        return Stream.empty();
    }

    @Override
    public Stream<HoodieFileGroup> getAllReplacedFileGroups(String partitionPath) {
        String partition = this.formatPartitionKey(partitionPath);
        if (this.hasReplacedFilesInPartition(partition)) {
            return this.getAllFileGroupsIncludingReplaced(partition).filter(fg -> this.isFileGroupReplaced(fg.getFileGroupId()));
        }
        return Stream.empty();
    }

    @Override
    public final Stream<Pair<HoodieFileGroupId, HoodieInstant>> getFileGroupsInPendingClustering() {
        try {
            this.readLock.lock();
            Stream<Pair<HoodieFileGroupId, HoodieInstant>> stream = this.fetchFileGroupsInPendingClustering();
            return stream;
        }
        finally {
            this.readLock.unlock();
        }
    }

    protected abstract boolean isPendingCompactionScheduledForFileId(HoodieFileGroupId var1);

    abstract void resetPendingCompactionOperations(Stream<Pair<String, CompactionOperation>> var1);

    abstract void addPendingCompactionOperations(Stream<Pair<String, CompactionOperation>> var1);

    abstract void removePendingCompactionOperations(Stream<Pair<String, CompactionOperation>> var1);

    protected abstract boolean isPendingLogCompactionScheduledForFileId(HoodieFileGroupId var1);

    abstract void resetPendingLogCompactionOperations(Stream<Pair<String, CompactionOperation>> var1);

    abstract void addPendingLogCompactionOperations(Stream<Pair<String, CompactionOperation>> var1);

    abstract void removePendingLogCompactionOperations(Stream<Pair<String, CompactionOperation>> var1);

    protected abstract boolean isPendingClusteringScheduledForFileId(HoodieFileGroupId var1);

    protected abstract Option<HoodieInstant> getPendingClusteringInstant(HoodieFileGroupId var1);

    protected abstract Stream<Pair<HoodieFileGroupId, HoodieInstant>> fetchFileGroupsInPendingClustering();

    abstract void resetFileGroupsInPendingClustering(Map<HoodieFileGroupId, HoodieInstant> var1);

    abstract void addFileGroupsInPendingClustering(Stream<Pair<HoodieFileGroupId, HoodieInstant>> var1);

    abstract void removeFileGroupsInPendingClustering(Stream<Pair<HoodieFileGroupId, HoodieInstant>> var1);

    protected abstract Option<Pair<String, CompactionOperation>> getPendingCompactionOperationWithInstant(HoodieFileGroupId var1);

    protected abstract Option<Pair<String, CompactionOperation>> getPendingLogCompactionOperationWithInstant(HoodieFileGroupId var1);

    abstract Stream<Pair<String, CompactionOperation>> fetchPendingCompactionOperations();

    abstract Stream<Pair<String, CompactionOperation>> fetchPendingLogCompactionOperations();

    protected abstract boolean isBootstrapBaseFilePresentForFileId(HoodieFileGroupId var1);

    abstract void resetBootstrapBaseFileMapping(Stream<BootstrapBaseFileMapping> var1);

    abstract void addBootstrapBaseFileMapping(Stream<BootstrapBaseFileMapping> var1);

    abstract void removeBootstrapBaseFileMapping(Stream<BootstrapBaseFileMapping> var1);

    protected abstract Option<BootstrapBaseFileMapping> getBootstrapBaseFile(HoodieFileGroupId var1);

    abstract Stream<BootstrapBaseFileMapping> fetchBootstrapBaseFiles();

    abstract boolean isPartitionAvailableInStore(String var1);

    abstract void storePartitionView(String var1, List<HoodieFileGroup> var2);

    abstract Stream<HoodieFileGroup> fetchAllStoredFileGroups(String var1);

    abstract Stream<HoodieFileGroup> fetchAllStoredFileGroups();

    protected abstract void resetReplacedFileGroups(Map<HoodieFileGroupId, HoodieInstant> var1);

    protected abstract void addReplacedFileGroups(Map<HoodieFileGroupId, HoodieInstant> var1);

    protected abstract void removeReplacedFileIdsAtInstants(Set<String> var1);

    protected abstract boolean hasReplacedFilesInPartition(String var1);

    protected abstract Option<HoodieInstant> getReplaceInstant(HoodieFileGroupId var1);

    abstract boolean isClosed();

    Stream<FileSlice> fetchLatestFileSliceInRange(List<String> commitsToReturn) {
        return this.fetchAllStoredFileGroups().map(fileGroup -> fileGroup.getLatestFileSliceInRange(commitsToReturn)).map(Option::get).map(this::addBootstrapBaseFileIfPresent);
    }

    Stream<FileSlice> fetchAllFileSlices(String partitionPath) {
        return this.fetchAllStoredFileGroups(partitionPath).map(this::addBootstrapBaseFileIfPresent).flatMap(HoodieFileGroup::getAllFileSlices);
    }

    public Stream<HoodieBaseFile> fetchLatestBaseFiles(String partitionPath) {
        return this.fetchAllStoredFileGroups(partitionPath).filter(fg -> !this.isFileGroupReplaced((HoodieFileGroup)fg)).map(fg -> Pair.of(fg.getFileGroupId(), this.getLatestBaseFile((HoodieFileGroup)fg))).filter(p -> ((Option)p.getValue()).isPresent()).map(p -> this.addBootstrapBaseFileIfPresent((HoodieFileGroupId)p.getKey(), (HoodieBaseFile)((Option)p.getValue()).get()));
    }

    protected Option<HoodieBaseFile> getLatestBaseFile(HoodieFileGroup fileGroup) {
        return Option.fromJavaOptional(fileGroup.getAllBaseFiles().filter(df -> !this.isBaseFileDueToPendingCompaction(fileGroup.getPartitionPath(), (HoodieBaseFile)df) && !this.isBaseFileDueToPendingClustering((HoodieBaseFile)df)).findFirst());
    }

    private Stream<HoodieBaseFile> fetchLatestBaseFiles() {
        return this.fetchAllStoredFileGroups().filter(fg -> !this.isFileGroupReplaced((HoodieFileGroup)fg)).map(fg -> Pair.of(fg.getFileGroupId(), this.getLatestBaseFile((HoodieFileGroup)fg))).filter(p -> ((Option)p.getValue()).isPresent()).map(p -> this.addBootstrapBaseFileIfPresent((HoodieFileGroupId)p.getKey(), (HoodieBaseFile)((Option)p.getValue()).get()));
    }

    Stream<HoodieBaseFile> fetchAllBaseFiles(String partitionPath) {
        return this.fetchAllStoredFileGroups(partitionPath).flatMap(HoodieFileGroup::getAllBaseFiles);
    }

    Option<HoodieFileGroup> fetchHoodieFileGroup(String partitionPath, String fileId) {
        return Option.fromJavaOptional(this.fetchAllStoredFileGroups(partitionPath).filter(fileGroup -> fileGroup.getFileGroupId().getFileId().equals(fileId)).findFirst());
    }

    Stream<FileSlice> fetchLatestFileSlices(String partitionPath) {
        return this.fetchAllStoredFileGroups(partitionPath).map(HoodieFileGroup::getLatestFileSlice).filter(Option::isPresent).map(Option::get);
    }

    private static FileSlice mergeCompactionPendingFileSlices(FileSlice lastSlice, FileSlice penultimateSlice) {
        FileSlice merged = new FileSlice(penultimateSlice.getPartitionPath(), penultimateSlice.getBaseInstantTime(), penultimateSlice.getFileId());
        if (penultimateSlice.getBaseFile().isPresent()) {
            merged.setBaseFile(penultimateSlice.getBaseFile().get());
        }
        penultimateSlice.getLogFiles().forEach(merged::addLogFile);
        lastSlice.getLogFiles().forEach(merged::addLogFile);
        return merged;
    }

    private FileSlice fetchMergedFileSlice(HoodieFileGroup fileGroup, FileSlice fileSlice) {
        Option<Pair<String, CompactionOperation>> compactionOpWithInstant = this.getPendingCompactionOperationWithInstant(fileGroup.getFileGroupId());
        if (compactionOpWithInstant.isPresent()) {
            Option<FileSlice> prevFileSlice;
            String compactionInstantTime = compactionOpWithInstant.get().getKey();
            if (fileSlice.getBaseInstantTime().equals(compactionInstantTime) && (prevFileSlice = fileGroup.getLatestFileSliceBefore(compactionInstantTime)).isPresent()) {
                return AbstractTableFileSystemView.mergeCompactionPendingFileSlices(fileSlice, prevFileSlice.get());
            }
        }
        return fileSlice;
    }

    private Option<FileSlice> fetchAllLogsMergedFileSlice(HoodieFileGroup fileGroup, String maxInstantTime) {
        List<FileSlice> fileSlices = fileGroup.getAllFileSlicesBeforeOn(maxInstantTime).collect(Collectors.toList());
        if (fileSlices.size() == 0) {
            return Option.empty();
        }
        if (fileSlices.size() == 1) {
            return Option.of(fileSlices.get(0));
        }
        FileSlice latestSlice = (FileSlice)fileSlices.get(0);
        FileSlice merged = new FileSlice(latestSlice.getPartitionPath(), latestSlice.getBaseInstantTime(), latestSlice.getFileId());
        fileSlices.forEach(slice -> slice.getLogFiles().forEach(merged::addLogFile));
        return Option.of(merged);
    }

    protected Option<HoodieBaseFile> fetchLatestBaseFile(String partitionPath, String fileId) {
        return Option.fromJavaOptional(this.fetchLatestBaseFiles(partitionPath).filter(fs -> fs.getFileId().equals(fileId)).findFirst());
    }

    public Option<FileSlice> fetchLatestFileSlice(String partitionPath, String fileId) {
        return Option.fromJavaOptional(this.fetchLatestFileSlices(partitionPath).filter(fs -> fs.getFileId().equals(fileId)).findFirst());
    }

    private boolean isFileGroupReplaced(String partitionPath, String fileId) {
        return this.isFileGroupReplaced(new HoodieFileGroupId(partitionPath, fileId));
    }

    private boolean isFileGroupReplaced(HoodieFileGroup fileGroup) {
        return this.isFileGroupReplaced(fileGroup.getFileGroupId());
    }

    private boolean isFileGroupReplaced(HoodieFileGroupId fileGroup) {
        return this.getReplaceInstant(fileGroup).isPresent();
    }

    private boolean isFileGroupReplacedBeforeAny(HoodieFileGroupId fileGroupId, List<String> instants) {
        return this.isFileGroupReplacedBeforeOrOn(fileGroupId, (String)instants.stream().max(Comparator.naturalOrder()).get());
    }

    private boolean isFileGroupReplacedBefore(HoodieFileGroupId fileGroupId, String instant) {
        Option<HoodieInstant> hoodieInstantOption = this.getReplaceInstant(fileGroupId);
        if (!hoodieInstantOption.isPresent()) {
            return false;
        }
        return InstantComparison.compareTimestamps(instant, InstantComparison.GREATER_THAN, hoodieInstantOption.get().requestedTime());
    }

    private boolean isFileGroupReplacedBeforeOrOn(HoodieFileGroupId fileGroupId, String instant) {
        Option<HoodieInstant> hoodieInstantOption = this.getReplaceInstant(fileGroupId);
        if (!hoodieInstantOption.isPresent()) {
            return false;
        }
        return InstantComparison.compareTimestamps(instant, InstantComparison.GREATER_THAN_OR_EQUALS, hoodieInstantOption.get().requestedTime());
    }

    private boolean isFileGroupReplacedAfterOrOn(HoodieFileGroupId fileGroupId, String instant) {
        Option<HoodieInstant> hoodieInstantOption = this.getReplaceInstant(fileGroupId);
        if (!hoodieInstantOption.isPresent()) {
            return false;
        }
        return InstantComparison.compareTimestamps(instant, InstantComparison.LESSER_THAN_OR_EQUALS, hoodieInstantOption.get().requestedTime());
    }

    @Override
    public Option<HoodieInstant> getLastInstant() {
        return this.getTimeline().lastInstant();
    }

    @Override
    public HoodieTimeline getTimeline() {
        return this.visibleCommitsAndCompactionTimeline;
    }

    @Override
    public void sync() {
        try {
            this.writeLock.lock();
            HoodieTimeline newTimeline = this.metaClient.reloadActiveTimeline().filterCompletedOrMajorOrMinorCompactionInstants();
            this.clear();
            this.init(this.metaClient, newTimeline);
        }
        finally {
            this.writeLock.unlock();
        }
    }

    public HoodieTimeline getVisibleCommitsAndCompactionTimeline() {
        return this.visibleCommitsAndCompactionTimeline;
    }

    /*
     * Unable to fully structure code
     */
    private /* synthetic */ Boolean lambda$ensurePartitionLoadedCorrectly$17(String partitionPathStr) {
        beginTs = System.currentTimeMillis();
        if (!this.isPartitionAvailableInStore(partitionPathStr)) {
            try {
                AbstractTableFileSystemView.LOG.info("Building file system view for partition (" + partitionPathStr + ")");
                groups = this.addFilesToView(partitionPathStr, this.getAllFilesInPartition(partitionPathStr));
                if (!groups.isEmpty()) ** GOTO lbl12
                this.storePartitionView(partitionPathStr, new ArrayList<HoodieFileGroup>());
            }
            catch (IOException e) {
                throw new HoodieIOException("Failed to list base files in partition " + partitionPathStr, e);
            }
        } else {
            AbstractTableFileSystemView.LOG.debug("View already built for Partition :" + partitionPathStr + ", FOUND is ");
        }
lbl12:
        // 3 sources

        endTs = System.currentTimeMillis();
        AbstractTableFileSystemView.LOG.debug("Time to load partition (" + partitionPathStr + ") =" + (endTs - beginTs));
        return true;
    }
}

