/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.common.table.timeline.versioning.v1;

import java.util.Date;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.hudi.common.table.timeline.HoodieInstant;
import org.apache.hudi.common.table.timeline.HoodieInstantTimeGenerator;
import org.apache.hudi.common.table.timeline.InstantGenerator;
import org.apache.hudi.common.table.timeline.versioning.v1.InstantComparatorV1;
import org.apache.hudi.storage.StoragePathInfo;

public class InstantGeneratorV1
implements InstantGenerator {
    private static final Pattern NAME_FORMAT = Pattern.compile("^(\\d+)(\\.\\w+)(\\.\\D+)?$");
    private static final String DELIMITER = ".";

    @Override
    public HoodieInstant createNewInstant(HoodieInstant.State state, String action, String timestamp) {
        return new HoodieInstant(state, action, timestamp, InstantComparatorV1.REQUESTED_TIME_BASED_COMPARATOR);
    }

    @Override
    public HoodieInstant createNewInstant(HoodieInstant.State state, String action, String timestamp, String completionTime) {
        return new HoodieInstant(state, action, timestamp, completionTime, InstantComparatorV1.REQUESTED_TIME_BASED_COMPARATOR);
    }

    @Override
    public HoodieInstant createNewInstant(HoodieInstant.State state, String action, String timestamp, String completionTime, boolean isLegacy) {
        return new HoodieInstant(state, action, timestamp, completionTime, isLegacy, InstantComparatorV1.REQUESTED_TIME_BASED_COMPARATOR);
    }

    @Override
    public HoodieInstant createNewInstant(StoragePathInfo pathInfo) {
        String fileName = pathInfo.getPath().getName();
        String timestamp = null;
        String stateTransitionTime = null;
        String action = null;
        HoodieInstant.State state = HoodieInstant.State.NIL;
        Matcher matcher = NAME_FORMAT.matcher(fileName);
        if (matcher.find()) {
            timestamp = matcher.group(1);
            if (matcher.group(2).equals(".inflight")) {
                action = "commit";
                state = HoodieInstant.State.INFLIGHT;
            } else {
                action = matcher.group(2).replaceFirst(DELIMITER, "");
                state = matcher.groupCount() == 3 && matcher.group(3) != null ? HoodieInstant.State.valueOf(matcher.group(3).replaceFirst(DELIMITER, "").toUpperCase()) : HoodieInstant.State.COMPLETED;
            }
        } else {
            throw new IllegalArgumentException("Failed to construct HoodieInstant: " + String.format("The provided file name %s does not conform to the required format", fileName));
        }
        stateTransitionTime = HoodieInstantTimeGenerator.formatDate(new Date(pathInfo.getModificationTime()));
        return new HoodieInstant(state, action, timestamp, stateTransitionTime, true, InstantComparatorV1.REQUESTED_TIME_BASED_COMPARATOR);
    }

    @Override
    public HoodieInstant getRequestedInstant(HoodieInstant instant) {
        return new HoodieInstant(HoodieInstant.State.REQUESTED, instant.getAction(), instant.requestedTime(), InstantComparatorV1.REQUESTED_TIME_BASED_COMPARATOR);
    }

    @Override
    public HoodieInstant getCleanRequestedInstant(String timestamp) {
        return new HoodieInstant(HoodieInstant.State.REQUESTED, "clean", timestamp, InstantComparatorV1.REQUESTED_TIME_BASED_COMPARATOR);
    }

    @Override
    public HoodieInstant getCleanInflightInstant(String timestamp) {
        return new HoodieInstant(HoodieInstant.State.INFLIGHT, "clean", timestamp, InstantComparatorV1.REQUESTED_TIME_BASED_COMPARATOR);
    }

    @Override
    public HoodieInstant getCompactionRequestedInstant(String timestamp) {
        return new HoodieInstant(HoodieInstant.State.REQUESTED, "compaction", timestamp, InstantComparatorV1.REQUESTED_TIME_BASED_COMPARATOR);
    }

    @Override
    public HoodieInstant getCompactionInflightInstant(String timestamp) {
        return new HoodieInstant(HoodieInstant.State.INFLIGHT, "compaction", timestamp, InstantComparatorV1.REQUESTED_TIME_BASED_COMPARATOR);
    }

    @Override
    public HoodieInstant getLogCompactionRequestedInstant(String timestamp) {
        return new HoodieInstant(HoodieInstant.State.REQUESTED, "logcompaction", timestamp, InstantComparatorV1.REQUESTED_TIME_BASED_COMPARATOR);
    }

    @Override
    public HoodieInstant getLogCompactionInflightInstant(String timestamp) {
        return new HoodieInstant(HoodieInstant.State.INFLIGHT, "logcompaction", timestamp, InstantComparatorV1.REQUESTED_TIME_BASED_COMPARATOR);
    }

    @Override
    public HoodieInstant getReplaceCommitRequestedInstant(String timestamp) {
        return new HoodieInstant(HoodieInstant.State.REQUESTED, "replacecommit", timestamp, InstantComparatorV1.REQUESTED_TIME_BASED_COMPARATOR);
    }

    @Override
    public HoodieInstant getReplaceCommitInflightInstant(String timestamp) {
        return new HoodieInstant(HoodieInstant.State.INFLIGHT, "replacecommit", timestamp, InstantComparatorV1.REQUESTED_TIME_BASED_COMPARATOR);
    }

    @Override
    public HoodieInstant getRollbackRequestedInstant(HoodieInstant instant) {
        return instant.isRequested() ? instant : this.getRequestedInstant(instant);
    }

    @Override
    public HoodieInstant getRestoreRequestedInstant(HoodieInstant instant) {
        return instant.isRequested() ? instant : this.getRequestedInstant(instant);
    }

    @Override
    public HoodieInstant getIndexRequestedInstant(String timestamp) {
        return new HoodieInstant(HoodieInstant.State.REQUESTED, "indexing", timestamp, InstantComparatorV1.REQUESTED_TIME_BASED_COMPARATOR);
    }

    @Override
    public HoodieInstant getIndexInflightInstant(String timestamp) {
        return new HoodieInstant(HoodieInstant.State.INFLIGHT, "indexing", timestamp, InstantComparatorV1.REQUESTED_TIME_BASED_COMPARATOR);
    }

    @Override
    public HoodieInstant getClusteringCommitRequestedInstant(String timestamp) {
        return this.getReplaceCommitRequestedInstant(timestamp);
    }

    @Override
    public HoodieInstant getClusteringCommitInflightInstant(String timestamp) {
        return this.getReplaceCommitInflightInstant(timestamp);
    }
}

