/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.common.table.timeline.versioning.v1;

import java.io.Serializable;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import org.apache.hudi.common.table.timeline.HoodieInstant;
import org.apache.hudi.common.table.timeline.InstantComparator;
import org.apache.hudi.common.table.timeline.versioning.common.InstantComparators;

public class InstantComparatorV1
implements Serializable,
InstantComparator {
    private static final Map<String, String> COMPARABLE_ACTIONS = InstantComparatorV1.createComparableActionsMap();
    public static final Comparator<HoodieInstant> ACTION_COMPARATOR = new InstantComparators.ActionComparator(COMPARABLE_ACTIONS);
    public static final Comparator<HoodieInstant> REQUESTED_TIME_BASED_COMPARATOR = new InstantComparators.RequestedTimeBasedComparator(COMPARABLE_ACTIONS);
    public static final Comparator<HoodieInstant> COMPLETION_TIME_BASED_COMPARATOR = new InstantComparators.CompletionTimeBasedComparator(COMPARABLE_ACTIONS);

    public static String getComparableAction(String action) {
        return COMPARABLE_ACTIONS.getOrDefault(action, action);
    }

    private static final Map<String, String> createComparableActionsMap() {
        HashMap<String, String> comparableMap = new HashMap<String, String>();
        comparableMap.put("compaction", "commit");
        comparableMap.put("logcompaction", "deltacommit");
        return comparableMap;
    }

    @Override
    public Comparator<HoodieInstant> actionOnlyComparator() {
        return ACTION_COMPARATOR;
    }

    @Override
    public Comparator<HoodieInstant> requestedTimeOrderedComparator() {
        return REQUESTED_TIME_BASED_COMPARATOR;
    }

    @Override
    public Comparator<HoodieInstant> completionTimeOrderedComparator() {
        return COMPLETION_TIME_BASED_COMPARATOR;
    }
}

