/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.common.table.timeline;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.hudi.common.table.HoodieTableMetaClient;
import org.apache.hudi.common.table.timeline.HoodieInstant;
import org.apache.hudi.common.table.timeline.HoodieTimeline;
import org.apache.hudi.common.table.timeline.InstantComparison;
import org.apache.hudi.common.table.timeline.InstantGenerator;
import org.apache.hudi.common.util.Option;
import org.apache.hudi.common.util.collection.Pair;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TimelineDiffHelper {
    private static final Logger LOG = LoggerFactory.getLogger(TimelineDiffHelper.class);

    private TimelineDiffHelper() {
    }

    public static TimelineDiffResult getNewInstantsForIncrementalSync(HoodieTableMetaClient metaClient, HoodieTimeline oldTimeline, HoodieTimeline newTimeline) {
        HoodieTimeline oldT = oldTimeline.filterCompletedAndCompactionInstants();
        HoodieTimeline newT = newTimeline.filterCompletedAndCompactionInstants();
        Option<HoodieInstant> lastSeenInstant = oldT.lastInstant();
        Option<HoodieInstant> firstInstantInNewTimeline = newT.firstInstant();
        if (lastSeenInstant.isPresent() && firstInstantInNewTimeline.isPresent()) {
            if (InstantComparison.compareTimestamps(lastSeenInstant.get().requestedTime(), InstantComparison.LESSER_THAN, firstInstantInNewTimeline.get().requestedTime())) {
                return TimelineDiffResult.UNSAFE_SYNC_RESULT;
            }
            Set oldTimelineInstants = oldT.getInstantsAsStream().collect(Collectors.toSet());
            ArrayList<HoodieInstant> newInstants = new ArrayList<HoodieInstant>();
            List<Pair<HoodieInstant, HoodieInstant>> compactionInstants = TimelineDiffHelper.getPendingActionTransitions(metaClient, oldT.filterPendingCompactionTimeline(), newT, "commit", "compaction");
            List lostPendingCompactions = compactionInstants.stream().filter(instantPair -> instantPair.getValue() == null).map(Pair::getKey).collect(Collectors.toList());
            if (!lostPendingCompactions.isEmpty()) {
                LOG.warn("Some pending compactions are no longer in new timeline (unscheduled ?). They are: {}", lostPendingCompactions);
                return TimelineDiffResult.UNSAFE_SYNC_RESULT;
            }
            List<HoodieInstant> finishedCompactionInstants = compactionInstants.stream().filter(instantPair -> ((HoodieInstant)instantPair.getValue()).getAction().equals("commit") && ((HoodieInstant)instantPair.getValue()).isCompleted()).map(Pair::getKey).collect(Collectors.toList());
            newTimeline.getInstantsAsStream().filter(instant -> !oldTimelineInstants.contains(instant)).forEach(newInstants::add);
            List<Pair<HoodieInstant, HoodieInstant>> logCompactionInstants = TimelineDiffHelper.getPendingActionTransitions(metaClient, oldTimeline.filterPendingLogCompactionTimeline(), newTimeline, "deltacommit", "logcompaction");
            List<HoodieInstant> finishedOrRemovedLogCompactionInstants = logCompactionInstants.stream().filter(instantPair -> !((HoodieInstant)instantPair.getKey()).isCompleted() && (instantPair.getValue() == null || ((HoodieInstant)instantPair.getValue()).isCompleted())).map(Pair::getKey).collect(Collectors.toList());
            return new TimelineDiffResult(newInstants, finishedCompactionInstants, finishedOrRemovedLogCompactionInstants, true);
        }
        LOG.warn("One or more timelines is empty");
        return TimelineDiffResult.UNSAFE_SYNC_RESULT;
    }

    private static List<Pair<HoodieInstant, HoodieInstant>> getPendingActionTransitions(HoodieTableMetaClient metaClient, HoodieTimeline pendingActionTimelineFromOld, HoodieTimeline newTimeline, String completedAction, String pendingAction) {
        Set newTimelineInstants = newTimeline.getInstantsAsStream().collect(Collectors.toSet());
        InstantGenerator factory = metaClient.getInstantGenerator();
        return pendingActionTimelineFromOld.getInstantsAsStream().map(instant -> {
            if (newTimelineInstants.contains(instant)) {
                return Pair.of(instant, instant);
            }
            HoodieInstant completedInstant = factory.createNewInstant(HoodieInstant.State.COMPLETED, completedAction, instant.requestedTime());
            if (newTimelineInstants.contains(completedInstant)) {
                return Pair.of(instant, completedInstant);
            }
            HoodieInstant inflightInstant = factory.createNewInstant(HoodieInstant.State.INFLIGHT, pendingAction, instant.requestedTime());
            if (newTimelineInstants.contains(inflightInstant)) {
                return Pair.of(instant, inflightInstant);
            }
            return Pair.of(instant, null);
        }).collect(Collectors.toList());
    }

    public static class TimelineDiffResult {
        private final List<HoodieInstant> newlySeenInstants;
        private final List<HoodieInstant> finishedCompactionInstants;
        private final List<HoodieInstant> finishedOrRemovedLogCompactionInstants;
        private final boolean canSyncIncrementally;
        public static final TimelineDiffResult UNSAFE_SYNC_RESULT = new TimelineDiffResult(null, null, null, false);

        public TimelineDiffResult(List<HoodieInstant> newlySeenInstants, List<HoodieInstant> finishedCompactionInstants, List<HoodieInstant> finishedOrRemovedLogCompactionInstants, boolean canSyncIncrementally) {
            this.newlySeenInstants = newlySeenInstants;
            this.finishedCompactionInstants = finishedCompactionInstants;
            this.finishedOrRemovedLogCompactionInstants = finishedOrRemovedLogCompactionInstants;
            this.canSyncIncrementally = canSyncIncrementally;
        }

        public List<HoodieInstant> getNewlySeenInstants() {
            return this.newlySeenInstants;
        }

        public List<HoodieInstant> getFinishedCompactionInstants() {
            return this.finishedCompactionInstants;
        }

        public List<HoodieInstant> getFinishedOrRemovedLogCompactionInstants() {
            return this.finishedOrRemovedLogCompactionInstants;
        }

        public boolean canSyncIncrementally() {
            return this.canSyncIncrementally;
        }

        public String toString() {
            return "TimelineDiffResult{newlySeenInstants=" + this.newlySeenInstants + ", finishedCompactionInstants=" + this.finishedCompactionInstants + ", finishedOrRemovedLogCompactionInstants=" + this.finishedOrRemovedLogCompactionInstants + ", canSyncIncrementally=" + this.canSyncIncrementally + '}';
        }
    }
}

