/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.common.table.timeline;

import java.util.Objects;
import java.util.function.BiPredicate;
import org.apache.hudi.common.table.timeline.HoodieInstant;
import org.apache.hudi.common.util.StringUtils;

public class InstantComparison {
    public static final BiPredicate<String, String> EQUALS = (commit1, commit2) -> commit1.compareTo((String)commit2) == 0;
    public static final BiPredicate<String, String> GREATER_THAN_OR_EQUALS = (commit1, commit2) -> commit1.compareTo((String)commit2) >= 0;
    public static final BiPredicate<String, String> GREATER_THAN = (commit1, commit2) -> commit1.compareTo((String)commit2) > 0;
    public static final BiPredicate<String, String> LESSER_THAN_OR_EQUALS = (commit1, commit2) -> commit1.compareTo((String)commit2) <= 0;
    public static final BiPredicate<String, String> LESSER_THAN = (commit1, commit2) -> commit1.compareTo((String)commit2) < 0;

    public static boolean compareTimestamps(String commit1, BiPredicate<String, String> predicateToApply, String commit2) {
        return predicateToApply.test(commit1, commit2);
    }

    public static String minTimestamp(String commit1, String commit2) {
        if (StringUtils.isNullOrEmpty(commit1)) {
            return commit2;
        }
        if (StringUtils.isNullOrEmpty(commit2)) {
            return commit1;
        }
        return InstantComparison.minInstant(commit1, commit2);
    }

    public static HoodieInstant minTimestampInstant(HoodieInstant instant1, HoodieInstant instant2) {
        String commit1 = instant1 != null ? instant1.requestedTime() : null;
        String commit2 = instant2 != null ? instant2.requestedTime() : null;
        String minTimestamp = InstantComparison.minTimestamp(commit1, commit2);
        return Objects.equals(minTimestamp, commit1) ? instant1 : instant2;
    }

    public static String minInstant(String instant1, String instant2) {
        return InstantComparison.compareTimestamps(instant1, LESSER_THAN, instant2) ? instant1 : instant2;
    }

    public static String maxInstant(String instant1, String instant2) {
        return InstantComparison.compareTimestamps(instant1, GREATER_THAN, instant2) ? instant1 : instant2;
    }

    public static boolean isInRange(String timestamp, String startTs, String endTs) {
        return InstantComparison.compareTimestamps(timestamp, GREATER_THAN, startTs) && InstantComparison.compareTimestamps(timestamp, LESSER_THAN_OR_EQUALS, endTs);
    }

    public static boolean isInClosedOpenRange(String timestamp, String startTs, String endTs) {
        return InstantComparison.compareTimestamps(timestamp, GREATER_THAN_OR_EQUALS, startTs) && InstantComparison.compareTimestamps(timestamp, LESSER_THAN, endTs);
    }

    public static boolean isInClosedRange(String timestamp, String startTs, String endTs) {
        return InstantComparison.compareTimestamps(timestamp, GREATER_THAN_OR_EQUALS, startTs) && InstantComparison.compareTimestamps(timestamp, LESSER_THAN_OR_EQUALS, endTs);
    }
}

