/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.common.table.log.block;

import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import org.apache.avro.Schema;
import org.apache.hudi.common.config.HoodieStorageConfig;
import org.apache.hudi.common.engine.HoodieReaderContext;
import org.apache.hudi.common.model.HoodieFileFormat;
import org.apache.hudi.common.model.HoodieRecord;
import org.apache.hudi.common.table.log.block.HoodieDataBlock;
import org.apache.hudi.common.table.log.block.HoodieLogBlock;
import org.apache.hudi.common.util.ConfigUtils;
import org.apache.hudi.common.util.Option;
import org.apache.hudi.common.util.collection.ClosableIterator;
import org.apache.hudi.io.SeekableDataInputStream;
import org.apache.hudi.io.storage.HoodieIOFactory;
import org.apache.hudi.storage.HoodieStorage;
import org.apache.hudi.storage.StorageConfiguration;
import org.apache.hudi.storage.StoragePath;
import org.apache.hudi.storage.inline.InLineFSUtils;

public class HoodieParquetDataBlock
extends HoodieDataBlock {
    private final Option<String> compressionCodecName;
    private final Option<Double> expectedCompressionRatio;
    private final Option<Boolean> useDictionaryEncoding;

    public HoodieParquetDataBlock(Supplier<SeekableDataInputStream> inputStreamSupplier, Option<byte[]> content, boolean readBlockLazily, HoodieLogBlock.HoodieLogBlockContentLocation logBlockContentLocation, Option<Schema> readerSchema, Map<HoodieLogBlock.HeaderMetadataType, String> header, Map<HoodieLogBlock.FooterMetadataType, String> footer, String keyField) {
        super(content, inputStreamSupplier, readBlockLazily, Option.of(logBlockContentLocation), readerSchema, header, footer, keyField, false);
        this.compressionCodecName = Option.empty();
        this.expectedCompressionRatio = Option.empty();
        this.useDictionaryEncoding = Option.empty();
    }

    public HoodieParquetDataBlock(List<HoodieRecord> records, Map<HoodieLogBlock.HeaderMetadataType, String> header, String keyField, String compressionCodecName, double expectedCompressionRatio, boolean useDictionaryEncoding) {
        super(records, header, new HashMap<HoodieLogBlock.FooterMetadataType, String>(), keyField);
        this.compressionCodecName = Option.of(compressionCodecName);
        this.expectedCompressionRatio = Option.of(expectedCompressionRatio);
        this.useDictionaryEncoding = Option.of(useDictionaryEncoding);
    }

    @Override
    public HoodieLogBlock.HoodieLogBlockType getBlockType() {
        return HoodieLogBlock.HoodieLogBlockType.PARQUET_DATA_BLOCK;
    }

    @Override
    protected byte[] serializeRecords(List<HoodieRecord> records, HoodieStorage storage) throws IOException {
        HashMap<String, String> paramsMap = new HashMap<String, String>();
        paramsMap.put(HoodieStorageConfig.PARQUET_COMPRESSION_CODEC_NAME.key(), this.compressionCodecName.get());
        paramsMap.put(HoodieStorageConfig.PARQUET_COMPRESSION_RATIO_FRACTION.key(), String.valueOf(this.expectedCompressionRatio.get()));
        paramsMap.put(HoodieStorageConfig.PARQUET_DICTIONARY_ENABLED.key(), String.valueOf(this.useDictionaryEncoding.get()));
        Schema writerSchema = new Schema.Parser().parse(super.getLogBlockHeader().get((Object)HoodieLogBlock.HeaderMetadataType.SCHEMA));
        return HoodieIOFactory.getIOFactory(storage).getFileFormatUtils(HoodieFileFormat.PARQUET).serializeRecordsToLogBlock(storage, records, writerSchema, this.getSchema(), this.getKeyFieldName(), paramsMap);
    }

    @Override
    protected <T> ClosableIterator<HoodieRecord<T>> readRecordsFromBlockPayload(HoodieRecord.HoodieRecordType type) throws IOException {
        HoodieLogBlock.HoodieLogBlockContentLocation blockContentLoc = this.getBlockContentLocation().get();
        StorageConfiguration<?> inlineConf = blockContentLoc.getStorage().getConf().getInline();
        StoragePath inlineLogFilePath = InLineFSUtils.getInlineFilePath(blockContentLoc.getLogFile().getPath(), blockContentLoc.getLogFile().getPath().toUri().getScheme(), blockContentLoc.getContentPositionInLogFile(), blockContentLoc.getBlockSize());
        HoodieStorage inlineStorage = this.getBlockContentLocation().get().getStorage().newInstance(inlineLogFilePath, inlineConf);
        Schema writerSchema = new Schema.Parser().parse(this.getLogBlockHeader().get((Object)HoodieLogBlock.HeaderMetadataType.SCHEMA));
        ClosableIterator iterator2 = HoodieIOFactory.getIOFactory(inlineStorage).getReaderFactory(type).getFileReader(ConfigUtils.DEFAULT_HUDI_CONFIG_FOR_READER, inlineLogFilePath, HoodieFileFormat.PARQUET, Option.empty()).getRecordIterator(writerSchema, this.readerSchema);
        return iterator2;
    }

    @Override
    protected <T> ClosableIterator<T> readRecordsFromBlockPayload(HoodieReaderContext<T> readerContext) throws IOException {
        HoodieLogBlock.HoodieLogBlockContentLocation blockContentLoc = this.getBlockContentLocation().get();
        StorageConfiguration<?> inlineConf = blockContentLoc.getStorage().getConf().getInline();
        StoragePath inlineLogFilePath = InLineFSUtils.getInlineFilePath(blockContentLoc.getLogFile().getPath(), blockContentLoc.getLogFile().getPath().toUri().getScheme(), blockContentLoc.getContentPositionInLogFile(), blockContentLoc.getBlockSize());
        HoodieStorage inlineStorage = blockContentLoc.getStorage().newInstance(inlineLogFilePath, inlineConf);
        Schema writerSchema = new Schema.Parser().parse(this.getLogBlockHeader().get((Object)HoodieLogBlock.HeaderMetadataType.SCHEMA));
        return readerContext.getFileRecordIterator(inlineLogFilePath, 0L, blockContentLoc.getBlockSize(), writerSchema, this.readerSchema, inlineStorage);
    }

    @Override
    protected <T> ClosableIterator<HoodieRecord<T>> deserializeRecords(byte[] content, HoodieRecord.HoodieRecordType type) throws IOException {
        throw new UnsupportedOperationException("Should not be invoked");
    }

    @Override
    protected <T> ClosableIterator<T> deserializeRecords(HoodieReaderContext<T> readerContext, byte[] content) throws IOException {
        throw new UnsupportedOperationException("Should not be invoked");
    }
}

