/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.common.model;

import com.esotericsoftware.kryo.Kryo;
import com.esotericsoftware.kryo.KryoSerializable;
import com.esotericsoftware.kryo.io.Input;
import com.esotericsoftware.kryo.io.Output;
import java.io.IOException;
import java.io.Serializable;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import javax.annotation.Nullable;
import org.apache.avro.Schema;
import org.apache.avro.generic.GenericRecord;
import org.apache.hudi.common.model.HoodieKey;
import org.apache.hudi.common.model.HoodieOperation;
import org.apache.hudi.common.model.HoodieRecordCompatibilityInterface;
import org.apache.hudi.common.model.HoodieRecordLocation;
import org.apache.hudi.common.model.MetadataValues;
import org.apache.hudi.common.util.CollectionUtils;
import org.apache.hudi.common.util.Option;
import org.apache.hudi.common.util.collection.Pair;
import org.apache.hudi.keygen.BaseKeyGenerator;

public abstract class HoodieRecord<T>
implements HoodieRecordCompatibilityInterface,
KryoSerializable,
Serializable {
    private static final long serialVersionUID = 3015229555587559252L;
    public static final String COMMIT_TIME_METADATA_FIELD = HoodieMetadataField.COMMIT_TIME_METADATA_FIELD.getFieldName();
    public static final String COMMIT_SEQNO_METADATA_FIELD = HoodieMetadataField.COMMIT_SEQNO_METADATA_FIELD.getFieldName();
    public static final String RECORD_KEY_METADATA_FIELD = HoodieMetadataField.RECORD_KEY_METADATA_FIELD.getFieldName();
    public static final String PARTITION_PATH_METADATA_FIELD = HoodieMetadataField.PARTITION_PATH_METADATA_FIELD.getFieldName();
    public static final String FILENAME_METADATA_FIELD = HoodieMetadataField.FILENAME_METADATA_FIELD.getFieldName();
    public static final String OPERATION_METADATA_FIELD = HoodieMetadataField.OPERATION_METADATA_FIELD.getFieldName();
    public static final String HOODIE_IS_DELETED_FIELD = "_hoodie_is_deleted";
    public static final int DEFAULT_ORDERING_VALUE = 0;
    public static final EmptyRecord SENTINEL = new EmptyRecord();
    public static final List<String> HOODIE_META_COLUMNS = CollectionUtils.createImmutableList(COMMIT_TIME_METADATA_FIELD, COMMIT_SEQNO_METADATA_FIELD, RECORD_KEY_METADATA_FIELD, PARTITION_PATH_METADATA_FIELD, FILENAME_METADATA_FIELD);
    public static final Set<String> HOODIE_META_COLUMNS_WITH_OPERATION = CollectionUtils.createImmutableSet(COMMIT_TIME_METADATA_FIELD, COMMIT_SEQNO_METADATA_FIELD, RECORD_KEY_METADATA_FIELD, PARTITION_PATH_METADATA_FIELD, FILENAME_METADATA_FIELD, OPERATION_METADATA_FIELD);
    public static final Map<String, Integer> HOODIE_META_COLUMNS_NAME_TO_POS = IntStream.range(0, HOODIE_META_COLUMNS.size()).mapToObj(idx -> Pair.of(HOODIE_META_COLUMNS.get(idx), idx)).collect(Collectors.toMap(Pair::getKey, Pair::getValue));
    public static int RECORD_KEY_META_FIELD_ORD = HOODIE_META_COLUMNS_NAME_TO_POS.get(RECORD_KEY_METADATA_FIELD);
    public static int PARTITION_PATH_META_FIELD_ORD = HOODIE_META_COLUMNS_NAME_TO_POS.get(PARTITION_PATH_METADATA_FIELD);
    public static int FILENAME_META_FIELD_ORD = HOODIE_META_COLUMNS_NAME_TO_POS.get(FILENAME_METADATA_FIELD);
    public static int COMMIT_TIME_METADATA_FIELD_ORD = HOODIE_META_COLUMNS_NAME_TO_POS.get(COMMIT_TIME_METADATA_FIELD);
    public static int COMMIT_SEQNO_METADATA_FIELD_ORD = HOODIE_META_COLUMNS_NAME_TO_POS.get(COMMIT_SEQNO_METADATA_FIELD);
    protected HoodieKey key;
    protected T data;
    protected HoodieRecordLocation currentLocation;
    protected HoodieRecordLocation newLocation;
    protected boolean ignoreIndexUpdate;
    private boolean sealed;
    protected HoodieOperation operation;
    protected Option<Map<String, String>> metaData;

    public HoodieRecord(HoodieKey key, T data) {
        this(key, data, null, Option.empty());
    }

    public HoodieRecord(HoodieKey key, T data, HoodieOperation operation, Option<Map<String, String>> metaData) {
        this.key = key;
        this.data = data;
        this.currentLocation = null;
        this.newLocation = null;
        this.sealed = false;
        this.ignoreIndexUpdate = false;
        this.operation = operation;
        this.metaData = metaData;
    }

    public HoodieRecord(HoodieKey key, T data, HoodieOperation operation, HoodieRecordLocation currentLocation, HoodieRecordLocation newLocation) {
        this.key = key;
        this.data = data;
        this.currentLocation = currentLocation;
        this.newLocation = newLocation;
        this.operation = operation;
    }

    public HoodieRecord(HoodieRecord<T> record) {
        this(record.key, record.data, record.operation, record.metaData);
        this.currentLocation = record.currentLocation;
        this.newLocation = record.newLocation;
        this.sealed = record.sealed;
        this.ignoreIndexUpdate = record.ignoreIndexUpdate;
    }

    public HoodieRecord() {
    }

    public abstract HoodieRecord<T> newInstance();

    public abstract HoodieRecord<T> newInstance(HoodieKey var1, HoodieOperation var2);

    public abstract HoodieRecord<T> newInstance(HoodieKey var1);

    public HoodieKey getKey() {
        return this.key;
    }

    public HoodieOperation getOperation() {
        return this.operation;
    }

    public abstract Comparable<?> getOrderingValue(Schema var1, Properties var2);

    public T getData() {
        if (this.data == null) {
            throw new IllegalStateException("Payload already deflated for record.");
        }
        return this.data;
    }

    public void deflate() {
        this.data = null;
    }

    public HoodieRecord setCurrentLocation(HoodieRecordLocation location) {
        this.checkState();
        assert (this.currentLocation == null);
        this.currentLocation = location;
        return this;
    }

    @Nullable
    public HoodieRecordLocation getCurrentLocation() {
        return this.currentLocation;
    }

    public void setNewLocation(HoodieRecordLocation location) {
        this.checkState();
        assert (this.newLocation == null);
        this.newLocation = location;
    }

    @Nullable
    public HoodieRecordLocation getNewLocation() {
        return this.newLocation;
    }

    public boolean isCurrentLocationKnown() {
        return this.currentLocation != null;
    }

    public long getCurrentPosition() {
        if (this.isCurrentLocationKnown()) {
            return this.currentLocation.getPosition();
        }
        return -1L;
    }

    public void setIgnoreIndexUpdate(boolean ignoreFlag) {
        this.ignoreIndexUpdate = ignoreFlag;
    }

    public boolean getIgnoreIndexUpdate() {
        return this.ignoreIndexUpdate;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        HoodieRecord that = (HoodieRecord)o;
        return Objects.equals(this.key, that.key) && Objects.equals(this.data, that.data) && Objects.equals(this.currentLocation, that.currentLocation) && Objects.equals(this.newLocation, that.newLocation) && Objects.equals(this.ignoreIndexUpdate, that.ignoreIndexUpdate);
    }

    public int hashCode() {
        return Objects.hash(this.key, this.data, this.currentLocation, this.newLocation);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("HoodieRecord{");
        sb.append("key=").append(this.key);
        sb.append(", currentLocation='").append(this.currentLocation).append('\'');
        sb.append(", newLocation='").append(this.newLocation).append('\'');
        sb.append('}');
        return sb.toString();
    }

    public String getPartitionPath() {
        assert (this.key != null);
        return this.key.getPartitionPath();
    }

    public String getRecordKey() {
        assert (this.key != null);
        return this.key.getRecordKey();
    }

    public abstract HoodieRecordType getRecordType();

    public abstract String getRecordKey(Schema var1, Option<BaseKeyGenerator> var2);

    public abstract String getRecordKey(Schema var1, String var2);

    public void seal() {
        this.sealed = true;
    }

    public void unseal() {
        this.sealed = false;
    }

    public void checkState() {
        if (this.sealed) {
            throw new UnsupportedOperationException("Not allowed to modify after sealed");
        }
    }

    protected abstract void writeRecordPayload(T var1, Kryo var2, Output var3);

    protected abstract T readRecordPayload(Kryo var1, Input var2);

    public void clearNewLocation() {
        this.checkState();
        this.newLocation = null;
    }

    public final void write(Kryo kryo, Output output) {
        kryo.writeObjectOrNull(output, (Object)this.key, HoodieKey.class);
        kryo.writeObjectOrNull(output, (Object)this.operation, HoodieOperation.class);
        kryo.writeClassAndObject(output, (Object)this.currentLocation);
        kryo.writeClassAndObject(output, (Object)this.newLocation);
        this.writeRecordPayload(this.data, kryo, output);
        kryo.writeObjectOrNull(output, (Object)this.ignoreIndexUpdate, Boolean.class);
    }

    public final void read(Kryo kryo, Input input) {
        this.key = (HoodieKey)kryo.readObjectOrNull(input, HoodieKey.class);
        this.operation = (HoodieOperation)((Object)kryo.readObjectOrNull(input, HoodieOperation.class));
        this.currentLocation = (HoodieRecordLocation)kryo.readClassAndObject(input);
        this.newLocation = (HoodieRecordLocation)kryo.readClassAndObject(input);
        this.data = this.readRecordPayload(kryo, input);
        this.ignoreIndexUpdate = (Boolean)kryo.readObjectOrNull(input, Boolean.class);
        this.sealed = true;
    }

    public abstract Object[] getColumnValues(Schema var1, String[] var2, boolean var3);

    public abstract HoodieRecord joinWith(HoodieRecord var1, Schema var2);

    public abstract HoodieRecord prependMetaFields(Schema var1, Schema var2, MetadataValues var3, Properties var4);

    public abstract HoodieRecord rewriteRecordWithNewSchema(Schema var1, Properties var2, Schema var3, Map<String, String> var4);

    public HoodieRecord rewriteRecordWithNewSchema(Schema recordSchema, Properties props, Schema newSchema) {
        return this.rewriteRecordWithNewSchema(recordSchema, props, newSchema, Collections.emptyMap());
    }

    public abstract boolean isDelete(Schema var1, Properties var2) throws IOException;

    public abstract boolean shouldIgnore(Schema var1, Properties var2) throws IOException;

    public abstract HoodieRecord<T> copy();

    public abstract Option<Map<String, String>> getMetadata();

    public static String generateSequenceId(String instantTime, int partitionId, long recordIndex) {
        return instantTime + "_" + partitionId + "_" + recordIndex;
    }

    protected static boolean hasMetaFields(Schema schema) {
        return schema.getField(RECORD_KEY_METADATA_FIELD) != null;
    }

    public static enum HoodieRecordType {
        AVRO,
        SPARK,
        HIVE;

    }

    private static class EmptyRecord
    implements GenericRecord {
        private EmptyRecord() {
        }

        public void put(int i, Object v) {
        }

        public Object get(int i) {
            return null;
        }

        public Schema getSchema() {
            return null;
        }

        public void put(String key, Object v) {
        }

        public Object get(String key) {
            return null;
        }
    }

    public static enum HoodieMetadataField {
        COMMIT_TIME_METADATA_FIELD("_hoodie_commit_time"),
        COMMIT_SEQNO_METADATA_FIELD("_hoodie_commit_seqno"),
        RECORD_KEY_METADATA_FIELD("_hoodie_record_key"),
        PARTITION_PATH_METADATA_FIELD("_hoodie_partition_path"),
        FILENAME_METADATA_FIELD("_hoodie_file_name"),
        OPERATION_METADATA_FIELD("_hoodie_operation");

        private final String fieldName;

        private HoodieMetadataField(String fieldName) {
            this.fieldName = fieldName;
        }

        public String getFieldName() {
            return this.fieldName;
        }
    }
}

