/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.common.model;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.hudi.common.config.EnumDescription;
import org.apache.hudi.common.util.StringUtils;

@EnumDescription(value="Hoodie file formats.")
public enum HoodieFileFormat {
    PARQUET(".parquet"),
    HOODIE_LOG(".log"),
    HFILE(".hfile"),
    ORC(".orc");

    public static final Set<String> BASE_FILE_EXTENSIONS;
    private final String extension;

    private HoodieFileFormat(String extension) {
        this.extension = extension;
    }

    public String getFileExtension() {
        return this.extension;
    }

    public static HoodieFileFormat fromFileExtension(String extension) {
        for (HoodieFileFormat format : HoodieFileFormat.values()) {
            if (!format.getFileExtension().equals(extension)) continue;
            return format;
        }
        throw new IllegalArgumentException("Unknown file extension :" + extension);
    }

    public static HoodieFileFormat getValue(String fileFormat) {
        if (StringUtils.isNullOrEmpty(fileFormat)) {
            return null;
        }
        return HoodieFileFormat.valueOf(fileFormat.toUpperCase());
    }

    static {
        BASE_FILE_EXTENSIONS = Arrays.stream(HoodieFileFormat.values()).map(HoodieFileFormat::getFileExtension).filter(x -> !x.equals(HOODIE_LOG.getFileExtension())).collect(Collectors.toCollection(HashSet::new));
    }
}

