/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.common.model;

import java.io.Serializable;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.hudi.avro.model.HoodieClusteringGroup;
import org.apache.hudi.common.model.ClusteringOperation;
import org.apache.hudi.common.util.Option;

public class ClusteringGroupInfo
implements Serializable {
    private List<ClusteringOperation> operations;
    private int numOutputGroups;
    private Map<String, String> extraMetadata;

    public static ClusteringGroupInfo create(HoodieClusteringGroup clusteringGroup) {
        List<ClusteringOperation> operations = clusteringGroup.getSlices().stream().map(ClusteringOperation::create).collect(Collectors.toList());
        Map<String, String> extraMetadata = clusteringGroup.getExtraMetadata();
        return new ClusteringGroupInfo(operations, clusteringGroup.getNumOutputFileGroups(), extraMetadata);
    }

    @Deprecated
    public ClusteringGroupInfo() {
    }

    private ClusteringGroupInfo(List<ClusteringOperation> operations, int numOutputGroups) {
        this(operations, numOutputGroups, null);
    }

    private ClusteringGroupInfo(List<ClusteringOperation> operations, int numOutputGroups, Map<String, String> extraMetadata) {
        this.operations = operations;
        this.numOutputGroups = numOutputGroups;
        this.extraMetadata = extraMetadata;
    }

    public List<ClusteringOperation> getOperations() {
        return this.operations;
    }

    public void setOperations(List<ClusteringOperation> operations) {
        this.operations = operations;
    }

    public int getNumOutputGroups() {
        return this.numOutputGroups;
    }

    public void setNumOutputGroups(int numOutputGroups) {
        this.numOutputGroups = numOutputGroups;
    }

    public Option<Map<String, String>> getExtraMetadata() {
        return Option.ofNullable(this.extraMetadata);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ClusteringGroupInfo that = (ClusteringGroupInfo)o;
        return Objects.equals(this.getFilePathsInGroup(), that.getFilePathsInGroup());
    }

    public int hashCode() {
        return Objects.hash(this.getFilePathsInGroup());
    }

    private String getFilePathsInGroup() {
        return this.getOperations().stream().map(op -> op.getDataFilePath()).collect(Collectors.joining(","));
    }
}

