/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.common.config;

import java.util.Map;
import java.util.Properties;
import javax.annotation.concurrent.Immutable;
import org.apache.hudi.common.config.ConfigClassProperty;
import org.apache.hudi.common.config.ConfigGroups;
import org.apache.hudi.common.config.ConfigProperty;
import org.apache.hudi.common.config.HoodieConfig;
import org.apache.hudi.common.table.HoodieTableConfig;

@ConfigClassProperty(name="Metaserver Configs", groupName=ConfigGroups.Names.WRITE_CLIENT, description="Configurations used by the Hudi Metaserver.")
@Immutable
public class HoodieMetaserverConfig
extends HoodieConfig {
    public static final String METASERVER_PREFIX = "hoodie.metaserver";
    public static final ConfigProperty<Boolean> METASERVER_ENABLE = ConfigProperty.key("hoodie.metaserver.enabled").defaultValue(false).markAdvanced().sinceVersion("0.13.0").withDocumentation("Enable Hudi metaserver for storing Hudi tables' metadata.");
    public static final ConfigProperty<String> DATABASE_NAME = HoodieTableConfig.DATABASE_NAME.markAdvanced().sinceVersion("0.13.0");
    public static final ConfigProperty<String> TABLE_NAME = HoodieTableConfig.NAME.markAdvanced().sinceVersion("0.13.0");
    public static final ConfigProperty<String> METASERVER_URLS = ConfigProperty.key("hoodie.metaserver.uris").defaultValue("thrift://localhost:9090").markAdvanced().sinceVersion("0.13.0").withDocumentation("Metaserver server uris");
    public static final ConfigProperty<Integer> METASERVER_CONNECTION_RETRIES = ConfigProperty.key("hoodie.metaserver.connect.retries").defaultValue(3).markAdvanced().sinceVersion("0.13.0").withDocumentation("Number of retries while opening a connection to metaserver");
    public static final ConfigProperty<Integer> METASERVER_CONNECTION_RETRY_DELAY = ConfigProperty.key("hoodie.metaserver.connect.retry.delay").defaultValue(1).markAdvanced().sinceVersion("0.13.0").withDocumentation("Number of seconds for the client to wait between consecutive connection attempts");

    public static Builder newBuilder() {
        return new Builder();
    }

    public boolean isMetaserverEnabled() {
        return this.getBoolean(METASERVER_ENABLE);
    }

    public String getDatabaseName() {
        return this.getString(DATABASE_NAME);
    }

    public String getTableName() {
        return this.getString(TABLE_NAME);
    }

    public String getMetaserverUris() {
        return this.getStringOrDefault(METASERVER_URLS);
    }

    public int getConnectionRetryLimit() {
        return this.getIntOrDefault(METASERVER_CONNECTION_RETRIES);
    }

    public int getConnectionRetryDelay() {
        return this.getIntOrDefault(METASERVER_CONNECTION_RETRY_DELAY);
    }

    public static class Builder {
        private final HoodieMetaserverConfig config = new HoodieMetaserverConfig();

        public Builder fromProperties(Properties props) {
            this.config.getProps().putAll((Map<?, ?>)props);
            return this;
        }

        public Builder setUris(String uris) {
            this.config.setValue(METASERVER_URLS, uris);
            return this;
        }

        public HoodieMetaserverConfig build() {
            this.config.setDefaults(HoodieMetaserverConfig.class.getName());
            return this.config;
        }
    }
}

